//
//  XTOutputFormatter.h
//  TadsTerp
//
//  Created by Rune Berg on 09/07/14.
//  Copyright (c) 2014 Rune Berg. All rights reserved.
//
//  Transforms
//		a stream of text|whitespace|html-tag elements
//	into
//		a stream of XTFormattedOutputElement with attributed strings suitable for game output.
//

#import <Foundation/Foundation.h>
#import "XTOutputFormatterProtocol.h"
#import "XTHtmlLinebreakHandler2.h"
#import "XTTextTab.h"
#import "XTHtmlColor.h"
#import "XTColorationHelper.h"


@class XTTextView;


@interface XTOutputFormatter : NSObject <XTOutputFormatterProtocol>

@property (readonly) NSTextStorage *textStorage;
@property (unsafe_unretained) XTTextView *textView;
@property (weak) XTColorationHelper *colorationHelper;

@property BOOL htmlMode;
@property BOOL isForT3;
@property BOOL isForBanner;
@property BOOL isForTagBanner;
@property BOOL isForGridBanner;
@property BOOL receivingGameTitle;

@property (readonly) BOOL needsRecalcAllTabStops;

- (void)teardown;

- (void)resetFlags;

- (void)resetForNextCommand;

- (NSArray *)flushPendingWhitespace;

- (NSArray<NSAttributedString *>*)formatOutputText:(NSString *)string;

- (NSAttributedString *)formatInputText:(NSString *)string;

- (NSAttributedString *)formatStringForGridBanner:(NSString *)string;

- (NSFont *)getCurrentFontForOutput;

- (NSFont *)getCurrentFontForGridBanner;

- (void)updateCursorColor;

- (NSArray *)handleHtmlTagText:(XTHtmlTagText *)tag;

- (void)prepareForRecalcAllOfTabStops;

- (void)prepareForRecalcAllOfTabStopsInRange:(NSRange)range;

- (void)recalcAllTabStops;

- (void)clearAfterBlockLevelSpacing;

- (void)resetTagBannerDepth;

- (NSMutableParagraphStyle *)getParagraphStyleAtStartOfOngoingParagraph;

- (NSArray *)handleHtmlTagTabWhenNotOppressed:(XTHtmlTagTab *)tag;

- (XTHtmlLinebreakHandler2State)getLineBreakHandlerState;

- (void)setLineBreakHandlerState:(XTHtmlLinebreakHandler2State)lbh2State;

- (void)executeTagBody:(XTHtmlTagBody *)tag;

- (NSArray *)cancelOngoingTable;

@end
