//
//  XTOutputTextColorResult.m
//  XTads
//
//  Created by Rune Berg on 29/03/2020.
//  Copyright © 2020 Rune Berg. All rights reserved.
//

#import "XTOutputTextColorResult.h"


@implementation XTOutputTextColorResult

@synthesize htmlColor = _htmlColor;
@synthesize colorSource = _colorSource;
@synthesize bannerTextColorFromMainAreaPrefs = _bannerTextColorFromMainAreaPrefs;

+ (instancetype)forHtmlColor:(XTHtmlColor *)htmlColor
				 colorSource:(XTColorSource)colorSource
{
	XTOutputTextColorResult *res = [[XTOutputTextColorResult alloc] initWithHtmlColor:htmlColor
																		  colorSource:colorSource
													 bannerTextColorFromMainAreaPrefs:NO];
	return res;
}

+ (instancetype)forHtmlColor:(XTHtmlColor *)htmlColor
				 colorSource:(XTColorSource)colorSource
bannerTextColorFromMainAreaPrefs:(BOOL)bannerTextColorFromMainAreaPrefs;

{
	XTOutputTextColorResult *res = [[XTOutputTextColorResult alloc] initWithHtmlColor:htmlColor
																		  colorSource:colorSource
													 bannerTextColorFromMainAreaPrefs:bannerTextColorFromMainAreaPrefs];
	return res;
}

- (instancetype)initWithHtmlColor:(XTHtmlColor *)htmlColor
					  colorSource:(XTColorSource)colorSource
 bannerTextColorFromMainAreaPrefs:(BOOL)bannerTextColorFromMainAreaPrefs
{
	self = [super init];
	if (self) {
		_htmlColor = htmlColor;
		_colorSource = colorSource;
		_bannerTextColorFromMainAreaPrefs = bannerTextColorFromMainAreaPrefs;
	}
	return self;
}

/*TODO !!! use?
	not strictly necessary, but
	was supposed to make textstorage traversal faster, but made general output much slower... maybe come back to? reorder tests?
- (BOOL)isEqual:(id)other
{
	if (other == self) {
		return YES;
	}
	if (other == nil) {
		return NO;
	}
	if (! [other isKindOfClass:[XTOutputTextColorResult class]]) {
		return NO;
	}
	
	XTOutputTextColorResult *castOther = (XTOutputTextColorResult *)other;
	
	if (! [self.htmlColor isEqualTo:castOther.htmlColor]) {
		return NO;
	}
	
	if (self.colorSource != castOther.colorSource) {
		return NO;
	}
	
	return YES;
}

- (NSUInteger)hash
{
	NSUInteger res = [self.htmlColor hash];
	res += self.colorSource;
	return res;
}
*/

@end
