#include <adv.t>
#include <std.t>

startroom: room
  sdesc = "Living Room"
  ldesc = "You're in the living room.  A dark stairway leads down.  To the east is a bedroom. "
  down = 
  {
    say('You start down the stairs, which creak and moan and wobble
    uncertainly beneath you.  You stop for a moment to steady yourself,
    then continue down, when the entire stairway suddenly breaks away
    from the wall and crashes to the floor below.  You land in a heap of
    splintered wood.  After a few moments, everything settles, and you
    manage to get up and brush yourself off, apparently uninjured.\b');
    
    return(cellar);
  }
  east = bedroom
;

bedroom: room
  sdesc = "Bedroom"
  ldesc = "There is a bed here.  The exit is to the west. "
  west = startroom
;  
    
cellar : room
  sdesc = "Cellar"
  ldesc = "You're in the cellar.  A huge pile of broken pieces of wood
  that was once a stairway fills half the room. "
  up =
  {
    say('The stairway is in no condition to be climbed. ');
    return(nil);
  }
;

/*
snake : item
  location = cellar
  noun = 'snake' 'cobra'
  adjective = 'poisonous' 'venomous'
  sdesc = "poisonous snake"
  ldesc = "The venemous cobra flares his hood and bares his fangs."
  
  doTake(actor) = 
  {
    say ('As you attempt to take the snake, it sinks its fangs into your
    bare hands and injects you with a paralyzing venom.  In a matter of
    minutes, you are dead.');
    die();
  }
;
*/

gloves : clothingItem
  location = startroom
  noun = 'gloves'
  adjective = 'rubber'
  sdesc = "rubber gloves"
  ldesc = "Upon close examination, you see that the gloves are
  reinforced with some sort of metallic fiber."
;

snake : item
  location = cellar
  noun = 'snake' 'cobra'
  adjective = 'poisonous' 'venomous'
  sdesc = "poisonous snake"
  ldesc = "The venemous cobra flares his hood and bares his fangs."
  
  doTake(actor) = 
  {
    if (gloves.isworn)
    {
      say('As you pick up the snake, it tries to bite you, but the
      gloves protect your hands. ');
      pass doTake;
    }
    else
    {
      say ('As you attempt to take the snake, it sinks its fangs into your
      bare hands and injects you with a paralyzing venom.  In a matter of
      minutes, you are dead. ');
      die();
    }
  }
;

can : openable
  location = startroom
  noun = 'can'
  adjective = 'spinach'
  sdesc = "can of spinach"
  ldesc = 
  {
    say('This can of spinach has an easy-open top. ');
    pass ldesc;
  }
  isopen = nil
;

spinach : fooditem
  location = can
  noun = 'spinach'
  sdesc = "spinach"
  adesc = "some spinach"
  ldesc = "It looks quite tasty. "
  doEat(actor) = 
  {
    say ('You feel imbued with an incredible sense of strength. ');
    actor.strong = true;
    pass doEat;
  }
;

// This boulder can only be picked up if the player has eaten spinach

goldBoulder : item
  location = cellar
  noun = 'boulder'
  adjective = 'gold'
  sdesc = "gold boulder"
  ldesc = "This enormous boulder is made of pure gold.  If only you
  could take it, you'd be rich!"
  
  doTake(actor) = 
  {
    if (actor.strong)
    {
      say('You hoist the boulder as easily as a pebble. ');
      pass doTake;
    }
    else
    {
      say('You struggle to lift the boulder, but fail.  You are too
      weak.');
    }
  }
  
  doDrop(actor) = 
  {
    say ('The boulder crashes to the ground with a mighty thud. ');
    pass doDrop;
  }
;

bed : beditem
  location = bedroom
  noun = 'bed'
  sdesc = "bed"
  ldesc = "The bed looks so comfy, you'd really like to lie down and 
  take a nap. "
  
  doLieon(actor) = 
  {
    say ('You lie down on the bed, snuggle under the covers, and drift
    off to sleep...\b');
    incscore(10);
    actor.travelTo(dreamland);
  }
;

dreamland : room
  sdesc = "Dreamland"
  ldesc = 
  {
    say ('You are standing on a rocky crag, surrounded on all sides 
    by a great abyss. There is a throne here. ');
    if (bridge.location == dreamland)
    {
      say('A glowing bridge leads north into the distance. ');
    }
  }
  north =
  {
    if (bridge.location == dreamland)
    {
      say('You walk along the bridge for what seems like an
      eternity...\b');
      return(clouds);
    }
    else
    {
      say('You can\'t go that way. ');
      return(nil);
    }
  }
;

bridge : fixeditem
  noun = 'bridge'
  sdesc = "bridge"
  ldesc = "The bridge stretches into the distance as far as you can see.
  You don't know where it goes, but at least it's a way off this lonely crag. "
;

throne : chairitem
  location = dreamland
  noun = 'throne'
  sdesc = "throne"
  ldesc = "The throne is located at the highest point of the crag, facing north. "
  doSiton(actor) =
  {
    if (bridge.location == dreamland)
    {
      pass doSiton;
    }
    else
    {
      say ('As you sit in the throne, a magical, glowing bridge appears
      before you, spanning the great abyss. ');
      bridge.moveInto(dreamland);
      incscore(20);
      pass doSiton;
    }
  }
;

clouds : room
  sdesc = "Clouds"
  ldesc = "You're standing on fluffy clouds.  The bridge from where you
  came is to the south.  A set of pearly gates lie to the east.  
  A sign is posted on the gate. "
  south =
  {
    say ('You\'d rather not walk back across that long bridge again. ');
    return (nil);
  }
  east = 
  {
    if (Me.isCarrying(harp))
    {
      say('As you begin to walk toward the gate, you hear two 
      disembodied voices talking about you.
      \n\t"Do you think he looks like an angel?"
      \n\t"Well, he\'s got a harp, doesn\'t he?"\b ');

      return(heaven);
    }
    else
    {
      say('As you begin to walk toward the gate, you hear two 
      disembodied voices talking about you.
      \n\t"Do you think he looks like an angel?"
      \n\t"Nah, I don\'t think so.  We better stop him."
      \n\t A jolt of energy zaps your body and prevents you from passing
      through the gate.  Stunned, you walk backward a few steps. ');
      
      return(nil);
    }
  }
;

sign : readable, fixeditem
  location = clouds
  noun = 'sign'
  sdesc = "sign"
  ldesc = "The sign says, \"ANGELS ONLY.\" "
;

gates : decoration
  location = clouds
  noun = 'gates' 'gate'
  adjective = 'pearly'
  sdesc = "pearly gates"
  adesc = "a set of pearly gates"
  ldesc = "The pearly gates look exactly as you always imagined the
  entrance to heaven would look.  The gates are wide open, but there is
  a sign hanging from one of the gates. "
;
      
string : item
  noun = 'string'
  adjective = 'harp'
  sdesc = "harp string"
  ldesc = "The harp string is a long, thin metallic wire. "
  found = nil;
;

harp : item
  location = clouds
  noun = 'harp'
  sdesc = "harp"
  ldesc = "The harp is big and shiny. "
  doTake(actor) = 
  {
    if (string.found)
    {
      pass doTake;
    }
    else
    {
      say('As you pick up the harp, a string comes loose and falls to
      the ground. ');
      string.found = true;
      string.moveInto(actor.location);
      incscore(10);
      pass doTake;
    } 
  }
;

heaven : room
;
