#ifndef INVENT
#define INVENT
#pragma C-

inventVersion: versionTag
  id = "Invent: v 0.7 (beta) September 1999.\n"
  author = 'David Haire'
  func = 'extended inventory'
;

/*
 * Invent: implementation of extended inventory displays. Three types of
 *   inventory display are available: TALL, WIDE, and SHORT. (WIDE is the 
 *   default display.) TALL will display one item per line, with a container's 
 *   contents listed directly after the container and indented. SHORT will 
 *   display the inventory in paragraph format, with a container's contents 
 *   listed directly after the container. Both TALL and SHORT will list any 
 *   sense information(smells, sounds, etc.) directly after the object to 
 *   which they refer.
 */

/*
 * Compound words for extended inventory display.
 */
compoundWord 'i' 'wide' 'i_wide';
compoundWord 'invent' 'wide' 'i_wide';
compoundWord 'inventory' 'wide' 'i_wide';
compoundWord 'i' 'tall' 'i_tall';
compoundWord 'invent' 'tall' 'i_tall';
compoundWord 'inventory' 'tall' 'i_tall';
compoundWord 'i' 'short' 'i_short';
compoundWord 'invent' 'short' 'i_short';
compoundWord 'inventory' 'short' 'i_short';

iwideVerb: Systemverb, Soloverb
  sdesc = "set inventory wide"
  desc(obj) = {
    if (obj.isplural) self.sdesc;
    else "sets inventory wide";
  }
  verb = 'i_wide'
  soloaction(actor) = { 
    global.inventory := 'wide';
    "\b*** Inventory is now in WIDE format. ***\b";
    actor.inventory;
  }
;

itallVerb: Systemverb, Soloverb
  sdesc = "set inventory tall"
  desc(obj) = {
    if (obj.isplural) self.sdesc;
    else "sets inventory tall";
  }
  verb = 'i_tall'
  soloaction(actor) = { 
    global.inventory := 'tall';
    "\b*** Inventory is now in TALL format. ***\b";
    actor.inventory;
  }
;

ishortVerb: Systemverb,Soloverb
  sdesc = "set inventory short"
  desc(obj) = {
    if (obj.isplural) self.sdesc;
    else "sets inventory short";
  }
  verb = 'i_short'
  soloaction(actor) = { 
    global.inventory := 'short';
    "\b*** Inventory is now in SHORT format. ***\b";
    actor.inventory;
  }
;

/*
 * Display the player's inventory in TALL format.
 */
tallinvent: function(actor, cont, numindent)
{
  local d, i, j, k, o;
  local clen := length(cont.contents);
  local indistot := 0, indislist := [], indiscount := [], indislen := 0;
  local tot := 0, tlist := [], olist := [];
  local lcon := [], listed := nil;

  if (cont = actor)
    "<<actor.subjthedesc>> <<actor.has>>";
  for (i := 1; i <= clen; i++) {
    o := cont.contents[i];
    if (not o.isnoticeable(actor))
      continue;
    if (o.isequivalent) {
      indislist += o;
      indiscount += 1;
      indislen++;
    }
    else {
      tot++;
      tlist += o;
    }
  }
  for (j := 1; j <= indislen; j++) {
    if (indislist[j] = nil)
      continue;
    for (k := j + 1; k <= indislen; k++) {
      if (indislist[k] = nil)
        continue;
      if (indistinguishable(indislist[j],
         indislist[k])) {
        indiscount[j]++;
        indislist[k] := nil;
      }
    }
  }
  indistot := 0;
  olist := [];
  for (j := 1; j <= indislen; j++) {
    o := indislist[j];
    if (o = nil)
      continue;
    olist += o;
    indistot++;
    indiscount[indistot] := indiscount[j];
  }
  if (indistot > 0) {
    tlist := olist + tlist;
    tot += indistot;
  }
  for (i := 1; i <= tot; i++) {
    o := tlist[i];
    "\n";
    for (d := 1; d <= numindent; d++) "\t";
    if (i <= indistot and indiscount[i] > 1)
      "<<saynum(indiscount[i])>> \v<<o.listpluraldesc>>";
    else
      o.listdesc;
    listed := nil;  
    if (o.islistablesound(actor) and actor.canhear(o, nil, true)) {
      if (listed) " and ";
      else " (which ";
      "<<o.listlistendesc>>";
      listed := true;
    }
    if (o.islistablesmell(actor) and actor.cansmell(o, nil, true)) {
      if (listed) " and ";
      else " (which ";
      "<<o.listsmelldesc>>";
      listed := true;
    }
    if (o.islistabletouch(actor) and actor.cantouch(o, nil, true)) {
      if (listed) " and ";
      else " (which ";
      "<<o.listtouchdesc>>";
      listed := true;
    }
    if (listed) ")";
    if (o.contents <> []) {
      local seein;
      Outhide(true);
      seein := o.passcanseein(actor, nil, nil);
      Outhide(nil);
      if (seein) {
        ", which contains";
        caps();
        tallinvent(actor, o, numindent + 1);
      }
    }
  }

  return tot;
}

/*
 * Display the player's inventory in SHORT format.
 */
shortinvent: function(actor, cont)
{
  local i, j, k, o;
  local clen := length(cont.contents);
  local indistot := 0, indislist := [], indiscount := [], indislen := 0;
  local tot := 0, tlist := [], olist := [];
  local lcon := [], listed := nil;

  if (cont = actor)
    "<<actor.subjthedesc>> <<actor.has>>\ ";
  else
    "<<cont.subjthedesc>> contains\ ";
  for (i := 1; i <= clen; i++) {
    o := cont.contents[i];
    if (not o.isnoticeable(actor))
      continue;
    if (o.isequivalent) {
      indislist += o;
      indiscount += 1;
      indislen++;
    }
    else {
      tot++;
      tlist += o;
    }
  }
  for (j := 1; j <= indislen; j++) {
    if (indislist[j] = nil)
      continue;
    for (k := j + 1; k <= indislen; k++) {
      if (indislist[k] = nil)
        continue;
      if (indistinguishable(indislist[j],
         indislist[k])) {
        indiscount[j]++;
        indislist[k] := nil;
      }
    }
  }
  indistot := 0;
  olist := [];
  for (j := 1; j <= indislen; j++) {
    o := indislist[j];
    if (o = nil)
      continue;
    olist += o;
    indistot++;
    indiscount[indistot] := indiscount[j];
  }
  if (indistot > 0) {
    tlist := olist + tlist;
    tot += indistot;
  }
  for (i := 1; i <= tot; i++) {
    o := tlist[i];
    if (i = 1) "";
    else if (i = tot) {
      if (tot > 2) ",";
      " and ";
    }
    else
      ", ";
    if (i <= indistot and indiscount[i] > 1)
      "<<saynum(indiscount[i])>> \v<<o.listpluraldesc>>";
    else
      o.listdesc;
    listed := nil;  
    if (o.islistablesound(actor) and actor.canhear(o, nil, true)) {
      if (listed) " and ";
      else " (which ";
      "<<o.listlistendesc>>";
      listed := true;
    }
    if (o.islistablesmell(actor) and actor.cansmell(o, nil, true)) {
      if (listed) " and ";
      else " (which ";
      "<<o.listsmelldesc>>";
      listed := true;
    }
    if (o.islistabletouch(actor) and actor.cantouch(o, nil, true)) {
      if (listed) " and ";
      else " (which ";
      "<<o.listtouchdesc>>";
      listed := true;
    }
    if (listed) ")";
    if (o.contents <> [] and actor.canseecontents(o, true, nil)) {
      lcon += o;
    }
  }
  ". ";

  if (lcon <> []) {
    local i, o;
    local seein;
    for (i := 1; i <= length(lcon); i++) {
      o := lcon[i];
      Outhide(true);
      seein := o.passcanseein(actor, nil, nil);
      Outhide(nil);
      if (seein) {
        " ";
        caps();
        shortinvent(actor, o);
      }
    }
  }

  return tot;
}

modify Player
  /*
   * Inventory.
   */
  inventory = {
    local tot, locn;
    caps();
    if (not self.cansee(self, nil, nil))
      return;
    locn := [];

    switch (global.inventory) {
    case 'short':
      tot := shortinvent(self, self);
      break;
    case 'tall':
      tot := tallinvent(self, self, 1);
      break;
    default:
      tot := listcontents(self, self, nil, nil, nil, nil, true, true, nil, locn);
    }

    if (tot = 0)
      "You don't appear to be carrying anything.";
  }
;

modify global
  inventory = 'wide'                                        /* inventory type */
;

#endif
