#ifndef HEARTBEAT
#define HEARTBEAT
#pragma C-

/*
 * This module is intended to help cut down on the number of individual 
 *   daemons which are required in a TADS game. It tackles the problem of 
 *   the daemon which wants to be called once per turn, sometimes.
 *
 * Every object which has a method defined called "heartbeat" will be 
 *   collected into a list by preinit(). Then, once every turn, it will be 
 *   called if the method "wantheartbeat" returns true. i.e.
 *
 *  for all o in heartlist {  // for every entry in the list
 *    if (o.wantheartbeat)    // if it wants one
 *      o.heartbeat;          // send it
 *  }
 */

heartbeatVersion: versionTag, Initialization
  id = "Heartbeat: v 1.3 May 1994.\n"
  author = 'Jeff Laing'
  func = 'heartbeat monitoring'

  /*
   * Inspect every object looking for a heartbeat method. When we find 
   *   one, add it to our list.
   */
  preinit_phase = {
    local o;
    self.heartlist := [];
    for (o := firstobj(); o <> nil; o := nextobj(o)) {
      if (defined(o,&heartbeat))
        self.heartlist += o;
    }
  }

  /*
   * Start the heartbeat daemon. Send the first one for free, the rest 
   *   come from self.
   */
  init_phase = {
    self.sendheartbeat;
    notify(self, &sendheartbeat, 0);
  }
  
  /*
   * Send a heartbeat to every object in the game that wants one.
   */
  sendheartbeat = {
    local i, o;
    for (i := 1; i <= length(self.heartlist); i++) {
      o := self.heartlist[i];
      if (o.wantheartbeat) o.heartbeat;
    }
  }
;

#endif
