/*
 * World2.t
 * Copyright (c) 1999 The Children of Dana
 * Written by David Haire
 *
 * This file contains the main functionality for WorldClass.
 *
 */

/*
 * NOTE: DON'T REPLACE OR CHANGE PREINIT!
 * Put game-specific preinit stuff in userpreinit.
 */
preinit: function
{
  local o, i;

  /* Clear initialization object list */
  global.init_list := [];

  /* Clear contents lists. */
  for (o := firstobj(); o <> nil; o := nextobj(o))
    o.contents := [];

  /* Init global and per-object lists. */
  for (o := firstobj(); o <> nil; o := nextobj(o)) {

    /* Rooms with no location go in TOP */
    if (isclass(o, Room))
      if (not isclass(o, Nestedroom) and o.location = nil)
        o.location := TOP;

    /* If not Floating, put in location's contents list */
    if (not isclass(o, Floating))
      if (o.location <> nil)
        o.location.contents += o;

    /* Actors */
    if (isclass(o, Actor)) {
      global.actorlist += o;
      if (defined(o, &moveDaemon))
        global.moverlist += o;
    }

    /* Move Parts into the contents list of their partof's location */
    if (isclass(o, Part)) {
      if (o.partof <> nil) {
        if (o.partof.location <> nil)
          o.partof.location.contents += o;
        o.partof.parts += o;
      }
    }

    /* Listable smells */
    if (isclass(o, Listablesmell))
      global.listablesmelllist += o;

    /* Listable sounds */
    if (isclass(o, Listablesound))
      global.listablesoundlist += o;

    /* Listable touches */
    if (isclass(o, Listabletouch))
      global.listabletouchlist += o;

    /* Footnotes */
    if (defined(o, &footnote)) {
      global.footnotelist += o;
      if (defined(o, &footnum))
        if (o.footnum <> nil)
          global.footavoid += o.footnum;
    }

    /* Light sources */
    if (isclass(o, Lightsource)) {
      o.properties += &litprop;
      if (o.islit) global.lightsources += o;
    }

    /* Clothing that is worn must be 'in' its location */
    if (o.isclothing and o.isworn) {
      o.setlocationtype('in');
      o.properties += &wornprop;
    }

    /* Attachables need to be in the Attachpoint's attached list */
    if (isclass(o, Attachable) or isclass(o, Attachpoint)) {
      if (o.attachedto <> []) {
        local a;
        if (isclass(o, Attachable))
          o.properties += &attachedprop;
        for (i := length(o.attachedto); i > 0; i--) {
          a := o.attachedto[i];
          if (find(a.attachedto, o) = nil)
            a.attachedto += o;
        }
      }
    }

    /* Location types */
    if (defined(o, &locationtype))
      o.setlocationtype(o.locationtype);
    else if (defined(o, &location))
      o.setlocationtype('in');

    /* Initialization objects */
    if (isclass(o, Initialization)) {
      if (proptype(o, &init_phase) = 6)
        global.init_list += o;
      o.preinit_phase;
    }

  }

  userpreinit();
}

/*
 * Override this function with the replace command to add your own special
 *   stuff.
 */
userpreinit: function
{
}

/*
 * NOTE: DON'T REPLACE OR CHANGE INIT!
 * Put game-specific init stuff in userinit or initCommon.
 */
init: function
{
  local i, o;

  /* Enable HTML mode */
  if (systemInfo(__SYSINFO_SYSINFO) = true) "\H+";

  /* Initialise actors */
  for (i := 1; i <= length(global.actorlist); i++) {
    local o := global.actorlist[i];

    /* Actor death checks */
    if (defined(o, &starvationcheck))
      if (proptype(o, &starvationcheck) = 6) {
        notify(o, &starvationcheck, 0);
        o.turnsuntilstarvation := o.mealtime;
      }
    if (defined(o, &dehydrationcheck))
      if (proptype(o, &dehydrationcheck) = 6) {
        notify(o, &dehydrationcheck, 0);
        o.turnsuntildehydration := o.drinktime;
      }
    if (defined(o, &sleepcheck))
      if (proptype(o, &sleepcheck) = 6) {
        notify(o, &sleepcheck, 0);
        o.turnsuntilsleep := o.sleeptime;
      }
  }

  /* call all the modules with init_phase methods */
  for (i := 1; i <= length(global.init_list); i++) {
    global.init_list[i].init_phase;
  }

  /* start the turn counter daemon */
  setdaemon(turncount, nil);
  
  /* set all Mover actors in motion */
  for (i := 1; i <= length(global.moverlist); i++) {
    local o := global.moverlist[i];
    notify(o, &moveDaemon, 0);
  }

  /* randomise in 2 turns */
  notify(global, &randomise, 2);

  /* Show the initial status line */
  init_statusline();

  /* Call the common initialisation routine */
  initCommon();

  /* Call the user-specified initialisation routine */
  userinit();
}

/*
 * NOTE: DON'T REPLACE OR CHANGE INITRESTORE!
 * Put game-specific init stuff in userinit or initCommon.
 */
initRestore: function(fname)
{
  /* Inform the user we are restoring the game */
  "\b\([Restoring saved game]\)\b";

  /* Enable HTML mode */
  if (systemInfo(__SYSINFO_SYSINFO) = true) "\H+";

  /* Display the runtime version information */
  versioninfo(); "\b";

  /* Show the initial status line */
  init_statusline();

  /* Call the common initialisation routine */
  initCommon();

  /* Restore the game */
  mainRestore(fname);
}

/*
 * Override this function with the replace command to add your own special
 *   stuff.
 */
userinit: function
{
  /* Print the intro unless we're restarting */
  if (global.restarting = nil) {
    versioninfo(); "\n<hr>\n";
    intro();
  }

  /* Set global.lastactor */
  global.lastactor := parserGetMe();

  /* Move player to starting location */
  parserGetMe().location.enter(parserGetMe());
}

/*
 * Override this function with the replace command to add your own special
 *   stuff.
 */
initCommon: function
{
}

/*
 * Preparse. TADS calls before it looks at the input. We simply dispatch it
 *   to our standard preparse routine; this makes for users to replace this
 *   function with their own custom stuff and still retain the standard
 *   WorldClass behavior.
 */
preparse: function(s)
{
  return WorldClassPreparse(s);
}

/*
 * Preparse routine to extend parser to handle parenthesized lists of
 *   numbers. This code replaces a list of numbers enclosed in parentheses
 *   with the string "intlist", which matches the listObj object defined
 *   below. E.g.,
 *
 *   set widget to (i1, i2, ... , in) ->
 *
 *     "set widget to intlist"
 *     listObj.value := [i1 i2 ... in]
 *
 * See setVerb for an example of how to update a verb to accept lists like
 *   this.
 */
WorldClassPreparse: function(s)
{
  local orig, i, snew, inlist := nil, gotlist := nil, numstr := '';
  listObj.value := [];
  orig := s;
  snew := '';
  for (i := 1; i <= length(s); i++) {
    local c := substr(s, i, 1);
    if (inlist) {
      if (c = ')' or c = ']') {
        inlist := nil;
        gotlist := true;
      }
      else if (c = ',' or c = ' ') {
        if (numstr <> '') {
          listObj.value += cvtnum(numstr);
          numstr := '';
        }
      }
      else {
        numstr += c;
      }
    }
    else {
      if (c = '(' or c = '[') {
        if (not gotlist) {
          inlist := true;
          snew += ' intlist ';
          continue;
        }
      }
      else if (c = ')' or c = ']') {
        return orig;
      }

      snew += c;
    }
  }
  if (numstr <> '')
    listObj.value += cvtnum(numstr);
  return snew;
}

/*
 * preparseCmd function is called for each command, after the command has
 *   been 'tokenised'. We simply dispatch it to our standard preparse
 *   routine; this allows authors to replace this function with their own
 *   custom stuff and still retain the standard WorldClass behavior.
 */
preparseCmd: function(cmd)
{
  return WorldClassPreparseCmd(cmd);
}

/*
 * Preparse routine to take sentences of the form "tell <actor> to
 *   <command>" and "ask <actor> to <command>, and convert them to the
 *   normal TADS syntax "<actor>, <command>".
 *
 * Note: This could probably be done more concisely using reSearch, but I 
 *   couldn't get that to work.
 */
WorldClassPreparseCmd: function(cmd)
{
  local i, tot, toloc, actor, therest;

  /* Display command tokens if global.debugparser is set */
  if (global.debugparser) {
    for (i := 1, tot := length(cmd); i <= tot; ++i)
      "<<cmd[i]>> ";
    "\n";
  }

  /* Convert "tell to" and "ask to" commands to normal syntax */
  tot := length(cmd);
  if (tot > 3 and (cmd[1] = 'tell' or cmd[1] = 'ask')) {
    for (i := 1, tot := length(cmd); i <= tot; ++i){
      if (cmd[i] = 'to') toloc := i;
    }
    if (toloc <> nil and toloc > 2){
      for (i := 2, actor := []; i < toloc; ++i)
        actor += cmd[i];
      for (i := toloc + 1, therest := []; i <= tot; ++i)
        therest += cmd[i];
      return actor + ',' + therest;
    }
  }
  return true;
}

/*
 * commandPrompt function called prior to reading a command. Replace it to 
 *   include your own code here.
 */
commandPrompt: function(code)
{
  "\b\(&gt ";

  /* switch the font to TADS-Input in HTML environments */
  "<font face='TADS-Input'>";
}

/*
 * commandAfterRead function called immediately after reading a command.
 *   Replace it to include your own code here.
 */
commandAfterRead: function(code)
{
  /* switch back to the original font */
  "</font>";

  "\)";
}

/*
 * The top of the topology.
 *
 * Every thing has a parent, stored in the location property of the thing.
 *   Things that are nowhere (location = nil) implicitly have TOP as their
 *   parent.
 *
 * Rooms generally have top as their location. This means that TOP is the
 *   place to put code for inter-room sense passing. E.g. TOP might find
 *   the shortest path between two rooms and pass hearing if the two rooms
 *   are within a certain distance from each other.
 *
 * Right now TOP just refuses to send senses between rooms.
 *
 * Note that to effect inter-room sense passing you need only modify the
 *   passcanXacross methods.
 */
TOP: Thing
  sdesc = "TOP"
  thedesc = "TOP"
  location = nil
  roomAction(a, v, d, p, i) = {}

  /*
   * These shouldn't get called.
   */
  passcansee(actor, obj, loctype) = { return nil; }
  passcantouch(actor, obj, loctype) = { return nil; }
  passcantake(actor, obj, loctype) = { return nil; }
  passcansmell(actor, obj, loctype) = { return nil; }
  passcanhear(actor, obj, loctype) = { return nil; }
  passcanspeakto(actor, obj, loctype) = { return nil; }

  /*
   * Don't pass sense by default.
   */
  passcanseeacross(actor, obj, selfloctype, objloctype) = {
    "\^<<actor.subjprodesc>> can't see anything
     matching that vocabulary here.";
    return nil;
  }
  passcantouchacross(actor, obj, selfloctype, objloctype) = {
    "\^<<actor.subjprodesc>> can't touch anything
     matching that vocabulary here.";
    return nil;
  }
  passcantakeacross(actor, obj, selfloctype, objloctype) = {
    "\^<<actor.subjprodesc>> can't take anything
     matching that vocabulary here.";
    return nil;
  }
  passcansmellacross(actor, obj, selfloctype, objloctype) = {
    "\^<<actor.subjprodesc>> can't smell anything
     matching that vocabulary here.";
    return nil;
  }
  passcanhearacross(actor, obj, selfloctype, objloctype) = {
    "\^<<actor.subjprodesc>> can't hear anything
     matching that vocabulary here.";
    return nil;
  }
  passcanspeaktoacross(actor, obj, selfloctype, objloctype) = {
    "Nothing matching that vocabulary can hear
     <<actor.objprodesc(nil)>>.";
    return nil;
  }
;

/*
 * NIL is similar to TOP. Everything that is nowhere is taken to be in NIL,
 *   which is likewise taken to be in TOP. This is really only here to make
 *   Thing.blocksreach simpler - you should never really set anything's
 *   location to NIL. (Blocksreach wants every pair of objects to have some
 *   common ancestor - we ensure this by putting everything under TOP.
 *   Things that are also in nil, are under NIL.)
 *
 * In theory, you could make things in NIL reachable in some circumstances,
 *   but it's hard to imagine why this would be useful.
 */
NIL: Thing
  sdesc = "NIL"
  thedesc = "NIL"
  location = TOP
  roomAction(a, v, d, p, i) = {}

  /*
   * These shouldn't get called.
   */
  passcansee(actor, obj, loctype) = { return nil; }
  passcantouch(actor, obj, loctype) = { return nil; }
  passcantake(actor, obj, loctype) = { return nil; }
  passcansmell(actor, obj, loctype) = { return nil; }
  passcanhear(actor, obj, loctype) = { return nil; }
  passcanspeakto(actor, obj, loctype) = { return nil; }

  /*
   * Don't pass sense by default.
   */
  passcanseeacross(actor, obj, selfloctype, objloctype) = {
    "\^<<actor.subjprodesc>> can't see anything 
     matching that vocabulary here.";
    return nil;
  }
  passcantouchacross(actor, obj, selfloctype, objloctype) = {
    "\^<<actor.subjprodesc>> can't touch anything
     matching that vocabulary here.";
    return nil;
  }
  passcantakeacross(actor, obj, selfloctype, objloctype) = {
    "\^<<actor.subjprodesc>> can't take anything
     matching that vocabulary here.";
    return nil;
  }
  passcansmellacross(actor, obj, selfloctype, objloctype) = {
    "\^<<actor.subjprodesc>> can't smell anything
     matching that vocabulary here.";
    return nil;
  }
  passcanhearacross(actor, obj, selfloctype, objloctype) = {
    "\^<<actor.subjprodesc>> can't hear anything
     matching that vocabulary here.";
    return nil;
  }
  passcanspeaktoacross(actor, obj, selfloctype, objloctype) = {
    "Nothing matching that vocabulary can hear
     <<actor.objprodesc(nil)>>.";
    return nil;
  }
;
