/* Copyright (c) 1999, 2000 by Kevin Forchione.  All Rights Reserved. */
/*
 *  TADS ADV.T/STD.T LIBRARY EXTENSION
 *  WYSIWYG.T				
 *  version 2.1
 *
 *	This module implements the WYSIWYG class, which is a readable 
 *	specially designed to facilitate maps and signs in both TADS 
 *	and HTML TADS.
 *
 *----------------------------------------------------------------------
 *  REQUIREMENTS
 *
 *      + HTML TADS 2.2.6 or later
 *      + Should be #included after ADV.T and STD.T 
 *
 *----------------------------------------------------------------------
 *  IMPORTANT LIBRARY INTERFACE AND MODIFICATION
 *
 *      None.
 *
 *----------------------------------------------------------------------
 *  COPYRIGHT NOTICE
 *
 *  	You may modify and use this file in any way you want, provided that
 *		if you redistribute modified copies of this file in source form, the
 *   	copies must include the original copyright notice (including this
 *   	paragraph), and must be clearly marked as modified from the original
 *   	version.
 *
 *------------------------------------------------------------------------------
 *  REVISION HISTORY
 *
 *		17-Jun-99:	Creation.
 *		18-Jun-99:	Modified HTML TAGS for wysiwyg object. Added ifdef 
 *					check for USE_HTML_STATUS to object.
 *		20-Jun-99:	Added wysitable class
 *					Changed the structure of the display methods and 
 *					re-organized the HTML TAGS. Broke out the background
 *					color and font for easier modification.
 */
 
#define __WYSIWYG_MODULE_

/*
 *	wysiwyg: readable
 *
 *	The wysiwyg is meant to facilitate the creation of maps and other
 *	signs that the player encounters within a game. The layout of the map
 *	can be entered in the headerText, bodyText, and footerText lists as
 *	(single-quote) string elements, each string being a separate line of 
 *	text in the map. 
 *
 *	Formatting for HTML can be modified through the various Fmt methods.
 *	The size and colour of the box will need to be adjusted to the size 
 *	of your map. For best results Courier New should be used, as it 
 *	provides relatively little distortion.
 */
class wysiwyg: readable

#ifdef USE_HTML_STATUS

    ldesc =
    {
        if (systemInfo(__SYSINFO_SYSINFO) = true
        and systemInfo(__SYSINFO_HTML) = 1)
        {
        	self.tableFmtBegin;
        	self.tableBGCOLOR;
        	if (length(self.headerText) > 0)
        		self.displayHeader;
        	if (length(self.bodyText) > 0)
        		self.displayBody;
        	if (length(self.footerText) > 0)
        		self.displayFooter;
        	self.tableFmtEnd;
        }
		else
		{
        	if (length(self.headerText) > 0)
        		printWysiwyg(self.headerText);
        	if (length(self.bodyText) > 0)
        		printWysiwyg(self.bodyText);
        	if (length(self.footerText) > 0)
        		printWysiwyg(self.footerText);
		}
    }
    
#else 	/* USE_HTML_STATUS */
    
    ldesc =
    {
    	if (length(self.headerText) > 0)
      		printWysiwig(self.headerText);
   		if (length(self.bodyText) > 0)
       		printWysiwig(self.bodyText);
     	if (length(self.footerText) > 0)
     		printWysiwig(self.footerText);
    }
    
#endif	/* USE_HTML_STATUS */
    
    displayHeader =
    {
        self.headerFont;
        self.headerFmtBegin;
        printWysiwyg(self.headerText);
        self.headerFmtEnd;
    }
    displayBody =
    {
        self.bodyFont;
        self.bodyFmtBegin;
        printWysiwyg(self.bodyText);
        self.bodyFmtEnd;        
    }
    displayFooter =
    {
        self.footerFont;
        self.footerFmtBegin;
        printWysiwyg(self.footerText);
        self.footerFmtEnd;        
    }
    tableFmtBegin =
    {
        "<BR>
        <P>
        <CENTER>
        <TABLE BORDER=1 CELLPADDING=15>";
    }
    tableBGCOLOR =
    {
        "<TR BGCOLOR=\"#AAAAAA\">
        <TD BGCOLOR=\"#AAAAAA\">";       
    }
    tableFmtEnd = 
    {
       	"</TD>
        </TR>
        </TABLE>
        </CENTER>
        </P>";       
    }
    headerFont =
    {
        "<FONT COLOR=YELLOW SIZE=\"+1\" FACE=\"Courier New,Courier New\">";
    }
    headerFmtBegin =
    {
        "<P>
        <B>
        <CENTER>";
    }
    headerFmtEnd=
    {
        "</CENTER>
        </B>		
        </P>
        </FONT>";
    }
    bodyFont =
    {
        "<FONT COLOR=WHITE FACE=\"Courier New,Courier New\">";  
    }
    bodyFmtBegin =
    {
        "<P>";
    }
    bodyFmtEnd =
    {
        "</P>
        </FONT>";
    }
    footerFont =
    {
        "<FONT COLOR=YELLOW SIZE=\"-2\" FACE=\"Courier New,Courier New\">";
    }
    footerFmtBegin =
    {   
        "<P>
        <B>
        <CENTER>";
    }
    footerFmtEnd =
    {
        "</CENTER>
        </B>		
        </P>
        </FONT>";
    }
    headerText = []
    bodyText = []
    footerText = []
;

/*
 *	wysiwygTable: wysiwyg
 *
 *	The wysiwygTable is a wysiwyg which formats the heading, body, and footer
 *	areas into table rows (three in total) which gives each section a separate 
 *	border.
 *
 *	Additionally, each section of the table can then have its own background
 *	color as well as font style.
 */
class wysiwygTable: wysiwyg
#ifdef USE_HTML_STATUS

    ldesc =
    {
        if (systemInfo(__SYSINFO_SYSINFO) = true
        and systemInfo(__SYSINFO_HTML) = 1)
        {
        	self.tableFmtBegin;
        	if (length(self.headerText) > 0)
        		self.displayHeader;
        	if (length(self.bodyText) > 0)
        		self.displayBody;
        	if (length(self.footerText) > 0)
        		self.displayFooter;
        	self.tableFmtEnd;
        }
		else
		{
        	if (length(self.headerText) > 0)
        		printWysiwyg(self.headerText);
        	if (length(self.bodyText) > 0)
        		printWysiwyg(self.bodyText);
        	if (length(self.footerText) > 0)
        		printWysiwyg(self.footerText);
		}
    }
    
#else 	/* USE_HTML_STATUS */
    
    ldesc =
    {
    	if (length(self.headerText) > 0)
      		printWysiwig(self.headerText);
   		if (length(self.bodyText) > 0)
       		printWysiwig(self.bodyText);
     	if (length(self.footerText) > 0)
     		printWysiwig(self.footerText);
    }
    
#endif	/* USE_HTML_STATUS */
    displayHeader =
    {
        self.headerBGCOLOR;
        self.headerFont;
        self.headerFmtBegin;
        printWysiwyg(self.headerText);
        self.headerFmtEnd;
    }
    displayBody =
    {
        self.bodyFmtBegin;
        self.bodyBGCOLOR;
        self.bodyFont;
        printWysiwyg(self.bodyText);
        self.bodyFmtEnd;        
    }
    displayFooter =
    {
        self.footerBGCOLOR;
        self.footerFont;
        self.footerFmtBegin;
        printWysiwyg(self.footerText);
        self.footerFmtEnd;        
    }
    tableFmtBegin =
    {
        "<BR>
        <P>
        <CENTER>
        <TABLE BORDER=1 CELLPADDING=15>";
    }
    tableFmtEnd = 
    {
        "</TABLE>
        </CENTER>
        </P>";        
    }
    headerBGCOLOR = 
    {
        "<TR BGCOLOR=\"#AAAAAA\">
        <TD BGCOLOR=\"#AAAAAA\">";        
    }
    headerFont =
    {
        "<FONT COLOR=YELLOW SIZE=\"+1\" FACE=\"Courier New,Courier New\">";
    }
    headerFmtBegin =
    {
        "<P>
        <B>
        <CENTER>";
    }
    headerFmtEnd=
    {
        "</CENTER>
        </B>
        </P>
        </FONT>
        </TD>
        </TR>";
    }
    bodyBGCOLOR = { self.headerBGCOLOR; }
    bodyFont = 
    {
        "<FONT COLOR=WHITE FACE=\"Courier New,Courier New\">";  
    }
    bodyFmtBegin =
    {
        "<P>";
    }
    bodyFmtEnd =
    {
        "</P>
        </FONT>
        </TD>
        </TR>";
    }
    footerBGCOLOR = { self.headerBGCOLOR; }
    footerFont =
    {
        "<FONT COLOR=YELLOW SIZE=\"-2\" FACE=\"Courier New,Courier New\">";
    }
    footerFmtBegin =
    {   
        "<P>
        <B>
        <CENTER>";
    }
    footerFmtEnd =
    {
        "</CENTER>
        </B>		
        </P>
        </FONT>
        </TD>
        </TR>";
    }
;

/*
 *  printWysiwyg: function(list)
 *
 *  This function prints a list of strings, preventing the spacing
 *  compression normal with TADS. This allows for the production of
 *	accurate maps and signs.
 */
printWysiwyg: function(list)
{
    local i;
    for (i := 1; i <= length(list); ++i)
    {
#ifdef USE_HTML_STATUS
        if (systemInfo(__SYSINFO_SYSINFO) = true
        and systemInfo(__SYSINFO_HTML) = 1)
            "<BR>"; 
        else
#endif /* USE_HTML_STATUS */
            "\n";
             
        say(nocompress(list[i]));
    }  
}

/*
 *	nocompress: function( str )
 *
 *	A function for eliminating the compression of spaces, especially useful for
 *	printing room maps. It takes a (single-quote) string as its parameter and 
 *	returns a string which has the spaces treated to eliminate TADS natural 
 *	compression.
 */
nocompress: function( str )
{
	local i, char, newstr := '';
	for (i := 1; i <= length(str); ++i)
	{
		char := substr(str,i,1);
		if (char = ' ')
		{
#ifdef USE_HTML_STATUS
            if (systemInfo(__SYSINFO_SYSINFO) = true
            and systemInfo(__SYSINFO_HTML) = 1)
                newstr += '&nbsp';
            else
#endif /* USE_HTML_STATUS */
			    newstr += '\ ';		// equivalent to '&nbsp'
		}
		else
			newstr += char;
	}
	return newstr;
}
