/*
 * 	sample.t				version 1.0
 *	by Kevin Forchione		( Lysseus@msn.com )
 *	Copyright (c) 1999. 	All Rights Reserved.
 *
 *	DEMONSTRATION FOR MULTIFORM.T
 *	
 *  This file requires HTML TADS 2.2.6 or later.
 *
 *  You may modify and use this file in any way you want, provided that
 *	if you redistribute modified copies of this file in source form, the
 *  copies must include the original copyright notice (including this
 *  paragraph), and must be clearly marked as modified from the original
 *  version.
 *
 *------------------------------------------------------------------------------
 *		Revision History
 *------------------------------------------------------------------------------
 *		21-Jun-99:	Creation.
 */

#define USE_HTML_STATUS
#include <adv.t>
#include <std.t>
#include <multiform.t>
#include <wysiwyg.t>

startroom: room
    sdesc = "Kitchen"
    ldesc = "Just another boring room? But what's this? A MULTIFORM, which is
    	both a CONTAINER and SUPPORTER is here. Try PUTTING things IN the box
    	(after you've opened it of course!) and PUTTING things ON the box. Be
    	sure to LOOK and EXAMINE the effects. Have a spot of lunch while you're
    	here!\b"
;

box: multiform, qcontainer, surface
    location = startroom
    sdesc = "bread box"
    noun = 'box'
    adjective = 'bread'
;

bread: fooditem
	location = box
	sdesc = "bread"
	adesc = "some bread"
	noun = 'bread'
;

apple: fooditem
    location = box
    sdesc = "apple"
    adesc = "an apple"
    noun = 'apple'
    isOnSurface = true
;

pear: fooditem
	location = box
	sdesc = "pear"
	noun = 'pear'
	isOnSurface = true
;

desk: multiform, keyedLockable, surface
	location = startroom
	sdesc = "desk"
	noun = 'desk'
	mykey = key
	isopen = nil
;

bottle: multiform,transparentItem,openable,surface
    location = desk
    sdesc = "glass bottle"
    noun = 'bottle'
    adjective = 'glass'
    isopen = nil
    isOnSurface = true
    ioPutOn(actor,dobj) =
    {
    	if (dobj <> label)
			"There's no good surface on <<self.thedesc>>. ";
		else
			pass ioPutOn;
    }
;

key: keyItem
	location = desk
	sdesc = "key"
	noun = 'key'
;

label: wysiwyg
	location = desk
	sdesc = "label"
	noun = 'label'
	headerText =
	[
		'INTRODUCING'
		'MULTIFORM CLASS'
		'OBJECTS'
	]
;

replace commonInit: function
{
    "\H+";
}
;
