/* ex:set ts=4 sw=4:
 *
 * timers.t:	control over timers, fuses, etc
 *
 * This module provides a manager for controlling fuses, timers, notify
 * daemons, etc within TADS.  These save you from the run-time errors that
 * can occur if you "unnotify" without having "notify"ed previously and so
 * on.  They also give you a central bottleneck for placing debugging
 * messages.
 *
 * TADS 2.something or other removed the run-time errors thus making this
 * thing largely redundant.  However, since it also provides the debug
 * bottlenecks, I think its worth keeping.
 *
 * This module is Copyright (c) 1993 Jeff Laing.  Permission to use any or all
 * of this code in other TADS games is granted provided credit is given in
 * your "CREDITS" command for this code and that you leave this copyright
 * message in the source whenever distributed.  Please make all changes in
 * a backward compatible manner (where possible) and make them available
 * for free (like I did ;-)
 */
timersVersion : versionTag
	id="$Id: timers.t_v 1.3 1994/05/05 06:38:15 jeffl Exp jeffl $\n"
	author='Jeff Laing'
	func='timer management'
;

/*
 * we have one object which keep track of all notify(), setfuse() and 
 * setdaemon() calls
 */
timer_info: object
	debug=nil				// set to true to enable timer tracing
	notify_list = []
	fuse_list = []
	daemon_list = []
;

/*
 * look for a pair of entities in a list.  If they are found, return the
 * index position.  If not, return zero.
 */
find_pair:		function( list, aaa, bbb )
{
	local	i, len;

	len := length( list );
	for (i:=1; i<=len; i+=2) {
		if (datatype(list[i])<>datatype(aaa))		// short-circuit compare
			continue;

		if (list[i]<>aaa) continue;
		if (list[i+1]<>bbb) continue;

		return(i);
	}
	return(0);
}

/*
 * safe_notify( obj, &prop, turns, msg )
 */
NOTIFY:			function( obj, prop, turns, msg )
{
	local f;

	if (timer_info.debug) "\(NOTIFY(<<obj.sdesc>>,<<turns>>,<<msg>>)\)\n";

	// look for a hole in the list
	f := find_pair( timer_info.notify_list, nil, nil );
	if (f=0) {
		timer_info.notify_list		+= [ obj, prop ];
	} else {
		timer_info.notify_list[f] 	:= obj;
		timer_info.notify_list[f+1]	:= prop;
	}

	// now do the actual notify
	notify(obj,prop,turns);
}

/*
 * safe_unnotify( obj, prop, msg )
 */
UNNOTIFY:		function( obj, prop, msg )
{
	if (timer_info.debug) "\(UNNOTIFY(<<obj.sdesc>>,<<msg>>)\)\n";

	if (FORGET_NOTIFY( obj, prop, msg )) {
		unnotify(obj,prop);
	} else {
		"\(unexpected UNNOTIFY(<<msg>>)\)";
	}
}

/*
 * safe_forget_notify( obj, prop )
 */
FORGET_NOTIFY:	function( obj, prop, msg )
{
	local f;

	if (timer_info.debug) "\(FORGET_NOTIFY(<<obj.sdesc>>,<<msg>>)\)\n";

	// if we find this entry, we nil it and pass back true.  otherwise, 
	// its an errant call which we just ignore
	f := find_pair( timer_info.notify_list, obj, prop );
	if (f>0) {
		timer_info.notify_list[f] 	:= nil;
		timer_info.notify_list[f+1]	:= nil;
		return(true);
	}
	return(nil);
}

SETFUSE:		function(func, time, val, msg )
{
	local f;
	if (timer_info.debug) "\(SETFUSE(<<time>>,<<val>>,<<msg>>)\)\n";
	setfuse(func,time,val);
	return;

	/**** A LOT OF THIS CODE LOOKS LIKE BUGS - COS IT IS.  TADS DOESNT
	 **** HANDLE FUNCTION POINTERS IN LISTS PROPERLY
	 ****/
"BUG:IN SET FUSE\b";

	// debugObject.msg('setfuse('+msg+')');

	// look for a hole in the list
	f := find_pair( timer_info.fuse_list, nil, nil );

"BUG:RETURNED FROM FIND_PAIR\b";

	if (f=0) {
"BUG:ADD TO END OF FUSE LIST\b";
"BUG:WAS <<length(timer_info.fuse_list)>>\b";
		timer_info.fuse_list := timer_info.fuse_list + [ 0,0 ];
		f := length(timer_info.fuse_list)-1;
	}
"BUG:NOW IS <<length(timer_info.fuse_list)>>\b";
	timer_info.fuse_list[f] 	:= func;
"BUG:NOW IS <<length(timer_info.fuse_list)>>\b";
	timer_info.fuse_list[f+1]	:= val;
"BUG:NOW IS <<length(timer_info.fuse_list)>>\b";

"BUG:STARTING TO SET FUSE\b";
	// now do it
	setfuse(func,time,val);
"BUG:SET FUSE\b";
}

REMFUSE:		function(func, val, msg)
{
	if (timer_info.debug) "\(REMFUSE(<<val>>,<<msg>>)\)\n";
	FORGET_FUSE(func,val,msg);
	remfuse(func,val);
}

/*
 * safe_forget_notify( obj, prop )
 */
FORGET_FUSE:	function( func, val, msg )
{
	local f;
	if (timer_info.debug) "\(FORGETFUSE(<<val>>,<<msg>>)\)\n";
	return;

	// just fill the hole with zeros, we will reuse it
"BUG:CALLING FIND_PAIR\b";
	f := find_pair( timer_info.fuse_list, func, val );
"BUG:RETURNED FROM FIND_PAIR\b";
	timer_info.fuse_list[f] 	:= nil;
	timer_info.fuse_list[f+1]	:= nil;
}

SETDAEMON:		function(func, val, msg)
{
	if (timer_info.debug) "\(SETDAEMON(<<msg>>)\)\n";
	setdaemon(func,val);
}

REMDAEMON:		function(func, val, msg)
{
	if (timer_info.debug) "\(REMDAEMON(<<msg>>)\)\n";
	remdaemon(func,val);
}
