VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmImprimir 
   BorderStyle     =   3  'Fixed Dialog
   Caption         =   "Imprimir"
   ClientHeight    =   4380
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   8190
   Icon            =   "Imprimir.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4380
   ScaleWidth      =   8190
   ShowInTaskbar   =   0   'False
   StartUpPosition =   1  'CenterOwner
   Begin VB.CommandButton cmdCancelar 
      Cancel          =   -1  'True
      Caption         =   "&Cancelar"
      Height          =   375
      Left            =   7080
      TabIndex        =   13
      Top             =   3960
      Width           =   1095
   End
   Begin VB.CommandButton cmdImprimir 
      Caption         =   "&Imprimir"
      Default         =   -1  'True
      Height          =   375
      Left            =   5880
      TabIndex        =   12
      Top             =   3960
      Width           =   1095
   End
   Begin VB.Frame Frame4 
      Height          =   3615
      Left            =   6120
      TabIndex        =   9
      Top             =   240
      Width           =   2055
      Begin VB.CheckBox chkMod 
         Caption         =   "&Mdulos"
         Enabled         =   0   'False
         Height          =   255
         Left            =   720
         TabIndex        =   10
         Top             =   360
         Width           =   1215
      End
      Begin MSComctlLib.ListView lstMod 
         Height          =   2775
         Left            =   120
         TabIndex        =   11
         Top             =   720
         Width           =   1815
         _ExtentX        =   3201
         _ExtentY        =   4895
         View            =   3
         LabelEdit       =   1
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         Checkboxes      =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         NumItems        =   1
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "Mdulos"
            Object.Width           =   3528
         EndProperty
      End
      Begin VB.Image Image4 
         Height          =   480
         Left            =   120
         Picture         =   "Imprimir.frx":058A
         Top             =   164
         Width           =   480
      End
   End
   Begin VB.Frame Frame3 
      Height          =   3615
      Left            =   4080
      TabIndex        =   6
      Top             =   240
      Width           =   2055
      Begin VB.CheckBox chkPSI 
         Caption         =   "&PSIs"
         Enabled         =   0   'False
         Height          =   255
         Left            =   720
         TabIndex        =   7
         Top             =   360
         Width           =   1215
      End
      Begin MSComctlLib.ListView lstPSI 
         Height          =   2775
         Left            =   120
         TabIndex        =   8
         Top             =   720
         Width           =   1815
         _ExtentX        =   3201
         _ExtentY        =   4895
         View            =   3
         LabelEdit       =   1
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         Checkboxes      =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         NumItems        =   1
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "PSIs"
            Object.Width           =   3528
         EndProperty
      End
      Begin VB.Image Image3 
         Height          =   480
         Left            =   120
         Picture         =   "Imprimir.frx":0E54
         Top             =   164
         Width           =   480
      End
   End
   Begin VB.Frame Frame2 
      Height          =   3615
      Left            =   2040
      TabIndex        =   3
      Top             =   240
      Width           =   2055
      Begin VB.CheckBox chkObj 
         Caption         =   "&Objetos"
         Enabled         =   0   'False
         Height          =   255
         Left            =   720
         TabIndex        =   4
         Top             =   360
         Width           =   1215
      End
      Begin MSComctlLib.ListView lstObj 
         Height          =   2775
         Left            =   120
         TabIndex        =   5
         Top             =   720
         Width           =   1815
         _ExtentX        =   3201
         _ExtentY        =   4895
         View            =   3
         LabelEdit       =   1
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         Checkboxes      =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         NumItems        =   1
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "Objetos"
            Object.Width           =   3528
         EndProperty
      End
      Begin VB.Image Image2 
         Height          =   480
         Left            =   120
         Picture         =   "Imprimir.frx":171E
         Top             =   164
         Width           =   480
      End
   End
   Begin VB.Frame Frame1 
      Height          =   3615
      Left            =   0
      TabIndex        =   0
      Top             =   240
      Width           =   2055
      Begin VB.CheckBox chkConex 
         Caption         =   "&Mapa"
         Enabled         =   0   'False
         Height          =   255
         Left            =   240
         TabIndex        =   15
         Top             =   3240
         Width           =   1455
      End
      Begin VB.CheckBox chkLoc 
         Caption         =   "&Localidades"
         Enabled         =   0   'False
         Height          =   255
         Left            =   720
         TabIndex        =   1
         Top             =   360
         Width           =   1215
      End
      Begin MSComctlLib.ListView lstLoc 
         Height          =   2415
         Left            =   120
         TabIndex        =   2
         Top             =   720
         Width           =   1815
         _ExtentX        =   3201
         _ExtentY        =   4260
         View            =   3
         LabelEdit       =   1
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         Checkboxes      =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         BeginProperty Font {0BE35203-8F91-11CE-9DE3-00AA004BB851} 
            Name            =   "Arial"
            Size            =   8.25
            Charset         =   0
            Weight          =   400
            Underline       =   0   'False
            Italic          =   0   'False
            Strikethrough   =   0   'False
         EndProperty
         NumItems        =   1
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "Localidades"
            Object.Width           =   2540
         EndProperty
      End
      Begin VB.Image Image1 
         Height          =   480
         Left            =   120
         Picture         =   "Imprimir.frx":1FE8
         Top             =   164
         Width           =   480
      End
   End
   Begin VB.Label Label1 
      Caption         =   "Selecciona la categora o categoras a imprimir:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   14
      Top             =   0
      Width           =   5055
   End
End
Attribute VB_Name = "frmImprimir"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

' para guardar los trazos de conexiones desde una localidad
' en la rutina 'ImprimeConexiones'
Private Type TrazoConex
    Loc As Long
    TxtCon As String
    X0 As Long
    Y0 As Long
    X1 As Long
    Y1 As Long
End Type

' coordenadas extremas del mapa
Dim lMinX As Long
Dim lMinY As Long
Dim lMaxX As Long
Dim lMaxY As Long

' factores de escala para imprimir el mapa
Dim nEscalaX As Single
Dim nEscalaY As Single

Private Sub cmdCancelar_Click()

    Unload Me

End Sub

Private Sub RellenaListas()
    Dim l As ListItem
    Dim i As Long
    
    lstLoc.ListItems.Clear
    lstObj.ListItems.Clear
    lstPSI.ListItems.Clear
    lstMod.ListItems.Clear
    chkLoc.Enabled = False
    chkConex.Enabled = False
    chkObj.Enabled = False
    chkPSI.Enabled = False
    chkMod.Enabled = False

    If bHayLoc Then
        For i = 0 To UBound(Localidades)
            Set l = lstLoc.ListItems.Add(i + 1, "L" & CStr(i), Localidades(i).Nombre)
            l.Checked = True
        Next
        chkLoc.Enabled = True
        chkConex.Enabled = True
    End If

    If bHayObj Then
        For i = 0 To UBound(Objetos)
            Set l = lstObj.ListItems.Add(i + 1, "O" & CStr(i), Objetos(i).Nombre & " " & Objetos(i).Adjetivo)
            l.Checked = True
        Next
        chkObj.Enabled = True
    End If
    
    If bHayPSI Then
        For i = 0 To UBound(PSIs)
            Set l = lstPSI.ListItems.Add(i + 1, "P" & CStr(i), PSIs(i).Nombre & " " & PSIs(i).Adjetivo)
            l.Checked = True
        Next
        chkPSI.Enabled = True
    End If
    
    If bHayModulos Then
        For i = 0 To UBound(ListaMod)
            Set l = lstMod.ListItems.Add(i + 1, "M" & CStr(i), ListaMod(i).Nombre)
            l.Checked = True
        Next
        chkMod.Enabled = True
    End If
    
End Sub

Private Sub cmdImprimir_Click()
    
    On Error GoTo Error_Imprimir
    Screen.MousePointer = vbHourglass

    If chkLoc.value Then
        ImpLocalidades
    End If
    
    If chkConex.value Then
        ImpMapa
    End If
    
    If chkObj.value Then
        ImpObjetos
    End If
    
    If chkPSI.value Then
        ImpPSIs
    End If
    
    If chkMod.value Then
        ImpModulos
    End If

    Screen.MousePointer = vbDefault
    Exit Sub
    
Error_Imprimir:
    Printer.KillDoc
    Screen.MousePointer = vbDefault
    MsgBox "Error al imprimir: " & Err.Description, vbOKOnly + vbCritical, "Imprimir"
End Sub

Private Sub Form_Load()

    RellenaListas

End Sub

' imprimir localidades
Private Sub ImpLocalidades()
    Dim i As Long, j As Long
    Dim s As String, sVal As String
    
    Printer.Print
    Printer.Print String(40, "-")
    Printer.Print Space(8) & "LOCALIDADES"
    Printer.Print String(40, "-")
    Printer.Print
    
    For i = 0 To UBound(Localidades)
        If lstLoc.ListItems(i + 1).Checked Then
            Printer.FontBold = True
            Printer.Print Localidades(i).Nombre
            Printer.FontBold = False
            ImpTexto Localidades(i).DescCorta
            ImpTexto Localidades(i).DescLarga
            Printer.Print IIf(Localidades(i).Iluminada, "ILUMINADA", "NO ILUMINADA");
            Printer.Print " / ";
            Printer.Print IIf(Localidades(i).Exterior, "EXTERIOR", "NO EXTERIOR")
            
            s = ""
            For j = 0 To UBound(LocProp)
                sVal = PropiedadLoc(CStr(i), LocProp(j).Nombre, "")
                s = s & LocProp(j).Nombre & ":" & sVal & Space(4)
            Next
            ImpTexto s
            
            Printer.Print "GRAFICO = " & Localidades(i).Grafico
            Printer.Print "SONIDO = " & Localidades(i).Sonido
            Printer.Print String(40, "-")
        End If
    Next
    
    Printer.EndDoc
    
End Sub

' imprimir objetos
Private Sub ImpObjetos()
    Dim i As Long, j As Long
    Dim s As String, sVal As String
    
    Printer.Print
    Printer.Print String(40, "-")
    Printer.Print Space(8) & "OBJETOS"
    Printer.Print String(40, "-")
    Printer.Print

    For i = 0 To UBound(Objetos)
        If lstObj.ListItems(i + 1).Checked Then
            Printer.FontBold = True
            Printer.Print Objetos(i).Nombre & " " & Objetos(i).Adjetivo
            Printer.FontBold = False
            ImpTexto Objetos(i).DescCorta
            ImpTexto Objetos(i).DescLarga
            Printer.Print "PESO = " & Objetos(i).Peso;
            Printer.Print Space(8) & "TAMAO = " & Objetos(i).Tam
            Printer.Print "CONTENIDO EN ";
            Select Case Objetos(i).TipoContenedor
                Case OBJ_CONTLOC
                    Printer.Print "LOCALIDAD";
                Case OBJ_CONTOBJ
                    Printer.Print "OBJETO";
                Case OBJ_CONTPSI
                    Printer.Print "PSI";
            End Select
            Printer.Print " = " & Objetos(i).Contenedor
            
            s = ""
            For j = 0 To UBound(ObjProp)
                sVal = PropiedadObj(CStr(i), ObjProp(j).Nombre, "")
                s = s & ObjProp(j).Nombre & ":" & sVal & Space(4)
            Next
            ImpTexto s
            
            Printer.Print "GRAFICO = " & Objetos(i).Grafico
            Printer.Print "SONIDO = " & Objetos(i).Sonido
            Printer.Print String(40, "-")
        End If
    Next

    Printer.EndDoc

End Sub

' imprimir PSIs
Private Sub ImpPSIs()
    Dim i As Long, j As Long
    Dim s As String, sVal As String
    
    Printer.Print
    Printer.Print String(40, "-")
    Printer.Print Space(8) & "PSIs"
    Printer.Print String(40, "-")
    Printer.Print
    
    For i = 0 To UBound(PSIs)
        If lstPSI.ListItems(i + 1).Checked Then
            Printer.FontBold = True
            Printer.Print PSIs(i).Nombre & " " & PSIs(i).Adjetivo
            Printer.FontBold = False
            ImpTexto PSIs(i).DescCorta
            ImpTexto PSIs(i).DescLarga
            Printer.Print "PESO = " & PSIs(i).Peso;
            Printer.Print Space(8) & "TAMAO = " & PSIs(i).Tam
            Printer.Print "LOCALIDAD = " & PSIs(i).Localidad
            
            s = ""
            For j = 0 To UBound(PSIProp)
                sVal = PropiedadPSI(CStr(i), PSIProp(j).Nombre, "")
                s = s & PSIProp(j).Nombre & ":" & sVal & Space(4)
            Next
            ImpTexto s
            
            Printer.Print "GRAFICO = " & PSIs(i).Grafico
            Printer.Print "SONIDO = " & PSIs(i).Sonido
            Printer.Print String(40, "-")
        End If
    Next
    
    Printer.EndDoc
    
End Sub

' imprimir mdulos
Private Sub ImpModulos()
    Dim i As Long
    Dim iFich As Integer
    Dim s As String, sFich As String
        
    Printer.Print
    Printer.Print String(40, "-")
    Printer.Print Space(8) & "MODULOS"
    Printer.Print String(40, "-")
    Printer.Print

    For i = 0 To UBound(ListaMod)
        If lstMod.ListItems(i + 1).Checked Then
            Printer.FontBold = True
            Printer.Print ListaMod(i).Nombre
            Printer.FontBold = False
            Printer.Print
        
            iFich = FreeFile
            sFich = RutaFich(sFichAventura) & "\" & ListaMod(i).Fichero
            Open sFich For Input As #iFich
            Do While Not EOF(iFich)
                Line Input #iFich, s
                ImpTexto s
            Loop
            Close #iFich
            Printer.Print String(40, "-")
        End If
    Next
    
    Printer.EndDoc
    
End Sub

' imprime un texto largo, en varias lneas
Private Sub ImpTexto(ByVal s As String)
    Dim l() As String
    Dim i As Long
    
    DivideLin s, Printer.ScaleWidth, l
    For i = 0 To UBound(l)
        Printer.Print l(i)
    Next

End Sub

' divide una lnea en varias partes si es demasiado larga
' para entrar en la anchura definida
' devuelve la lnea dividida como una matriz de cadenas
Private Sub DivideLin(ByVal sLin As String, ByVal lMaxAncho As Long, _
  Div() As String)
    Dim lAncho As Long
    Dim i As Integer, j As Integer, k As Integer, n As Integer, iPartes As Integer
    
    lAncho = Printer.TextWidth(sLin)
    ' si la anchura supera la mxima entonces hay
    ' que dividir la lnea en varias partes
    If lAncho > lMaxAncho Then
        iPartes = (lAncho / lMaxAncho) + 1
        ReDim Div(iPartes - 1)
        j = 1
        For i = 0 To iPartes - 1
            Div(i) = ""
            Do While Printer.TextWidth(Div(i)) < lMaxAncho _
              And j <= Len(sLin)
                Div(i) = Div(i) + Mid(sLin, j, 1)
                j = j + 1
            Loop
            ' ajuste para que no se queden palabras
            ' cortadas entre lnea y lnea
            ' para ello comprueba si el siguiente caracter
            ' es un espacio, si no devuelve caracteres
            ' hasta encontrar un espacio
            k = j
            If j < Len(sLin) And Mid(sLin, j, 1) <> " " Then
                Do While Mid(sLin, j, 1) <> " "
                    j = j - 1
                    ' si ha llegado al principio de la lnea
                    ' sin encontrar un espacio, divide como
                    ' estaba antes de entrar aqu
                    If j = 0 Then
                        Div(i) = Left(sLin, k)
                        ' le resta 1 porque luego se lo suma
                        j = k - 1
                        Exit Do
                    End If
                    n = Len(Div(i))
                    Div(i) = Left(Div(i), n - 1)
                Loop
                j = j + 1
            Else
                ' saltamos el espacio para que la
                ' siguiente lnea empiece con un caracter
                j = j + 1
            End If
        Next
    Else
        ReDim Div(0)
        Div(0) = sLin
    End If
    
End Sub

' imprimir mapa
Private Sub ImpMapa()
    Dim i As Long

    Printer.Print
    CalculaEscala
    For i = 0 To UBound(Localidades)
        ImprimeLocalidad i
    Next
    For i = 0 To UBound(Localidades)
        ImprimeConexiones i
    Next
    Printer.EndDoc

End Sub

' calcula las coordenadas extremas y los factores de escala para imprimir el mapa
Private Sub CalculaEscala()
    Dim i As Long

    lMinX = 999999999
    lMinY = 999999999
    lMaxX = -1
    lMaxY = -1
    
    ' calculamos las dimensiones de la superficie ocupada por el mapa
    For i = 0 To UBound(Localidades)
        If Localidades(i).X < lMinX Then
            lMinX = Localidades(i).X
        End If
        If Localidades(i).X + TAM_LOCX > lMaxX Then
            lMaxX = Localidades(i).X + TAM_LOCX
        End If
        If Localidades(i).Y < lMinY Then
            lMinY = Localidades(i).Y
        End If
        If Localidades(i).Y + TAM_LOCY > lMaxY Then
            lMaxY = Localidades(i).Y + TAM_LOCY
        End If
    Next
    
    ' factores de escala para imprimir
    nEscalaX = Printer.ScaleWidth / (lMaxX - lMinX)
    nEscalaY = Printer.ScaleHeight / (lMaxY - lMinY)
    
    ' tomamos el factor menor
    If nEscalaX < nEscalaY Then
        nEscalaY = nEscalaX
    Else
        nEscalaX = nEscalaY
    End If
    
    ' no imprimimos mayor de 1:1
    If nEscalaX > 1 Then
        nEscalaX = 1
    End If
    If nEscalaY > 1 Then
        nEscalaY = 1
    End If

End Sub

Private Sub ImprimeLocalidad(lLoc As Long)
    Dim lX As Long, lY As Long, lTamLocX As Long, lTamLocY As Long, _
      lAncho As Long
    Dim sDesc As String
        
    lTamLocX = TAM_LOCX * nEscalaX
    lTamLocY = TAM_LOCY * nEscalaY
    lX = Localidades(lLoc).X
    lY = Localidades(lLoc).Y
    
    If lX = -1 Or lY = -1 Then
        Exit Sub
    End If
    
    lX = (lX * nEscalaX) - (lMinX * nEscalaX)
    lY = (lY * nEscalaY) - (lMinY * nEscalaY)
    sDesc = Localidades(lLoc).Nombre

    ' cuadro
    Printer.Line (lX, lY)-Step(lTamLocX, lTamLocY), , B
    
    ' texto
    Printer.CurrentY = lY + lTamLocY + 25
    lAncho = Printer.TextWidth(sDesc)
    Printer.CurrentX = lX + ((lTamLocX - lAncho) / 2)
    Printer.Print sDesc
    
End Sub

Private Sub ImprimeConexiones(lLoc As Long)
    Dim c() As TrazoConex
    Dim bRepetida As Boolean
    Dim i As Long, j As Long, n As Long, lX As Long, lY As Long, lX1 As Long, _
      lY1 As Long, lTamLocX As Long, lTamLocY As Long, lVConexDeltaX As Long, _
      lVConexDeltaY As Long, lLocCon As Long
    Dim sLocalidad As String, sVerbo As String
        
    lVConexDeltaX = VCONEX_DELTAX * nEscalaX
    lVConexDeltaY = VCONEX_DELTAY * nEscalaY
    lTamLocX = TAM_LOCX * nEscalaX
    lTamLocY = TAM_LOCY * nEscalaY
    lX = Localidades(lLoc).X
    lY = Localidades(lLoc).Y
    
    If lX = -1 Or lY = -1 Then
        Exit Sub
    End If

    lX = (lX * nEscalaX) - (lMinX * nEscalaX)
    lY = (lY * nEscalaY) - (lMinY * nEscalaY)

    n = UBound(Localidades(lLoc).Conexiones)
    ReDim c(n)
    For i = 0 To n
        c(i).Loc = -1
    Next
    
    For i = 0 To n
        sLocalidad = Localidades(lLoc).Conexiones(i).Localidad
        sVerbo = Localidades(lLoc).Conexiones(i).Verbo
        ' cambiamos el verbo para indicar si est abierta o cerrada
        If Not Localidades(lLoc).Conexiones(i).Abierta Then
            sVerbo = "[" & sVerbo & "]"
        End If
        
        ' busca la localidad con la que est conectada
        lLocCon = BuscaLocalidad(sLocalidad)
        If lLocCon >= 0 Then
            lX1 = Localidades(lLocCon).X
            lY1 = Localidades(lLocCon).Y
            If Localidades(lLocCon).Nombre <> "" And lX1 <> -1 And lY1 <> -1 Then
                lX1 = (lX1 * nEscalaX) - (lMinX * nEscalaX)
                lY1 = (lY1 * nEscalaY) - (lMinY * nEscalaY)
                ' comprobamos si ya exista una conexin entre las dos localidades
                ' en ese caso aadimos el verbo al texto para que salga encadenado
                ' y evitar que se sobreescriba
                bRepetida = False
                For j = 0 To i
                    If c(j).Loc = lLocCon Then
                        c(j).TxtCon = c(j).TxtCon & "" & sVerbo
                        bRepetida = True
                    End If
                Next
                
                If Not bRepetida Then
                    c(i).Loc = lLocCon
                    c(i).X0 = lX
                    c(i).Y0 = lY
                    c(i).X1 = lX1
                    c(i).Y1 = lY1
                    c(i).TxtCon = sVerbo
                Else
                    ' para saltrnosla cuando dibujemos las conexiones
                    c(i).Loc = -1
                End If
            End If
        End If
    Next
    
    ' dibujamos las conexiones
    For i = 0 To n
        lLocCon = c(i).Loc
        If lLocCon <> -1 Then
            ' lnea
            lX = c(i).X0
            lY = c(i).Y0
            lX1 = c(i).X1
            lY1 = c(i).Y1
            Printer.Line (lX + (lTamLocX / 2), lY + (lTamLocY / 2))-(lX1 + (lTamLocX / 2), lY1 + (lTamLocY / 2))
                       
            ' si es una conexin consigo misma
            If lLoc = lLocCon Then
                Printer.CurrentX = lX - (Printer.TextWidth(c(i).TxtCon) / 2)
                Printer.CurrentY = lY - Printer.TextHeight(c(i).TxtCon)
                Printer.FontItalic = True
            Else
                Printer.CurrentX = lX + ((lX1 - lX) / lVConexDeltaX)
                Printer.CurrentY = lY + ((lY1 - lY) / lVConexDeltaY)
                Printer.FontItalic = False
            End If
            
            Printer.Print c(i).TxtCon
        End If
    Next

End Sub

