//
// Procedimientos de usuario
//
// NOTA: los procedimientos de este mdulo permiten "enganchar" cdigo de usuario
// a las respuestas y al bucle principal del juego.
// Los procedimientos de este mdulo son los nicos que deberan
// modificarse.
//
// v2.01 (03.04.2000)
//

// ********************************************************
// Los siguientes procedimientos (USR_...) son enganches desde el mdulo 'Librera'.
// Estos procedimientos se llaman cuando el jugador teclea alguna de las acciones
// asociadas y antes de que la librera los procese con lo que se puede
// colocar cdigo que responda a casos especiales.
//
// Algunos reciben parmetros que pueden usarse para determinar su comportamiento.
//
// En todos ellos se debe devolver un valor para indicar si se ha respondido
// o no a la accin.
// ********************************************************

// --------------------------------------------------------
// aqu podemos aadir informacin a la lnea de estado
// para ello slo tenemos que imprimirla con Print ya que
// al entrar a este procedimiento ya estar seleccionada
// la lnea de estado y el cursor posicionado justo detrs
// de la descripcin corta de la localidad
// si se quiere posicionar con exactitud el texto a imprimir
// se usar ScreenAt(pant_info,x,y) donde 'x' e 'y' marcan
// la posicin dentro de la lnea de estado
// --------------------------------------------------------
Sub USR_LineaEstado()

    ScreenAt(pant_info,500,0)
    Print("Turnos: " + turnos)

Return

// --------------------------------------------------------
// a este procedimiento se le llama antes de mover al jugador
// recibe:
//      'dir' verbo de movimiento que indica la direccin hacia
//            donde quiere moverse el jugador
// debe devolver TRUE si el jugador se mueve o FALSE si se queda donde est
// --------------------------------------------------------
Sub USR_MueveJugador(dir)
    Declare(ret)

    ret:=TRUE

    // NOTAS:
    // en este procedimiento pueden hacerse comprobaciones de si una puerta
    // est abierta para permitir o impedir el paso del jugador en una
    // determinada direccin, si devolvemos FALSE se le impedir el paso
    // al jugador, por ejemplo:
    //
    // If (PSI[PSIJugador].Localidad="HABITACION") & Not(LOC[dir].Abierta) Then
    //     Print("La puerta " + dir + " est cerrada." + CR)
    //     ret:=FALSE
    // EndIf

Return ret

// --------------------------------------------------------
// EXAMINAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Examinar()
    Declare(ret)

    ret:=FALSE
    
    // NOTAS:
    // se llama a este procedimiento justo antes de realizar la accin
    // por defecto del comando EXAMINAR que es devolver una descripcin
    // del objeto o PSI en cuestin
    // si queremos sustituir alguna descripcin por la nuestra propia
    // debemos imprimirla aqu y devolver TRUE para que no se ejecute
    // el EXAMINAR estndar, por ejemplo:
    //
    // If PSI[PSIJugador].Localidad="HABITACION" Then
    //     Select ParseNombre1
    //         Case "CAMA"
    //             Print("Parece una cama muy cmoda." + CR)
    //             ret:=TRUE
    //         Case "MESA"
    //             Print("La mesa est muy desvencijada." + CR)
    //             ret:=TRUE
    //     EndSelect
    // EndIf
    
Return ret

// --------------------------------------------------------
// EXAMINAR DETALLES
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver el texto sobre los detalles adicionales del
// PSI o el objeto que se imprimirn al examinarlo
// --------------------------------------------------------
Sub USR_ExaminarDetalles(psi,nombre)
    Declare(txt)

    txt:=""

    // NOTA:
    // el EXAMINAR estndar llamar a esta procedimiento para obtener detalles
    // adicionales sobre el objeto o PSI en cuestin
    // detalles como si una botella est abierta o cerrada, o si un PSI
    // est herido, etc... por ejemplo:
    //
    // If psi Then
    //     // suponemos que hemos definido una propiedad 'Herido' para los PSIs
    //     If PSI[nombre].Herido Then
    //         txt:="Tiene una herida por la que mana sangre en abundancia."
    //     Else
    //         txt:="Parece que est en buena forma."
    //     EndIf
    // Else
    //     // suponemos que hemos definido una propiedad 'Lleno' para los objetos
    //     // que contendr una cadena vaca si el objeto est vaco o una descripcin
    //     // del lquido que contiene si est lleno
    //     If OBJ[nombre].Lleno="" Then
    //         txt:="Est vaco."
    //     Else
    //         txt:="Contiene un poco de " + OBJ[nombre].Lleno + "."
    //     EndIf
    // EndIf

    // aadimos un espacio adicional a los detalles
    If txt<>"" Then
        txt:=" " + txt
    EndIf

Return txt

// --------------------------------------------------------
// COGER
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Coger(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta COGER
    // un objeto o PSI, podemos obviar la accin estndar de COGER
    // si se devuelve TRUE, por ejemplo:
    //
    // If psi Then
    //     // suponemos que se ha definido una propiedad 'Cogido' para los PSIs
    //     If PSI[nombre].Cogido Then
    //         Print("Ya llevas en brazos a " + PSI[nombre].DescCorta + "." + CR)
    //         PSI[nombre].Cogido:=TRUE
    //     Else
    //         Print("Coges en brazos a " + PSI[nombre].DescCorta + "." + CR)
    //     EndIf
    //     ret:=TRUE
    // Else
    //     // la tpica accin de COGER PIEDRA que aumenta las que lleva el jugador
    //     If (nombre="PIEDRA") & (PSI[PSIJugador].Localidad="CAMINO") Then
    //         Print("Coges una piedra de la muchas que hay por el suelo." + CR)
    //         piedras:=piedras+1
    //         ret:=TRUE
    //     EndIf
    // EndIf

Return ret

// --------------------------------------------------------
// DEJAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Dejar(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta DEJAR
    // un objeto o PSI, podemos obviar la accin estndar de DEJAR
    // si se devuelve TRUE, por ejemplo:
    //
    // If psi Then
    //     // suponemos que se ha definido una propiedad 'Cogido' para los PSIs
    //     If PSI[nombre].Cogido Then
    //         Print("Dejas a " + PSI[nombre].DescCorta + " en el suelo." + CR)
    //         PSI[nombre].Cogido:=FALSE
    //     Else
    //         Print("No llevas a " + PSI[nombre].DescCorta + " en brazos." + CR)
    //     EndIf
    //     ret:=TRUE
    // Else
    //     // la tpica accin de DEJAR PIEDRA que decrementa las que lleva el jugador
    //     If nombre="PIEDRA" Then
    //         If piedras>0 Then
    //             Print("Dejas una piedra." + CR)
    //             piedras:=piedras-1
    //         Else
    //             Print("No tienes piedras." + CR)     
    //         EndIf
    //         ret:=TRUE
    //     EndIf
    // EndIf

Return ret

// --------------------------------------------------------
// METER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
//      'nombre_contenedor' nombre del objeto dnde queremos meterlo
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Meter(nombre,nombre_contenedor)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta METER
    // un objeto dentro de otro, podemos obviar la accin estndar
    // de METER si se devuelve TRUE, por ejemplo:
    //
    // If (nombre="PIEDRA") & (nombre_contenedor="SACO") Then
    //     If piedras>0 Then
    //         Print("Metes una piedra en el saco." + CR)
    //         piedras:=piedras-1
    //         piedras_saco:=piedras_saco+1
    //     Else
    //         Print("No llevas ninguna piedra." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// SACAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
//      'nombre_contenedor' nombre del objeto dnde queremos meterlo
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Sacar(nombre,nombre_contenedor)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta SACAR
    // un objeto de otro, podemos obviar la accin estndar
    // de SACAR si se devuelve TRUE, por ejemplo:
    //
    // If (nombre="PIEDRA") & (nombre_contenedor="SACO") Then
    //     If piedras_saco>0 Then
    //         Print("Sacas una piedra del saco." + CR)
    //         piedras_saco:=piedras_saco-1
    //         piedras:=piedras+1
    //     Else
    //         Print("No hay ninguna piedra dentro del saco." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// ABRIR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Abrir(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta ABRIR
    // un objeto, podemos obviar la accin estndar de ABRIR si se
    // devuelve TRUE, por ejemplo:
    //
    // If nombre="PUERTA" Then
    //     If PSI[PSIJugador].Localidad:="HABITACION" Then
    //         If LOC["HABITACION"].Abierta("NORTE") Then
    //             Print("La puerta ya est abierta." + CR)
    //         Else
    //             Print("Abres la puerta." + CR)
    //             LOC["HABITACION"].Abrir("NORTE")
    //         EndIf
    //         ret:=TRUE
    //     EndIf
    // EndIf

Return ret

// --------------------------------------------------------
// CERRAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Cerrar(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta CERRAR
    // un objeto, podemos obviar la accin estndar de CERRAR si se
    // devuelve TRUE, por ejemplo:
    //
    // If nombre="PUERTA" Then
    //     If PSI[PSIJugador].Localidad:="HABITACION" Then
    //         If LOC["HABITACION"].Abierta("NORTE") Then
    //             Print("Cierras la puerta." + CR)
    //             LOC["HABITACION"].Cerrar("NORTE")
    //         Else
    //             Print("La puerta ya est cerrada." + CR)
    //         EndIf
    //         ret:=TRUE
    //     EndIf
    // EndIf

Return ret

// --------------------------------------------------------
// PONER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Poner(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta PONER
    // un objeto, podemos obviar la accin estndar de PONER si se
    // devuelve TRUE, por ejemplo:
    //
    // If nombre="ESCAFANDRA" Then
    //     Print("No ests entrenado para ponerte una escfandra. Quiz deberas pedir ayuda." + CR)
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// QUITAR
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Quitar(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta QUITAR
    // un objeto, podemos obviar la accin estndar de QUITAR si se
    // devuelve TRUE, por ejemplo:
    //
    // If (nombre="ESCAFANDRA") & (PSI[PSIJugador].Localidad:="FONDO MARINO") Then
    //     Print("Primero deberas salir del agua, no crees?." + CR)
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// ENCENDER
// recibe:
//      'nombre' nombre del objeto/PSI sobre el que se acta
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Encender(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta ENCENDER
    // un objeto, podemos obviar la accin estndar de ENCENDER si se
    // devuelve TRUE, por ejemplo:
    //
    // If nombre="TELEVISION" Then
    //     If OBJ[nombre].Encendido Then
    //         Print("La televisin ya est encendida." + CR)
    //     Else
    //         Print("Enciendes la televisin." + CR)
    //         OBJ[nombre].Encendido:=TRUE
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// APAGAR
// recibe:
//      'nombre' nombre del objeto/PSI sobre el que se acta
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Apagar(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta APAGAR
    // un objeto, podemos obviar la accin estndar de APAGAR si se
    // devuelve TRUE, por ejemplo:
    //
    // If nombre="TELEVISION" Then
    //     If OBJ[nombre].Encendido Then
    //         Print("Apagas la televisin." + CR)
    //         OBJ[nombre].Encendido:=FALSE
    //     Else
    //         Print("La televisin est apagada." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// SABOREAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Saborear(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta SABOREAR o CHUPAR
    // un objeto o PSI, podemos obviar la accin estndar de SABOREAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// OLER
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Oler(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta OLER
    // un objeto o PSI, podemos obviar la accin estndar de OLER si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// ESCUCHAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Escuchar(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta ESCUCHAR
    // un objeto o PSI, podemos obviar la accin estndar de ESCUCHAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// TOCAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Tocar(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta TOCAR
    // un objeto o PSI, podemos obviar la accin estndar de TOCAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// LANZAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Lanzar()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se llama cuando se intenta LANZAR algo
    // la accin por defecto de LANZAR es dejar el objeto
    // podemos obviar la accin estndar codificndola aqu
    // y devolviendo TRUE, por ejemplo:
    //
    // If ParseNombre1:="PIEDRA" Then
    //     If piedras>0 Then
    //         Print("Arrojas la piedra muy lejos." + CR)
    //         piedras:=piedras-1
    //     Else
    //         Print("No llevas ninguna piedra." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// GOLPEAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Golpear(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta GOLPEAR
    // un objeto o PSI, podemos obviar la accin estndar de GOLPEAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// CORTAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Cortar(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta CORTAR
    // un objeto o PSI, podemos obviar la accin estndar de CORTAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// ATAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Atar(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta ATAR
    // un objeto o PSI, podemos obviar la accin estndar de ATAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// DESATAR
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Desatar(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta DESATAR
    // un objeto o PSI, podemos obviar la accin estndar de DESATAR si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// MOVER
// recibe:
//      'psi' TRUE si nos referimos a un PSI o FALSE a un objeto
//      'nombre' nombre del objeto o PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Mover(psi,nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta MOVER
    // un objeto o PSI, podemos obviar la accin estndar de MOVER si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_COGER ---

Return ret

// --------------------------------------------------------
// MATAR
// recibe:
//      'nombre' nombre del PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Matar(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta MATAR
    // a un PSI, podemos obviar la accin estndar de MATAR si se
    // devuelve TRUE, por ejemplo:
    //
    // If EstaPresentaPSI(nombre) Then
    //     If PSI[PSIJugador].Contiene("PISTOLA") Then
    //         If PSI[nombre].Muerto Then
    //             Print(PSI[nombre].DescCorta + " ya est muerto. No querrs matarlo dos veces?." + CR)
    //         Else
    //             Print("Disparas contra " + PSI[nombre].DescCorta + " y este cae muerto al suelo." + CR)
    //             PSI[nombre].Muerto:=TRUE
    //         EndIf
    //     Else
    //         Print("No tienes ningn arma que puedas usar para matar a " + PSI[nombre].DescCorta + "." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// BEBER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Beber(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta BEBER
    // algo, podemos obviar la accin estndar de BEBER si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_ENCENDER ---

Return ret

// --------------------------------------------------------
// COMER
// recibe:
//      'nombre' nombre del objeto al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Comer(nombre)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta COMER
    // algo, podemos obviar la accin estndar de COMER si se
    // devuelve TRUE, por ejemplo:
    //
    // --- PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_ENCENDER ---

Return ret

// --------------------------------------------------------
// SALTAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Saltar()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta SALTAR
    // podemos obviar la accin estndar de SALTAR si se devuelve TRUE
    // por ejemplo:
    //
    // If ParseNombre1="ABISMO" Then
    //     If PSI[PSIJugador].Localidad="ABISMO" Then
    //         Print("Con total despreocupacin por la vida, te lanzas al vaco..." + CR)
    //         Print("*** Ests muerto ***" + CR)
    //         Abandonar()
    //     Else
    //         Print("A qu abismo?. Creo que deliras." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// GRITAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Gritar()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta GRITAR
    // podemos obviar la accin estndar de GRITAR si se devuelve TRUE
    // por ejemplo:
    //
    // ---  PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_SALTAR ---


Return ret

// --------------------------------------------------------
// CANTAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Cantar()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta CANTAR
    // podemos obviar la accin estndar de CANTAR si se devuelve TRUE
    // por ejemplo:
    //
    // ---  PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_SALTAR ---

Return ret

// --------------------------------------------------------
// BESAR
// recibe:
//      'psi' nombre del PSI al que nos referimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Besar(psi)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta BESAR a un PSI
    // podemos obviar la accin estndar de BESAR si se devuelve TRUE
    // por ejemplo:
    //
    // If psi="NIA" Then
    //     If EstaPresente(psi) Then
    //         Print("La nia se pone muy contenta." + CR)
    //     EndIf
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// DORMIR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Dormir()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta DORMIR
    // podemos obviar la accin estndar de DORMIR si se devuelve TRUE
    // por ejemplo:
    //
    // ---  PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_SALTAR ---

Return ret

// --------------------------------------------------------
// DECIR
// recibe:
//      'nombre' nombre del PSI al que nos referimos
//      'frase' frase que le decimos
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Decir(nombre,frase)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta DECIR A PSI "xxx"
    // podemos obviar la accin estndar de DECIR si se devuelve TRUE
    // por ejemplo:
    //
    // If nombre="NIA" Then
    //     Parse(frase)
    //     If (ParseVerbo="COMO") & (ParseNombre1="LLAMAS") Then
    //         HablaPSI("Me llamo Mara pero mi mam me llama Mari.","dice la nia.")
    //     Else
    //         HablaPSI("No te entiendo.","dice la nia.")
    //     EndIf
    //     ret:=TRUE
    // EndIf     

Return ret

// --------------------------------------------------------
// DAR
// recibe:
//      'objeto' nombre del objeto que queremos dar
//      'psi' nombre del PSI a quien le queremos dar el objeto
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Dar(objeto,psi)
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta DAR OBJ A PSI
    // podemos obviar la accin estndar de DAR si se devuelve TRUE
    // por ejemplo:
    //
    // If (objeto="ESPADA") & (psi="SOLDADO") Then
    //     Print("El soldado coge la espada que le entregas y de un mandoble mortal decapita al troll.")
    //     HablaPSI("Gracias, por poco no lo contamos.","dice el soldado al tiempo que te devuelve la espada.")
    //     ret:=TRUE
    // EndIf

Return ret

// --------------------------------------------------------
// ESPERAR
// debe devolver TRUE si di respuesta a la accin, FALSE si no
// --------------------------------------------------------
Sub USR_Esperar()
    Declare(ret)

    ret:=FALSE

    // NOTAS:
    // este procedimiento se ejecuta cada vez que se intenta ESPERAR
    // podemos obviar la accin estndar de ESPERAR si se devuelve TRUE
    // por ejemplo:
    //
    // ---  PARA UN EJEMPLO SIMILAR SE PUEDE CONSULTAR EL DE USR_SALTAR ---

Return ret

// --------------------------------------------------------
// acciones anteriores a que se procese el comando del jugador
// aqu se llega despus de analizar el comando pero antes
// de que se ejecute la accin asociada (si hubiese alguna)
// --------------------------------------------------------
Sub USR_Ant()

    // NOTAS:
    // uno de los usos de este procedimiento es convertir
    // ciertas acciones del jugador en otras
    // por ejemplo:
    //
    // suponemos que hemos codificado la respuesta a LLENAR VASO y queremos que
    // el jugador pueda tambin teclear VERTER o VACIAR LICOR EN VASO y
    // VERTER o VACIAR BOTELLA EN VASO sin tener que codificar una respuesta independiente
    // a estas acciones, podemos conseguir esto de la siguiente manera:
    //
    // If ((ParseVerbo="VERTER") | (ParseVerbo="VACIAR")) & ((ParseNombre1="LICOR") | (ParseNombre1="BOTELLA")) & (ParseNombre2="VASO") Then
    //     ParseVerbo:="LLENAR"
    //     ParseNombre1:="VASO"
    //     ParseNombre2:=""
    // Endif
    //
    // ahora la aventura entender tanto LLENAR VASO, VERTER LICOR EN VASO,
    // VACIAR BOTELLA EN VASO como la misma accin y dar respuesta como si
    // hubisemos tecleado LLENAR VASO en cualquier caso

Return

// --------------------------------------------------------
// acciones posteriores a que se procese el comando del jugador
// --------------------------------------------------------
Sub USR_Post()

    // NOTAS:
    // aqu podemos colocar el cdigo de control de PSIs o cosas
    // que queremos que pasen en cada turno, justo despus de que
    // el jugador haya completado su accin

Return

// --------------------------------------------------------
// respuestas a otras acciones no contempladas en la librera estndar
// debe devolver TRUE si se di una respuesta a al accin o FALSE si no
// --------------------------------------------------------
Sub USR_Respuesta()
    Declare(ret)
    Declare(obj)

    ret:=FALSE

    // NOTAS:
    // la estructura ms comn del cdigo en este procedimiento
    // consiste en una sentencia SELECT que discrimine el verbo
    // tecleado y ejecute la accin correspondiente, por ejemplo:
    //
    // Select ParseVerbo
    //     Case "DESNUDAR"
    //         ...
    //         ret:=TRUE
    //     Case "VESTIR"
    //         ...
    //         ret:=TRUE
    //     Case "LLENAR"
    //         ...
    //         ret:=TRUE
    // EndSelect

Return ret

// --------------------------------------------------------
// mensajes de copyright
// --------------------------------------------------------
Sub USR_Copyright()
    Declare(spc)
    Declare(copyright)
    Declare(email)
    Declare(web)
    Declare(descripcion)

    spc:="        "
    copyright:="(c)2000 Login:"
    email:="jsjlogin@jet.es"
    web:="http://personales.jet.es/jsjlogin"
    descripcion:="Esta aventura sirve como 'esqueleto' para crear las tuyas propias."

    Print(CR + "    \[Times New Roman]\[12]\[RGB(FFFFCC)]\[N]" + titulo + "\[N]" + CR)
    Print("\[10]\[C]" + spc + copyright + "\[C]" + CR)
    Print(spc + "\[RGB(8080FF)]\[S]" + web + "\[S]    " + email)
    Print(CR + spc + "\[RGB(FFCCCC)]" + descripcion)
    Print(CR + spc + "Versin " + version + " / intrprete " + VerVS)
    // inicializamos el tipo de letra y color del texto
    Print(tipo_letra + color_letra + CR + CR)

Return

// --------------------------------------------------------
// introduccin
// --------------------------------------------------------
Sub USR_Inicio()

    Print("\[RGB(E0E000)]\[Times New Roman]\[C](Teclea \[N]AYUDA\[N] para obtener informacin adicional)\[C]" + tipo_letra + color_letra + CR + CR)

Return

// --------------------------------------------------------
// msica de fondo
// --------------------------------------------------------
Sub USR_MusicaFondo()

    If hay_sonido Then
        musica_fondo:=LoadSong("#9999")
        PlaySong(musica_fondo)
    EndIf

Return

// --------------------------------------------------------
// pantalla de ayuda
// --------------------------------------------------------
Sub USR_Ayuda()

    Print(CR + "\[RGB(E0E000)]\[Times New Roman]En esta aventura tienes disponibles los verbos de accin comunes a casi todas")
    Print(" las aventuras (entre parntesis se indica la forma abreviada):" + CR + CR)
    Print("\[N]COGER, DEJAR, MIRAR (M), EXAMINAR (EX), INVENTARIO (I), METER, SACAR, ABRIR, CERRAR, PONER, QUITAR, ENCENDER, APAGAR, ")
    Print("GOLPEAR, MATAR, ATAR, DESATAR, CORTAR, MOVER, OLER, SABOREAR, TOCAR, ESCUCHAR, LANZAR, BEBER, COMER, ")
    Print("SALTAR, GRITAR, CANTAR, BESAR, DORMIR, DAR")
    Print(CR + CR + "\[N]")
    Print("Se pueden teclear acciones mltiples en una sola lnea sin ms que encadenarlas con comas (,) o con \[N]Y\[N].")
    Print(" Adems se pueden usar pronombres para referirse al ltimo objeto referenciado dentro de una accin, por ejemplo:" + CR + CR)
    Print("\[N]COGER EL LIBRO, LEERLO Y DEJARLO\[N]" + CR + CR)
    Print("Adems puedes hablar con los personajes usando la forma:" + CR + CR)
    Print("\[N]DECIR A PERSONAJE \"FRASE\"\[N]" + CR + CR)
    Print("En cualquier momento puedes hacer que la accin transcurra sin que t hagas nada usando el verbo \[N]ESPERAR (Z)\[N]" + CR + CR)
    Print("Adems puedes guardar y recuperar el estado del juego con los comandos \[N]GUARDAR\[N] y \[N]CARGAR\[N]" + CR + CR)
    Print("Para salir del juego debes teclear \[N]FIN\[N] o \[N]ABANDONAR\[N], pero acurdate de guardar la partida si quieres continuarla ms adelante" + CR + CR)
    Print("\[N]TURNOS\[N] muestra los turnos que llevas de juego." + CR)
    Print(tipo_letra + color_letra)
    PulsaTecla()

Return
