/**************************************
	Fichero de cabecera de
	las funciones de manejo
	del ratn de RATON.C
**************************************/

#if !defined (RATON_H)
#define RATON_H

/*** Constantes ***/
#define R_NOVAL		9999	/* valor para ratn no inicializado */
#define R_MUESTRA       1       /* para mostrar puntero de ratn */
#define R_OCULTA        2       /* para ocultar puntero de ratn */

/*** Tipos de datos y estructuras ***/
typedef struct {
	int boton1, boton2;     /* estado de los botones del ratn */
				/* 1 pulsado, 0 suelto */
	int xv, yv;           	/* posicin virtual del ratn */
	int fil, col;         	/* fila y columna del ratn */
} STC_RATON;

/*** Prototipos ***/
int r_inicializa(void);
int r_puntero(int modo);
int r_estado(STC_RATON *raton);
int r_pon_puntero(int fil, int col);
void r_desconecta(void);

#endif  /* RATON_H */
