#define TINY 1
#define CPM 1
#define YES_GETCH

/* UnQuill: Disassemble games written with the "Quill" adventure game system
    Copyright (C) 1996-2000  John Elliott

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

                             - * -

    Written for gcc under Unix; compiles with Hi-Tech C under CP/M and 
    Pacific C under DOS.
 
    Under CP/M, compile with:  C -DTINY UNQUILL.C TABLES.C CONDACT.C

*/


/* Pull Quill data from a .SNA file.  *
 * Output to stdout.                  */

/* Format of the Quill database:

 Somewhere in memory (6D04h for vanilla Quill with no Illustrator/Patch/Press)
there is a colour definition table:

	DEFB	10h,ink,11h,paper,12h,flash,13h,bright,14h,inverse,15h,over
	DEFB	border

We use this as a magic number to find the Quill database in memory. After
the colour table is a table of values:

	DEFB	no. of objects player can carry at once
	DEFB	no. of objects
	DEFB	no. of locations
	DEFB	no. of messages

then a table of pointers:

	DEFW	rsptab	;Response table
	DEFW	protab	;Process table
	DEFW	objtop	;Top of object descriptions
	DEFW	loctop	;Top of locations.
	DEFW	msgtop	;Top of messages.
	**
	DEFW	conntab	;Table of connections.
	DEFW	voctab	;Table of words.
	DEFW	oloctab	;Table of object inital locations.
	DEFW	free	;[Early] Start of free memory
                    ;[Late]  Word/object mapping
	DEFW	freeend	;End of free memory
	DEFS	3	;?
	DEFB	80h,dict ;Expansion dictionary (for compressed games).
                         ;Dictionary is stored in ASCII, high bit set on last
		         ;letter of each word.
rsptab:	...	     ;response	- both stored as: DB verb, noun
protab: ...          ;process                     DW address-of-handler
                     ;                               terminated by verb 0.
                                         Handler format is:
                                          DB conditions...0FFh
                                          DB actions......0FFh
objtab:	...	     ;objects	- all are stored with all bytes
objtop:	DEFW	objtab        complemented to deter casual hackers.
        DEFW    object1
        DEFW    object2 etc.
loctab:	...		;locations       Texts are terminated with 0E0h
loctop:	DEFW    loctab           (ie 1Fh after decoding).
        DEFW    locno1
        DEFW    locno2 etc.
msgtab:	...		;messages
msgtop:	DEFW    msgtab
        DEFW    mess1
        DEFW    mess2 etc.
conntab: ...    ;connections    - stored as DB WORD,ROOM,WORD,ROOM...
                                  each entry is terminated with 0FFh.

voctab: ...		;vocabulary     - stored as DB 'word',number - the
                                  word is complemented to deter hackers.
                                  Table terminated with a word entry all
                                  five bytes of which are 0 before
                                  decoding.
oloctab: ...    ;initial locations of objects. 0FCh => not created
                                               0FDh => worn
                                               0FEh => carried
                                               0FFh => end of table

In later games (those made with Illustrator?), there is an extra byte 
(the number of system messages) after the number of messages, and at 
the label ** the following word is inserted:

        DEFW    systab  ;Points to word pointing to table of system
                        ;messages.
systab: DEFW    sysm0
        DEFW    sysm1 etc.

The address of the user-defined graphics is stored at 23675. In "Early" games,
the system messages are at UDGs+168.

CPC differences:

* I don't know where the UDGs are.
* Strings are terminated with 0xFF (0 after decoding) rather than 0xE0 
  (0x1F).
* No Spectrum colour codes in strings. Instead, the 
  code 0x14 means "newline" and 0x09 means "toggle reverse video".
  There are other CPC colour codes in the range 0x01-0x0A, but I don't
  know their meaning.
* I have assumed that the database always starts at 0x1BD1, which it does 
  in the snapshots I have examined.
  
Commodore 64 differences:

* I don't know where the UDGs are.
* Strings are terminated with 0xFF (0 after decoding) rather than 0xE0 
  (0x1F).
* No Spectrum colour codes in strings. 
* I have assumed that the database always starts at 0x0804, which it does 
  in the snapshots I have examined.

  
*/

#include <oz.h>
#include <ozmemo.h>
#include "filerand.h"

#define MAINMODULE
#include "unquill.h"    /* Function prototypes */

static ushrt ucptr;

char inname[MAX_FILENAMELEN];   /*Modified L.C*/ /*Made global so that save can remake index*/
char filename[MAX_FILENAMELEN];


int main(int argc, char *argv[])
{
    ushrt zxptr, seekpos;
    static unsigned long filelen;    /*Modified L.C*/
    static ushrt c;          /*Modified L.C*/

    filename[0] = '\0';
   	oopt    = 'R';
	running = 1;

    /* Set font. */
    /*
    ozscancustomfonts();
    ozsetfont( FONT_CUSTOM0 );
    */

 /* Load the snapshot. To save space, we ignore the printer
  buffer and the screen, which can contain nothing of value. */

    strcpy( inname, "quill/" ); /* default directory */

    printf("RunQuill for Sharp. Based on UnQuill.\nFilename?\n" );
	ozeditline( 0, 30, inname, MAX_FILENAMELEN, 239 );    /*Mofied by L.C*/ /*Changed 80 to MAX_FILENAMELEN*/

	/*if((infile = open(inname,O_RDONLY)) == -1)*/
    if ((filelen = makerandomindex(inname)) == -1)   /*Modified L.C*/
	{

/* Since perror() in the CP/M version of Hi-Tech C isn't terribly good, I'll
  sometimes make special arrangements for CP/M error reporting. */

		printf("%s: Cannot open file.\n",inname);
        ozgetch();
		exit(1);
	}

/* << v0.7: Check for CPC6128 format */
	/*if( read(infile, snapid, sizeof(snapid) ) != sizeof(snapid) )*/
	
	if (filelen < sizeof(snapid))         /*Modified L.C*/
	{
		printf("%s: Not in Spectrum, CPC or C64 snapshot format.\n",inname);

	}
	for (c=0; c<sizeof(snapid) ; c ++) {  /*Modified L.C*/
		snapid[c] = getfilebyte(c);   /*Modified L.C*/
	}                                     /*Modified L.C*/


	arch       = ARCH_SPECTRUM;
	seekpos    = 0x1C1B;	/* Number of bytes to skip in the file */
	mem_base   = 0x5C00;	/* First address loaded */
	mem_size   = 0xA400;	/* Number of bytes to load from it */
	mem_offset = 0x3FE5;	/* Load address of snapshot in host system memory */



	 
	

#if 1
	if (!memcmp(snapid, "MV - SNA", 9))	/* CPCEMU snapshot */
	{
		arch = ARCH_CPC;

		seekpos    = 0x1C00;
		mem_base   = 0x1B00;
		mem_size   = 0xA500;
		mem_offset = -0x100;
		dbver = 10;	/* CPC engine is equivalent to  
                                 * the "later" Spectrum one. */

		printf("CPC snapshot signature found.\n");
	}
	if (!memcmp(snapid, "VICE Snapshot File\032", 19))	/* VICE snapshot */
	{
		arch = ARCH_C64;

		seekpos    =  0x874;
		mem_base   =  0x800;
		mem_size   = 0xA500;
		mem_offset =  -0x74;
		dbver = 5;	/* C64 engine is between the two Spectrum 
                     		 * ones. */

		printf("C64 snapshot signature found.\n");
	}
#endif

/* >> v0.7 */


/* .SNA read ok. Find a Quill signature */

	switch(arch)
	{
		case ARCH_SPECTRUM:

            printf("\nInterpret as later version?\n");
            if( yesno() == 'Y' )
                dbver = 10;

		/* I could _probably_ assume that the Spectrum database is 
		 * always at one location for "early" and another for "late"
		 * games. But this method is safer. */
#if 0 /* slow, but reliable */
		    	printf("\nScanning...\n");
                /*for (n = 0x5C00; n < 0xFFF5; n++)*/
                for (n = 0x6B00; n < 0xFFF5; n++) /* not safe, but faster */
				{
                    /*printf( "scanning: %x\n", n );*/
					if ((zmem(n  ) == 0x10) && (zmem(n+2) == 0x11) && 
						(zmem(n+4) == 0x12) && (zmem(n+6) == 0x13) && 
						(zmem(n+8) == 0x14) && (zmem(n+10) == 0x15))
					{
						printf("Quill signature found.\n");
						found = 1;
						zxptr = n + 13;
						break;
					}
				}
#else /* fast but may not work on all files */
					if ((zmem(0x6D04  ) == 0x10) && (zmem(0x6D04+2) == 0x11) && 
						(zmem(0x6D04+4) == 0x12) && (zmem(0x6D04+6) == 0x13) && 
						(zmem(0x6D04+8) == 0x14) && (zmem(0x6D04+10) == 0x15))
					{
						printf("Quill signature found at 0x6D04.\n");
						found = 1;
						zxptr = 0x6D04 + 13;
					}
                    else if ((zmem(0x6B85  ) == 0x10) && (zmem(0x6B85+2) == 0x11) && 
						    (zmem(0x6B85+4) == 0x12) && (zmem(0x6B85+6) == 0x13) && 
						    (zmem(0x6B85+8) == 0x14) && (zmem(0x6B85+10) == 0x15))
					{
						printf("Quill signature found at 0x6B85.\n");
						found = 1;
						zxptr = 0x6B85 + 13;
					}                
#endif
				break;
#if 1
		case ARCH_CPC: 
		        found = 1;
				zxptr = 0x1BD1;	/* From guesswork: CPC Quill files
				                 * always seem to start at 0x1BD1 */
				break;
		case ARCH_C64: 
		        found = 1;
				zxptr = 0x804;	/* From guesswork: C64 Quill files
				                 * always seem to start at 0x804 */
				break;
#endif
	}
	
	if (!found)
	{
		printf("%s does not seem to be a valid Quill .SNA file. If you\n",
          		inname);
		printf("know it is, you have found a bug in RunQuill.\n" );
        ozgetch();
  		exit(1);
  	}




/* Load first buffer (pointers & dictionary) */



	ucptr   = zxptr;
	maxcar1 = maxcar = zmem (zxptr);	/* Player's carrying capacity */
	nobj             = zmem (zxptr +  1);	/* No. of objects */
	nloc             = zmem (zxptr +  2);	/* No. of locations */
	nmsg             = zmem (zxptr +  3);	/* No. of messages */
	if (dbver)
 	{
  		++zxptr;
		nsys     = zmem (zxptr +  3);	/* No. of system messages */
		vocab    = zword(zxptr + 18);	/* Words list */
  		dict     = zxptr + 29;		/* Expansion dictionary */
	}
	else vocab = zword(zxptr + 16);



/* Load second buffer (vocabulary) */


	resptab            = zword(zxptr +  4);
        proctab            = zword(zxptr +  6);
	objtab             = zword(zxptr +  8);
	loctab             = zword(zxptr + 10);
	msgtab             = zword(zxptr + 12);
	if (dbver) sysbase = zword(zxptr + 14);
  	else       sysbase = zword(23675) + 168; /* Just after the UDGs */ 
	conntab            = zword(zxptr + 14 + ( dbver ? 2 : 0));
	if(dbver) objmap   = zword(zxptr + 22);
	postab             = zword(zxptr + 18 + ( dbver ? 2 : 0 ));

	ramsave[0x100] = 0; /* No position RAMsaved */
	while(running)
	{
	    estop = 0;   
		srand(oztime());
		oopt  = 'T';        /* Outputs in plain text */
		initgame(zxptr); /* Initialise the game */
		playgame(zxptr); /* Play it */ 
		if (estop)
		{
		    estop=0;	/* Emergency stop operation, game restarts */
	    	continue;   /* automatically */
        }
		sysmess(13);
		opch32('\n');
		if (yesno()=='N')
		{
		    running=0;
			sysmess(14);
        }
    } /* while(running) */

    putchar('\n');

    return 0;
}	/* End main() */






void initgame(ushrt zxptr)
{
	uchr  n; 
	ushrt obase;

	alsosee = 1;	/* Options possibly set by later games */
	fileid  = 255;
	maxcar1 = maxcar;

	obase = postab; /* Object initial positions table */
	for (n = 0; n < 36; n++) flags[n] = 0;
	
	NUMCAR = 0;
	for (n = 0; n < 255; n++)
	{
		objpos[n] = zmem(obase + n);
		if (objpos[n] == 254) NUMCAR++;
	}
}


void savegame(void)
{
    uchr xor = fileid, n;
    static uchr two = 2;
    static uchr one = 1;

	
	for (n = 0; n < 37;   n++) xor ^= flags[n];
	for (n = 0; n < 0xDB; n++) xor ^= objpos[n];
	opch32('\n');
	printf("Save game to >\n");
    ozeditline( 0, 70, filename, MAX_FILENAMELEN, 239 );   /*Modified by L.C*/

	ozopendatamemowrite( filename, '0' );

    /*
    if( (ozwritedatamemo(&two, sizeof(uchr)) == -1) ||
        (ozwritedatamemo(&one, sizeof(uchr)) == -1) ||
        (ozwritedatamemo(&fileid, sizeof(char)) == -1) ||
	    (ozwritedatamemo(flags, 37) < 37) ||
	    (ozwritedatamemo(objpos,0xDB) < 0xDB) ||
        (ozwritedatamemo(&xor, sizeof(uchr)) == -1)	)
	{
		printf("Write error on %s\n",filename);
		ozgetch();
        return;
	}
    */
    ozwritedatamemo(&two, sizeof(uchr));
    ozwritedatamemo(&one, sizeof(uchr));
    ozwritedatamemo(&fileid, sizeof(char));
	ozwritedatamemo(flags, 37);
	ozwritedatamemo(objpos,0xDB);
    ozwritedatamemo(&xor, sizeof(uchr));


    ozclosedatamemowrite();
	makerandomindex(inname);   /*Modified by L.C*/
} /* savegame(); */

/* Format of Quill save file (based on a Spectrum .TAP file):

DW 0102h	;Length / magic no.
DB 0FFh		;Block type ("fileid") - usually 0FFh, but can be changed in
		;later games by PAUSE, subfunction 22.
DS 31		;Flags 0-30
DW xx		;Flags 31-32 = no. of turns
DB xx		;Flag  33    = verb
DB xx		;Flag  34    = noun
DW xx		;Flags 35-36 = location (flag 36 is always 0)
DS 0DBh		;Object locations table, terminated with 0FFh.
DB xsum		;XOR of all bytes except the 0102h.
*/

void loadgame(void)
{
	uchr xor=0;
	ushrt n;
	uchr savefile[0x104];
	
	opch32('\n');
	printf("Load game from file>\n");
    ozeditline( 0, 70, filename, 255, 239 );

	if( ozopendatamemoread(filename) == -1 )
	{
		printf("Could not open %s\n",filename);
        ozgetch();
		return;
	}

	if( ozreaddatamemo(savefile,0x104) < 0x104 )
	{
		ozclosedatamemoread();
		printf("Read error on %s\n",filename);
        ozgetch();
		return;
	}

    ozclosedatamemoread();

	/* Calculate checksum. */
    for( n = 2; n < 0x103; n++ )
        xor ^= savefile[n];

	if ((xor !=savefile[0x103])
	||  (savefile[0] != 2)
	||  (savefile[1] != 1)
	||  (savefile[2] != fileid))
	{
		printf("%s is not a suitable save file\nPress RETURN...",filename);
		ozgetch();
		return;
	}	
	memcpy(flags,  savefile + 3,  37);
	memcpy(objpos, savefile + 40, 0xDB);
} /* loadgame(); */


char present(uchr obj)
{
	if ((objpos[obj]==254) || (objpos[obj]==253) || (objpos[obj]==CURLOC))
    		return 1;
  	return 0;
}



void playgame(ushrt zxptr)
{
	uchr desc = 1, verb, noun, pn, r; 
	char *lbstart;
	ushrt connbase;
	char linebuf[255];


	lbstart = linebuf;
	while(1) /* Main loop */
	{
		if (desc) 
		{
			clrscr();
			/* 0.7.5: Darkness */
			if (flags[0] && (!present(0))) 
			{
				sysmess(0);
				opch32('\n');
			}
			else
			{
				oneitem(loctab,CURLOC); 
				opch32('\n');
				listat(CURLOC);  /* List objects present */
			}
			desc = 0;

		/* Decrement flags depending on location descriptions */

			if (flags[2]) flags[2]--;
			if (flags[0] && flags[3]) flags[3]--;
			if (flags[0] && (!present(0)) && flags[4]) flags[4]--; 
		}

		/* [new in 0.7.0: Flag decrements moved to *after* the
                 * process table; this makes Bugsy work properly */

		/* Process "process" conditions */

		verb = 0xFF; noun = 0xFF;
		
		r = doproc(zword(zxptr + 6), verb, noun);  /* The Process Table */
		if      (r == 2) desc = 1;      /* DESC */
		else if (r == 3) break;  	/* END  */
		else 
		{ 
                   /* Decrement flags not depending on location descriptions */

                	if (flags[5]) flags[5]--;
                	if (flags[6]) flags[6]--;
                	if (flags[7]) flags[7]--;
                	if (flags[8]) flags[8]--;
       	        	if (flags[0] && flags[9]) flags[9]--;
	                if (flags[0] && (!present(0)) && flags[10]) flags[10]--;
 
			/* Print the prompt */ 

			pn = (rand() & 3);
			sysmess(pn + 2);
			opch32('\n');
            linebuf[0] = '\0';

			if( dbver == 0 ) /* early zx spectrum version */
            {
                sysmess(28); /* draw prompt */
                ozeditline( 10, 70, linebuf, 255, 219 );
            }
            else
                ozeditline( 0, 70, linebuf, 255, 219 );
            printf("\n");
            ypos=0; /* reset counter */
			

    		TURNLO++;
			if (TURNLO == 0)
                TURNHI++;

			/* Parse the input */
	
			lbstart = linebuf;
			verb    = matchword(&lbstart);
			if (verb != 0xFF)
 			{
 				VERB = verb;
				noun = matchword(&lbstart);
				NOUN = noun;
				if (noun == 0xFF) noun = 0xFE;

	/* v0.7.5: Moved "response" conditions to after the attempt to 
	 *         move the player
	 */

    	/* Attempt to move player */
				r = 0;
/*				if (verb < 20)*/   /* A movement word       */
/*				{  * This test is incorrect; Quill does not *
 *				   * insist on the word number being < 20   */
					connbase = zword(2*CURLOC+conntab);
					while ((!r) && (zmem(connbase) != 0xFF)) if (verb == zmem(connbase))
					{
						CURLOC=zmem(++connbase);
						desc = 1; r = 1;
					}
				   	else connbase += 2; 
	    			/* } */
    	 			if (r == 0)
				{
			        /* Process "response" conditions */
                                	r = doproc(zword(zxptr+4),verb,noun); 
                                	if      (r == 2) desc=1;        /* DESC */
                                	else if (r == 3) break;         /* END  */
				}
				/* Print "I can't do that/go that way" */
				if (r == 0)
				{
					if (verb < 20) sysmess(7); 
					else           sysmess(8);
					opch32('\n');
				}	
        		}
        		else sysmess(6); /* Unknown verb */
      		}
	}
}




uchr cplscmp(ushrt first, char *snd)
{
	if (((255-(zmem(first++))) & 0x7F) != (snd[0])) return 0;
	if (((255-(zmem(first++))) & 0x7F) != (snd[1])) return 0;
	if (((255-(zmem(first++))) & 0x7F) != (snd[2])) return 0;
	if (((255-(zmem(first++))) & 0x7F) != (snd[3])) return 0;
	return 1;
}




uchr matchword(char **wordbeg)
{
/* Match a word of player input with the vocabulary table */

	ushrt matchp=vocab;
	char wordbuf[5];
	int i;

	wordbuf[4]=0;
	while(1)
	{
		for (i=0; i<4; i++)
		{
			wordbuf[i]=(**wordbeg);
			if (islower(wordbuf[i])) wordbuf[i] = toupper(wordbuf[i]);	/* (v0.4.1), was munging numbers */
			if (wordbuf[i]==0)    wordbuf[i]=' ';
			if (wordbuf[i]=='\n') wordbuf[i]=' ';
			if (wordbuf[i]=='\r') wordbuf[i]=' ';
			if (wordbuf[i]==' ')  (*wordbeg)--;
			(*wordbeg)++;
		}
		while ((**wordbeg) 
		&&     (**wordbeg!='\n')
		&&     (**wordbeg!='\r')
		&&     (**wordbeg!=' '))
			(*wordbeg)++; 
		while (zmem(matchp))
		{
			if (cplscmp(matchp,wordbuf))
			{
				return zmem(matchp+4);
			}
			matchp+=5;
		}
		matchp=vocab;
		
		if (((**wordbeg)==0)
		||  ((**wordbeg)=='\r')
		||  ((**wordbeg)=='\n'))
		return 0xFF;

		while ((**wordbeg)==0x20)
		{
			if ((**wordbeg)==0) return 0xFF;
			(*wordbeg)++;
		}
	}
	return 0xFF;
		
}


void listat(uchr locno)
{
/* List items at location n */
	
	uchr any = 0, n;

	for (n=0; n<nobj; n++) if (objpos[n] == locno)
        {
		if (any==0)
		{
			any = 1;
			if (locno < 253) 
                  	{
				sysmess(alsosee);
				opch32('\n');
			} 
		}
		oneitem(objtab,n);
		opch32('\n');
	}
}



uchr ffeq(uchr x,uchr y)  /* Match x with y, 0FFh matches any */
{
	return (uchr)((x == 0xFF) || (y == 0xFF) || (x == y));
}




uchr doproc (ushrt table, uchr verb, uchr noun)
{
	ushrt ccond;
	uchr done = 0; /* Done returns: 0 for fell off end of table
                                        1 for DONE
                                        2 for DESC
                                        3 for END (end game) */
	uchr t, tverb, tnoun, td1 = 0;

	while ((zmem(table)) && !done)
    	{
		tverb = zmem(table++);
		tnoun = zmem(table++);
		ccond = zword(table++);
		table++;

		if (ffeq(verb,tverb) && ffeq(noun,tnoun))
		{
			t = condtrue(ccond);
      			/* Skip over condition clauses */
      			while (zmem(ccond++) != 0xFF);	
			if (t) 
			{
        			done = runact(ccond,noun);    
        			/* Returned nonzero if should not scan */
				td1 = 1;  /* Something was run */
			}
		} 
	}
	if ((done==0) && (td1)) done=1;
	return(done);
} 



uchr autobj(uchr noun)  /* Find object number for AUTOx actions */
{
	uchr n;

	if (dbver == 0) return 0xFF;
	if (noun > 253) return 0xFF;
	for (n = 0; n < nobj; n++) if (noun == zmem(objmap + n)) return n;
	return 0xFF;
}


char yesno(void)
{
	char n;
   
	while (1)
	{
		n = ozgetch();
		if ((n == 'Y') || (n == 'y')) return ('Y');
		if ((n == 'N') || (n == 'n')) return ('N');
	}

    ypos=0; /* reset counter */

	return('N');
}



void sysmess(uchr sysno)
{
	uchr  cch = 0;
	ushrt msgadd;

	if (dbver > 0) 
	{	
		oneitem(sysbase,sysno);
		return;
	}
	msgadd = sysbase;
	while (sysno)	/* Skip (sysno) messages */
	{
		while (cch != 0x1F) cch = 0xFF - (zmem(msgadd++));
		sysno--;
		cch = 0xFF - (zmem(msgadd++));
      	}
	msgadd--;
	while (cch != 0x1F)
	{
		cch = 0xFF - (zmem(msgadd++));
		expch (cch,&msgadd);
	}
}




uchr zmem(ushrt addr)
{
/* All Spectrum memory accesses are routed through this procedure. */


	if (addr < mem_base || (arch != ARCH_SPECTRUM && 
	                       (addr >= (mem_base + mem_size))))
	{
		printf ("\nInvalid address %4.4x requested. ", addr);
		if (arch != ARCH_SPECTRUM)
		     printf("Probably not a Quilled game.\n");
		else printf("Try running as %s.\n",
		                ((dbver > 0) ? "older":"newer"));
        ozgetch();
		exit(1);
	}

	/*else if( lseek(infile, addr - mem_offset,SEEK_SET) == -1)*/


    return(getfilebyte (addr-mem_offset));

} /* zmem(); */



ushrt zword(ushrt addr)
{
	return (ushrt)(zmem(addr) + (256 * zmem(addr + 1)));
}



void dec32(ushrt v)
{
	char decbuf[6];
	char i;   /* 8-bit register on 8-bit computer */
	
	sprintf(decbuf,"%d",v);
    /*itoa( v, decbuf );*/

	i=0;
	while (decbuf[i]) opch32(decbuf[i++]);
}



void opch32(char ch)	/* Output a character, assuming 32-column screen */
{
	/*char x;*/

	putchar(ch);
	if( ch == '\n' )
	{
		xpos = 0;
		ypos++;

        /*
        if( indent )
        {
            for (x = 0; x < indent; x++) putchar(' ');
            if (oopt != 'I') putchar(';');
        }
      		else if (!running) printf("      ");
                if (oopt == 'I') putchar('^');*/

		/* do more */
		if( ypos == 7 ) /* 8 rows for wizard */
        {
			ozputs( 200, 0, "more");
			ozgetch();
			ypos=0;
		}
    }
    else if (ch == 8)
        xpos--;
	else if (arch == ARCH_SPECTRUM && xpos == 31)
        opch32('\n');
	/*else if (arch != ARCH_SPECTRUM && xpos == 39)
        opch32('\n');*/
	else
        xpos++;
}
