; TEWK2.SCE - Process tables for TEWK. You must compile TEWK.SCE which
; will link this automatically.
;
; In the following tables, flags are used thus:-
;
; Flag  Description                             When Set        When Reset
; ----  ------------------------------          --------------  ----------
;  11   Airlock repair panel                    Open            Closed
;  12   Number of times Yellow Box refrenced.   -               -
;  13   Airlock Door                            1-Closed 2-Open Broken
;  18   Red Box                                 Open            Closed
;  19   No of objects in the Red Box (max 2)
;  20   AA Box                                  1-Close 2-Open  Locked
;  21   TEWK reports produced                   1-Hello 2-Atmos None
;  22   Suit/Aftershave                         Coated          Unused
;  23   Green Bottle                            Empty           Full
;  24-27 contain the number 20. This allows scoring to take place only
;  the first time the player carries out an action.
;
/PRO    0       ;Response to a players command

;The first entries deal with the fact that TEWK has three boxes. They ensure
;that the player has specified an ADJECTIVE if there would be confusion
;due to one or more of the boxes being present.

_       _       NOUN2   BOX
                ADJECT2 _
                PRESENT 5
                PRESENT 6
                MESSAGE 41
                DONE

_       _       NOUN2   BOX
                AT      5
                PRESENT 5
                ADJECT2 _
                MESSAGE 41
                DONE

_       _       NOUN2   BOX
                AT      5
                PRESENT 6
                ADJECT2 _
                MESSAGE 41
                DONE

_       BOX     ADJECT1 _
                PRESENT 5
                PRESENT 6
                MESSAGE 41
                DONE

_       BOX     ADJECT1 _
                AT      5
                PRESENT 5
                MESSAGE 41
                DONE

_       BOX     ADJECT1 _
                AT      5
                PRESENT 6
                MESSAGE 41
                DONE

;As a bit of a cheat allow any manipulation of the Screwdriver and Panel to
;Fix the airlock!

_       SCREW   NOUN2   PANEL
                AT      3
                NOTZERO 11
                ZERO    13
                MESSAGE 59
                LET     13      1
                DONE

_       PANEL   NOUN2   SCREW
                AT      3
                NOTZERO 11
                ZERO    13
                MESSAGE 59
                LET     13      1
                DONE

_       PANEL   NOTAT   3               ;But of course deal with not being
                MESSAGE 58              ;in the vicinity of the panel
                DONE

;Allow movement out of the airlock only if it is open

E       _       AT      3
                EQ      13      2
                GOTO    4
                DESC

;Allow for end of game by player entering the AA box

ENTER   _       AT      5
                EQ      20      2
                MESSAGE 79
                MESSAGE 82
                END

;Only other need for ENTER/LEAVE processing is in the airlock, and the palyer
;should really use a direction, as there are two doors!

LEAVE   _       AT      3
                MESSAGE 83
                DONE

;The status.inventory command.

ST      _       PROCESS 4
                SYSMESS 9
                LISTAT  254
                SYSMESS 10
                LISTAT  253
                TURNS
                SCORE
                SET     17
                DONE

;Deal with all the possiblities of Opening the various boxes. Working out
;which box the player means if no adjective is provided. I.e. by checking
;to see which one is present, as there will only be one of the three if there
;is no adjective, due to the first entries in this table.

OPEN    BOX     ADJECT1 RED
                PRESENT 6
                ZERO    18
                MESSAGE 42
                SET     18
                ADD     24      30
                CLEAR   24
                DONE

OPEN    BOX     ADJECT1 RED
                PRESENT 6
                WHATO
                MES     46
                MES     33
                MESSAGE 28
                DONE

OPEN    BOX     ADJECT1 AA
                PROCESS 13
                DONE

OPEN    BOX     ADJECT1 YELLO
                PRESENT 5
                WHATO
                MESSAGE 44
                DONE

OPEN    BOX     PRESENT 6
                ZERO    18
                MESSAGE 42
                SET     18
                ADD     24      30
                CLEAR   24
                DONE

OPEN    BOX     PRESENT 6
                WHATO
                MES     46
                MES     33
                MESSAGE 28
                DONE

OPEN    BOX     AT      5
                PROCESS 13
                DONE

OPEN    BOX     PRESENT 5
                WHATO
                MESSAGE 44
                DONE

;Some of these entries deal with the AA Box as well. That is because the
;player may refer to it as the box, or its door!

OPEN    DOOR    AT      2
                MESSAGE 50
                DONE

OPEN    DOOR    AT      3
                ZERO    13
                MESSAGE 50
                DONE

OPEN    DOOR    AT      3
                EQ      13      1
                MESSAGE 52
                LET     13      2
                ADD     27      30
                CLEAR   27
                DONE

OPEN    DOOR    AT      5
                PROCESS 13
                DONE

OPEN    DOOR    MESSAGE 55
                DONE

;Deal with the player trying to open something else.

OPEN    _       WHATO
                LT      51      255
                SAME    38      54
                MESSAGE 45
                DONE

OPEN    _       LT      51      255
                GT      54      252
                MESSAGE 45
                DONE

OPEN    _       PROCESS 10
                DONE

;And a similar set of entries to deal with closing boxes, objects etc.

CLOSE   BOX     NOTEQ   35      54
                PRESENT 6
                NOTZERO 18
                MESSAGE 43
                CLEAR   18
                DONE

CLOSE   BOX     WHATO
                GT      51      4
                LT      51      7
                SAME    54      38
                MES     46
                MES     34
                MESSAGE 28
                DONE

CLOSE   BOX     GT      51      4
                LT      51      7
                GT      54      252
                MES     46
                MES     34
                MESSAGE 28
                DONE

CLOSE   BOX     AT      5
                PROCESS 13
                DONE

CLOSE   DOOR    AT      3
                EQ      13      2
                MESSAGE 50
                DONE

CLOSE   DOOR    AT      5
                PROCESS 13
                DONE

CLOSE   _       WHATO
                LT      51      255
                SAME    38      54
                MESSAGE 48
                DONE

CLOSE   _       LT      51      255
                GT      54      252
                MESSAGE 48
                DONE

CLOSE   _       PROCESS 10
                DONE

;The Green bottle contains aftershave which will upset the bayberries. The
;player has to pour it OVER the suit which he will be wearing.

POUR    BOTTL   ABSENT  3
                SYSMESS 26
                NEWLINE
                DONE

POUR    BOTTL   NOUN2   SUIT
                PRESENT 2
                SET     22
                SET     23
                MES     65
                MESSAGE 67
                ADD     26      30
                CLEAR   26
                DONE

POUR    BOTTL   NOUN2   SUIT
                SYSMESS 26
                NEWLINE
                DONE

POUR    BOTTL   ZERO    23
                MES     65
                MESSAGE 66
                SET     23
                DONE

;Deal with the player typing COMMANDS not SAY "COMMANDS"

COMMA   _       MESSAGE 70
                DONE

;Doors are dealt with in a Sub-process to make this table neat.

LOCK    DOOR    PROCESS 13
                DONE

UNLOC   DOOR    PROCESS 13
                DONE

GET     _       PROCESS 7       ;As are GET
                DONE

PUT     _       PROCESS 7       ;DROP
                DONE

REMOV   _       PROCESS 7       ;REMOVE
                DONE

WEAR    _       PROCESS 7       ;& WEAR
                DONE

;Standard operating commands

QUIT    _       QUIT
                END

SAVE    _       SAVE

LOAD    _       LOAD

RAMSA   _       RAMSAVE
                DESC

RAMLO   _       RAMLOAD 255
                DESC

;Deal with examing objects

LOOK    _       PREP    IN      ;Looking in an object...
                PROCESS 8
                DONE

LOOK    SUIT    PRESENT 2
                MESSAGE 30
                DONE

LOOK    KEY     PRESENT 1
                MESSAGE 29
                DONE

LOOK    BOTTL   PRESENT 3
                WHATO
                ZERO    23
                MESSAGE 63
                DONE

LOOK    BOTTL   PRESENT 3
                MESSAGE 64
                DONE

LOOK    BOX     ADJECT1 RED
                PRESENT 6
                PROCESS 5
                DONE

LOOK    BOX     PRESENT 5
                MESSAGE 31
                DONE

LOOK    BOX     PRESENT 6
                PROCESS 5
                DONE

LOOK    MANUA   PRESENT 0
                CLS
                MESSAGE 69
                ANYKEY
                DESC

LOOK    SCREW   PRESENT 4
                MESSAGE 35
                DONE

LOOK    PANEL   AT      3
                NOTZERO 11
                MESSAGE 57
                DONE

LOOK    PANEL   MESSAGE 58
                DONE

LOOK    SCREE   AT      1
                CLS
                MESSAGE 68
                ANYKEY
                DESC

;Now some general catch all entries for examing objects we haven't dealt
;with!

LOOK    _       WHATO
                LT      51      255
                GT      54      252
                MESSAGE 39
                DONE

LOOK    _       LT      51      255
                SAME    38      54
                MESSAGE 39
                DONE

LOOK    _       LT      51      255
                SYSMESS 26
                NEWLINE
                DONE

LOOK    _       LT      34      255
                NOTDONE

LOOK    _       DESC

;Speech is only to TEWK.

SAY     TEWK    PROCESS 3
                DONE

SAY     _       ATLT    4       ;SAY without a name only works in the ship.
                PROCESS 3
                DONE

SAY     _       MESSAGE 19
                DONE

;The yellow box is a 'red herring', but if they try to do too much with it
;we cause it to explode just for fun!

_       BOX     ADJECT1 YELLO
                EQ      12      2
                MESSAGE 85
                END

_       BOX     ADJECT1 YELLO
                PLUS    12      1
                NOTDONE


/PRO    1       ;Deal with start of game and extra for location descriptions

_       _       AT      0               ;Start of game
                TIME    20      1
                LET     53      64
                LET     19      2
                LET     24      20
                LET     25      20
                LET     26      20
                LET     27      20
                PROMPT  2
                ANYKEY
                GOTO    1
                DESC

_       _       AT      4               ;Bayberries
                ZERO    22
                MESSAGE 62
                END

_       _       AT      4
                MES     61

_       _       AT      5               ;AA Box
                MES     81
                EQ      20      2
                MES     33

_       _       AT      5
                LT      20      2
                MES     34

_       _       AT      3               ;Airlock
                LT      13      2
                MES     34

_       _       AT      3
                EQ      13      2
                MES     33

_       _       AT      3               ;Airlock repair panel
                NOTZERO 11
                MES     56

_       _       LISTOBJ
                MESSAGE 28
                CLEAR   17


/PRO    2

_       _       EQ      13      2       ;Spacesuit must be worn if airlock open
                NOTWORN 2               ;or you die
                MESSAGE 60
                END

_       _       ATLT    4               ;Tewk speaks to you!
                ZERO    21
                CHANCE  50
                MESSAGE 3
                LET     21      1

_       _       ATLT    4
                EQ      21      1
                CHANCE  50
                MESSAGE 5
                LET     21      2


/PRO    3       ;Deal with any speech to TEWK

_       _       ATGT    3               ;Have to be in the ship
                MESSAGE 0
                DONE

_       _       PARSE
                MESSAGE 1               ;Junk in the string or none there
                DONE

OPEN    _       LET     34      56

OPEN    DOOR    AT      3
                NOTWORN 2
                LT      13      2
                MESSAGE 51
                DONE

OPEN    DOOR    AT      2
                MESSAGE 51
                DONE

OPEN    DOOR    AT      3
                ZERO    13
                MESSAGE 4
                SET     11
                DONE

OPEN    DOOR    AT      3
                EQ      13      1
                MESSAGE 52
                LET     13      2
                ADD     27      30
                CLEAR   27
                DONE

COMMA   _       MESSAGE 75              ;A list of commands
                DONE

_       BAYBE   MESSAGE 73              ;Information on various things
                DONE

_       PLATT   MESSAGE 74
                DONE

_       NIMRO   MESSAGE 71
                DONE

INFOR   _       MESSAGE 72              ;List of available information
                DONE

_       _       MESSAGE 2
                DONE

/PRO    4       ;Used on Spectrum for a graphic inventory

/PRO    5       ;LOOK IN/AT the BOXES

LOOK    BOX     PREP    IN
                NOTZERO 18
                MES     37
                LISTAT  6
                WHATO
                MESSAGE 38
                DONE

LOOK    BOX     PREP    IN
                WHATO
                MESSAGE 36
                DONE

LOOK    BOX     MES     32
                ZERO    18
                MES     34

LOOK    BOX     NOTZERO 18
                MES     33

LOOK    BOX     MESSAGE 28


/PRO    6       ;GET/DROP but all text is in a paragraph. NEWLINE on exit

_       _       PREP    IN              ;Filter off inside objects
                PROCESS 9
                DONE

_       _       PREP    OUT
                PROCESS 9
                DONE

GET     ALL     DOALL   255

GET     _       AUTOG
                DONE

PUT     ALL     DOALL   254

PUT     _       AUTOD
                DONE

REMOV   ALL     DOALL   253

REMOV   _       AUTOR
                DONE

WEAR    ALL     DOALL   254

WEAR    SUIT    PRESENT 2
                ADD     25      30
                CLEAR   25

WEAR    BOTTL   PRESENT 3
                OK

WEAR    _       AUTOW
                DONE


/PRO    7       ;This is called to ensure a NEWLINE printed after PRO 6 use

_       _       PROCESS 6
                NEWLINE


/PRO    8       ;Look in objects

LOOK    BOX     ADJECT1 RED
                PRESENT 6
                PROCESS 5
                DONE

LOOK    BOX     PRESENT 5
                WHATO
                MESSAGE 36
                DONE

LOOK    BOX     PRESENT 6
                PROCESS 5
                DONE

LOOK    _       WHATO
                LT      51      255
                SAME    38      54
                MESSAGE 40
                DONE

LOOK    _       PROCESS 10


/PRO    9       ;Works out which object you are trying to TAKEOUT/PUTIN from/to

_       _       NOTEQ   44      53      ;ONLY BOXS!
                SYSMESS 8
                DONE

;Again we need several entries in case no adjective specified

GET     _       ADJECT2 RED
                PROCESS 11
                DONE

GET     _       ADJECT2 YELLO
                MES     47
                DONE

GET     _       PRESENT 6
                PROCESS 11
                DONE

GET     _       PRESENT 5
                MES     47
                DONE

PUT     _       ADJECT2 RED
                PRESENT 6
                PROCESS 11
                DONE

PUT     _       ADJECT2 YELLO
                PRESENT 5
                MES     47
                DONE

PUT     _       PRESENT 6
                PROCESS 11
                DONE

PUT     _       PRESENT 5
                MES     47
                DONE

_       _       SYSMESS 26              ;Catch all other cases


/PRO    10      ;Ensure that object reporting is done correctly as in PAW.

_       _       LT      51      255     ;If it was an object
                SYSMESS 26              ;it wasn't here
                NEWLINE
                DONE

_       _       LT      34      255     ;If it wasn't, but was a valid word
                SYSMESS 8               ;you can't do it
                DONE

_       _       SYSMESS 26              ;If not an object or a word assume
                NEWLINE                 ;it was an object that wasn't here!


/PRO    11      ;TAKOUT/PUTIN for the RED BOX specifically

GET     _       ZERO    18              ;Nothing in there
                MES     47
                DONE

GET     _       AUTOT   6               ;Get anything out, no restrictions
                MINUS   19      1       ;One less object in there
                DONE                    ;Not really needed but makes it clearer

PUT     _       GT      19      1       ;Box is full!
                WHATO
                LT      51      255     ;It was a valid object
                SAME    38      54      ;that was here
                MES     49              ;Won't fit!
                DONE

PUT     _       GT      19      1       ;Same again
                LT      51      255
                EQ      54      254     ;But for carried objects
                MES     49
                DONE

PUT     _       GT      19      1       ;All others use default reporting
                PROCESS 10
                DONE

PUT     _       ZERO    18              ;Is it open?
                MES     47
                DONE

PUT     SUIT    WHATO                   ;Suit isn't going to fit
                PRESENT 2
                MES     49
                DONE

PUT     BOX     ADJECT1 YELLO           ;and neither will the yellow box!
                PRESENT 5
                WHATO
                MES     49
                DONE

PUT     _       AUTOP   6               ;Otherwise put it in
                PLUS    19      1       ;and one more object


/PRO    12      ;Unused in CPM version

/PRO    13      ;OPEN and CLOSE

_       _       NOTAT   5
                SYSMESS 26
                NEWLINE
                DONE

_       BOX     LET     34      56

OPEN    DOOR    ZERO    20
                MESSAGE 53
                DONE

OPEN    DOOR    EQ      20      1
                MESSAGE 52
                LET     20      2
                DONE

OPEN    _       MES     76
                MES     33
                MESSAGE 28
                DONE

CLOSE   DOOR    EQ      20      2
                MESSAGE 54
                LET     20      1
                DONE

CLOSE   _       MES     76
                MES     34
                MESSAGE 28
                DONE

LOCK    DOOR    CARRIED 1
                EQ      20      2
                MESSAGE 54
                LET     20      1

LOCK    DOOR    CARRIED 1
                EQ      20      1
                CLEAR   20
                MESSAGE 80
                DONE

LOCK    DOOR    NOTCARR 1
                MES     86
                MES     88
                MESSAGE 87
                DONE

LOCK    DOOR    MES     76
                MES     77
                MESSAGE 28
                DONE

UNLOC   DOOR    CARRIED 1
                ZERO    20
                LET     20      1
                MESSAGE 59
                DONE

UNLOC   DOOR    NOTCARR 1
                MES     86
                MES     89
                MESSAGE 87
                DONE

UNLOC   DOOR    MES     76
                MES     78
                MESSAGE 28
                DONE

