/* Nmesis, el creador de aventuras multi-plataforma
  Autor: Javier Basilio Prez Ramas */

/* PARSER DE NMESIS */

/* Declaraciones */

%{
#define NEMESISVER "1.0 Alpha 2"
#define MAXCAD 5000
#include <stdio.h>
#include "tabla.c"
FILE *fc;
FILE *fh;
FILE *fp;
FILE *fgc;
FILE *fgh;
FILE *fsave;
FILE *fload;

/* flags para indicar funciones estndar sobrepuestas */
short defecto; /* indica si se defini una funcion defecto */
short cardinal; /* indica si el usuario creo sus propias funciones de puntos cardinales */
short inicio; /* indica si se creo la funcin de inicializacin */
short describir; /* idem con la fun. de describir */
short coger; /* idem con la fun. de coger */
short inventario; /* fun. inventario */
short dejar;
short central;

%}

%union
	{
	char cadena[MAXCAD];
	int entero;
	enum ttipo tipo;
	}

%token <entero> TENTERO
%token <cadena> TID	
%token <cadena> TCADENA
%token <cadena> AKA

%token ENTERO
%token CADENA

%token TCIERTO
%token TFALSO


%token TY
%token TO
%token TVERBO
%token TGLOBAL
%token TIMPRIME
%token TSI
%token TFINSI
%token TSINO
%token TMIENTRAS
%token TFMIENTRAS
%token TNO
%token TUSA
%token TRET
%token TQUITAR;


/* tokens de funciones primitivas */
%token TLEESAL
%token TLEEENTERO
%token TLEECADENA
%token TLEEDESC

%token TOBJNUM
%token TOBJTIENE
%token TOBJESTA
%token TOBJLIMBO
%token TLLENO
%token TOBJAJUG
%token TOBJALOC
%token TOBJALIMBO
%token TOBJCOGIBLE
%token TLEEOBJFLAG TPONOBJFLAG

%token TCADENACONTENIDA

%token TOBJDESC TSETOBJDESC



/* token de procedimientos primitivos */

%token TSETSAL
%token TSETDESC

%type <tipo> TIPO E R T F

%start S



%%

S : {
      fprintf(fc,"/* Cdigo generado por NMESIS %s */\n\n#include%cpilas.h%c\n",NEMESISVER,'"','"');
      fprintf(fc,"/* (C) 2000 Javier Basilio Prez Ramas */\n\n");
      fprintf(fc,"#include <string.h>\n");
      fprintf(fc,"#include %cnemio.h%c\n",'"','"');
      fprintf(fc,"#include %cglobal.h%c\n",'"','"');
      fprintf(fc,"#include %clocdef.h%c\n",'"','"');
      fprintf(fc,"#include %cobjdef.h%c\n",'"','"');
      fprintf(fc,"#include %cusrgl.h%c\n",'"','"');
      fprintf(fc,"#include %clakas.h%c\n",'"','"');
      fprintf(fc,"#include %coakas.h%c\n",'"','"');

      fprintf(fh,"#include %cusrgl.h%c /* incluye las variables globales del usuario */\n",'"','"');

      fprintf(fgh,"/* VARIABLES LOCALES DEFINIDAS POR EL USUARIO */\n");
      fprintf(fgc,"/* VARIABLES LOCALES DEFINIDAS POR EL USUARIO */\n");


      fprintf(fp,"/* RUTINA GESTORA DEL VERBO - ELIGE EL VERBO ADECUADO */\n");
      fprintf(fp,"\n#include %cverbos.h%c\n",'"','"');
      fprintf(fp,"\n#include <string.h>\n",'"','"');
      fprintf(fp,"void accion(char *verbo,char *nombre)\n{\n");

      fprintf(fsave,"/* Funcin para guardar las variables globales */");
      fprintf(fsave,"\n#include %cusrgl.h%c\n#include <stdio.h>\n",'"','"');
      fprintf(fsave,"\nvoid saveglb(FILE *fo)\n{\n");

      fprintf(fload,"/* Funcin para recuperar las variables globales */");
      fprintf(fload,"\n#include %cusrgl.h%c\n#include <stdio.h>\n",'"','"');
      fprintf(fload,"\nvoid loadglb(FILE *fo)\n{\n");

    } PROGRAMA
    {


    /* Crea las funciones por defecto que no hayan sido definidas */


    if (cardinal==0)
    {
     puts("Inf: incorporando funciones estndar para el movimiento cardinal\n");
     movfun("norte");
     movfun("sur");
     movfun("este");
     movfun("oeste");
    }

    if (coger==0)
    {
    	puts("Inf: incorporando funcin coger estndar.\n");
	fprintf(fh,"/* RUTINA PARA GESTIONAR EL VERBO %s */\n\nint %s(char *nombre);\n","coger","coger");
	fprintf(fp,"if (strcmp(verbo,%c%s%c)==0) { %s(nombre); return; }\n",'"',"coger",'"',"coger");
	fprintf(fc,"int coger(char *nombre) /* Estndar */\n");
	fprintf(fc,"{\nstruct objeto *p;\nint num=objnum(nombre);\nif (num==0) {nemputs(%cNo puedes cogerlo.%c);return;}\n",'"','"');
	fprintf(fc,"p=ptrobj(num);\nif(p->estado!=localidad || p->loc!=gloc) {nemputs(%cNo est por aqu.%c);\nreturn;}\n",'"','"');
	fprintf(fc,"if ( !objcogible(num)) {nemputs(%cNo se puede coger.%c); return;}\n",'"','"');
	fprintf(fc,"if (objpami(num)==0) nemputs(%cYa no puedes llevar ms cosas.%c); else nemputs(%cLo recoges.%c);\n",'"','"','"','"');
	fprintf(fc,"\n}\n");
   }

   if (dejar==0)
    {
    	puts("Inf: incorporando funcin dejar estndar.\n");
	fprintf(fh,"/* RUTINA PARA GESTIONAR EL VERBO %s */\n\nint %s(char *nombre);\n","dejar","dejar");
	fprintf(fp,"if (strcmp(verbo,%c%s%c)==0) { %s(nombre); return; }\n",'"',"dejar",'"',"dejar");
	fprintf(fc,"int dejar(char *nombre) /* Estndar */\n");
	fprintf(fc,"{\nstruct objeto *p;\nint num=objnum(nombre);\nif (num==0) {nemputs(%cCreo que ms bien no lo llevas encima.%c);return;}\n",'"','"');
	fprintf(fc,"p=ptrobj(num);\nif(p->estado!=jugador) {nemputs(%cNo lo tienes.%c);\nreturn;}\n",'"','"');
	fprintf(fc,"objpaloc(num,gloc); nemputs(%cLo dejas.%c);\n",'"','"');
	fprintf(fc,"\n}\n");
   }


    if (inventario==0)
    {
    	puts("Inf: incorporando funcin inventario estndar.\n");
	fprintf(fh,"/* RUTINA PARA GESTIONAR EL VERBO %s */\n\nint %s(char *nombre);\n","inventario","inventario");
	fprintf(fp,"if (strcmp(verbo,%c%s%c)==0) { %s(nombre); return; }\n",'"',"inventario",'"',"inventario");
	fprintf(fc,"int inventario(char *nombre) /* Estndar */\n{\n");
	fprintf(fc,"int i;\nchar *l[5000];\nshort fst=1;\nl[0]=0;\n");
	fprintf(fc,"for (i=1;i<=MAXOBJ;i++) if (ptrobj(i)->estado==jugador)\n");
	fprintf(fc,"	{if (fst) fst=0; else strcat(l,%c,%c); strcat(l,ptrobj(i)->descrip);}\n",'"','"');
	fprintf(fc,"if (l[0]!=0) {nemputs(%cLlevas contigo:%c); nemputs(l);} else nemputs(%cNo llevas nada.%c);\n",'"','"','"','"');
	fprintf(fc,"\n}\n");
   }


    if (describir==0)
    {
     puts("Inf: incorporando funcin estndar para descripcin de localidades\n");
     fprintf(fc,"int describir(char *nombre) /* describir estndar */\n");
     fprintf(fc,"{\nstruct local *pt=ptrloc(gloc);\nint i;\nshort ok=0;\nchar l[5000];\nshort fst=1;\n");
     fprintf(fc,"nemputs(pt->descrip);\n");
     fprintf(fc,"strcpy(l,%cTambin ves:%c);\n",'"','"');
     fprintf(fc,"for (i=1;i<=MAXOBJ;i++)\n");
     fprintf(fc,"	if (objgetloc(i)==gloc) {ok=1;\nif (fst) fst=0; else strcat(l,%c,%c); strcat(l,ptrobj(i)->descrip);}\n",'"','"');
     fprintf(fc,"if (ok) nemputs(l);\n");
     fprintf(fc,"}\n");
     fprintf(fh,"int describir(char *nombre);/* funcin estndar de NMESIS */\n");

    }
    if (central==0)
    {
     puts("Inf: incorporando funcin central estndar (vacia) \n");
     fprintf(fc,"int central(char *nombre) /* central estndar */\n");
     fprintf(fc,"{}\n");
     fprintf(fh,"int central(char *nombre);/* funcin estndar de NMESIS */\n");

    }


    if (defecto==0)
     {
     puts("Inf: incorporando funcin defecto estndar\n");
     fprintf(fc,"int defecto(char *nombre) /* defecto estndar */\n{\nprintf(%cNo te entiendo\\n%c);\n}\n",'"','"');
     fprintf(fh,"int defecto(char *nombre);/* funcin estndar de NMESIS */\n");
     }
    if (inicio==0)
     {
     puts("Inf: incorporando funcin de inicio estndar\n");
     fprintf(fh,"int inicio(char *nombre); /* funcin estndar de NMESIS */\n");
     fprintf(fc,"int inicio(char *nombre)\n{\nprintf(%cPrograma creado por NMESIS - (C) Javier Basilio Prez Ramas\n%c);\n}\n",'"','"');
     }

    fprintf(fp,"\ndefecto(nombre); /* accin desconocida */\n}\n");

    fprintf(fload,"}");
    fprintf(fsave,"}");
    };

PROGRAMA : V PROGRAMA ;
	| ;
V :  { tablalimpia(); /* limpia la tabla de smbolos global */
       nueva("nombre",cadena,0); /* aade nombre a la tabla de smbolos local */
     }
     VERBO ';' CUERPO { fprintf(fc,"\n\n}\n\n");
                   /*fprintf(fc,"/* RESUMEN DE TABLA DE SMBOLOS:\n");
                       vertabla(); */ };
     | TGLOBAL TIPO TID ';'
     	{
     	switch ($2)
     		{
     		case entero:
     			fprintf(fgc,"int %s;\n",$3);
     			fprintf(fgh,"extern int %s;\n",$3);
     			fprintf(fsave,"fwrite(&%s,sizeof(int),1,fo);\n",$3);
     			fprintf(fload,"fread(&%s,sizeof(int),1,fo);\n",$3);
     			break;
     		case cadena:
     			fprintf(fgc,"char %s[%d];\n",$3,MAXCAD);
     			fprintf(fgh,"extern char %s[%d];\n",$3,MAXCAD);
     			fprintf(fsave,"fwrite(%s,%d,1,fo);\n",$3,MAXCAD);
     			fprintf(fload,"fread(%s,%d,1,fo);\n",$3,MAXCAD);
     			break;
     		default:
     			puts("FATAL EN V");
     			exit(1);
     		}
     	};
     		
VERBO : TVERBO TID
	{
	
	/* mira los overrides de funciones estndar */
	if (strcmp($2,"defecto")==0) {
	   if (defecto==1)
	    {
	    printf("!: La funcin defecto est definida ms de una vez\n");
	    return 1;
	    }
	   defecto=1;
	   printf("Inf: No se usa la funcin defecto estndar\n");
	   }
	
	if (strcmp($2,"inicio")==0) {
	   if (inicio==1)
	    {
	    printf("!: La funcin inicio est definida ms de una vez\n");
	    return 1;
	    }
	   inicio=1;
	   printf("Inf: No se usa la funcin inicio estndar\n");
	   }
	if (strcmp($2,"coger")==0) {
	   if (coger==1)
	    {
	    printf("!: La funcin coger est definida ms de una vez\n");
	    return 1;
	    }
	   coger=1;
	   printf("Inf: No se usa la funcin coger estndar\n");
	   }
	if (strcmp($2,"inventario")==0) {
	   if (inventario==1)
	    {
	    printf("!: La funcin inventario est definida ms de una vez\n");
	    return 1;
	    }
	   inicio=1;
	   printf("Inf: No se usa la funcin inventario estndar\n");
	   }
		if (strcmp($2,"inventario")==0) {
   	if (dejar==1)
	    {
	    printf("!: La funcin dejar est definida ms de una vez\n");
	    return 1;
	    }
	   dejar=1;
	   printf("Inf: No se usa la funcin dejar estndar\n");
	   }



	
	if (strcmp($2,"describir")==0) {
	   if (describir==1)
	    {
	    printf("!: La funcin describir est definida ms de una vez\n");
	    return 1;
	    }
	   describir=1;
	   printf("Inf: No se usa la funcin describir estndar\n");
	   }

	if (strcmp($2,"central")==0) {
	   if (central==1)
	    {
	    printf("!: La funcin central est definida ms de una vez\n");
	    return 1;
	    }
	   central=1;
	   printf("Inf: No se usa la funcin central estndar\n");
	   }
	
	if (strcmp($2,"norte")==0 && cardinal==0)
	 	{
	 	printf("Inf: ignorando funciones de movimiento cardinal estndar\n");
	 	cardinal=1;
	 	}

	if (strcmp($2,"sur")==0 && cardinal==0)
	 	{
	 	printf("Inf: ignorando funciones de movimiento cardinal estndar\n");
	 	cardinal=1;
	 	}
	if (strcmp($2,"este")==0 && cardinal==0)
	 	{
	 	printf("Inf: ignorando funciones de movimiento cardinal estndar\n");
	 	cardinal=1;
	 	}
	 	
	if (strcmp($2,"oeste")==0 && cardinal==0)
	 	{
	 	printf("Inf: ignorando funciones de movimiento cardinal estndar\n");
	 	cardinal=1;
	 	}


	 	
	
	fprintf(fc,"/* RUTINA PARA GESTIONAR EL VERBO %s */\n\nint %s(char *nombre)\n{\n",$2,$2);
	fprintf(fc,"int auxi; char auxc[%d]; /* auxiliares de Nmesis */\n\n",MAXCAD);
	fprintf(fc,"struct local* auxlp; /* para acceder a localidades */\n\n",MAXCAD);
	fprintf(fc,"struct objeto* auxop; /* para acceder a objetos */\n\n",MAXCAD);	
	fprintf(fh,"/* RUTINA PARA GESTIONAR EL VERBO %s */\n\nint %s(char *nombre);\n",$2,$2);
	fprintf(fp,"if (strcmp(verbo,%c%s%c)==0) { %s(nombre); return; }\n",'"',$2,'"',$2);
	};
	
CUERPO : DECLARACIONES LI;

DECLARACIONES : D ';' DECLARACIONES ;
	| ;

D : TGLOBAL TIPO TID { nueva($3,$2,0); fprintf(fc,"/* Se usa el flag global %s */\n",$3); }
    | TIPO TID {
    		switch ($1)
    			{
    			case entero:
    				fprintf(fc,"int %s; /* variable local del verbo */\n",$2);
    				break;
    			case cadena:
    				fprintf(fc,"char %s[%d]; /*variable local*/\n",$2,MAXCAD);
    				break;
    			default:
    				printf("ERROR INTERNO EN D\n"); return(1);
    			}
    		if (esta($2))
    		  {
    		  printf("IDENTIFICADOR YA DECLARADO %s\n",$2);
    		  return(1);
    		  }
    		nueva($2,$1,0);
    		} ;
    		
TIPO : ENTERO { $$=entero; }
     | CADENA { $$=cadena; };


LI : I ';' LI ;
LI : ;


I : TQUITAR
	{
	fprintf(fc,"exit(0); /* quitar */ \n");
	}
	
I : TOBJAJUG "(" E ")"
	{
	if ($3!=entero)
		{
		puts("!: obj_a_jug espera un valor entero");
		return 1;
		}
	fprintf(fc,"objpami(intp_cimapop()); /* obj_a_jug() */\n");
	}
	
I : TOBJALOC "(" E "," E ")"
	{
	if ($3!=entero || $5!=entero)
		{
		puts("!: obj_a_loc espera valores enteros");
		return 1;
		}
	fprintf(fc,"{\nint nloc=intp_cimapop();\nint nobj=intp_cimapop();\nobjpaloc(nobj,nloc);\n}/* obj_a_loc */\n");
	}


I : TOBJALIMBO "(" E ")"
	{
	if ($3!=entero)
		{
		puts("!: obj_a_limbo espera un valor entero");
		return 1;
		}
	fprintf(fc,"objpalimbo(intp_cimapop()); /* obj_a_limbo() */\n");
	}
	
I : TPONOBJFLAG "(" E "," E "," E ")"
	{
	if ($3!=entero || $5!=entero || $7!=entero)
		{
		puts("!: pon_obj_flag() espera tres nmeros.");
		return 1;
		}
	fprintf(fc,"{int nvalor=intp_cimapop(); int nflag=intp_cimapop();\nint nobj=intp_cimapop();\n(ptrobj(nobj)->flag[nflag])=nvalor;\n}/* obj_esta() */\n");
	};
	



I : TRET
	{
	fprintf(fc,"return;\n");
	};
	
I : TUSA TID /* llamada a subrutina */
	{
	fprintf(fc,"%s(nombre); /* llamada a subrutina */\n",$2);
	};
	
/* ponsal(dir,nuevasalida,loc) */

I : TSETSAL '(' TID ',' E ,',', E ')' /* modifica la salida de una loc */
 {
 if ($5!=entero || $7!=entero)
 	{
 	puts("ERROR: La localidad y la salida de pon_sal deben ser valores enteros.");
 	return 1;
 	}
 fprintf(fc,"auxlp=ptrloc(intp_cimapop());\n",$5);
 fprintf(fc,"(auxlp->%s)=intp_cimapop(); /* pon_salida */\n",$3);
 }

/* pondesc (nuevadesc,loc) */

I : TSETDESC '(' E ',' E ')' /* modifica la descripcin de una loc */
 {
 if ($3!=cadena || $5!=entero)
 	{
 	puts("ERROR: Llamada invlida a pon_desc.");
 	return 1;
 	}
 fprintf(fc,"auxlp=ptrloc(intp_cimapop());\n");
 fprintf(fc,"strcpy((auxlp->descrip),strp_cima());\nstrp_pop(); /* pon_desc */\n");
 }

I : TSETOBJDESC '(' E ',' E ')' /* modifica la descripcin de un objeto */
 {
 if ($3!=cadena || $5!=entero)
 	{
 	puts("ERROR: Llamada invlida a obj_desc.");
 	return 1;
 	}
 fprintf(fc,"auxop=ptrobj(intp_cimapop());\n");
 fprintf(fc,"strcpy((auxop->descrip),strp_cima());\nstrp_pop(); /* pon_obj_desc */\n");
 }
  	

I : TMIENTRAS MM1 E MM2 LI TFMIENTRAS {fprintf(fc,"\n} /* fin del bucle mientras*/\n");};
	
MM1 : 	{
	fprintf(fc,"while (1) /* bucle mientras, roto con BREAK */\n{\n");
	};
MM2 : {
      if ($<tipo>0!=entero)
      	{
      	printf("ERROR: Condicin de bucle mientras debera ser entera\n");
      	return(1);
      	}
      fprintf(fc,"if (!(intp_cimapop())) break; /* rotura del bucle mientras */\n");
      };

I : TIMPRIME E
	{
	switch ($2)
	{
	case entero:
		fprintf(fc,"sprintf(auxc,%c%cd\\n%c,intp_cima()); /* Imprime valor entero */\nintp_pop();\nnemputs(auxc);\n",'"','%','"');
		break;
	case cadena:
		fprintf(fc,"nemputs(strp_cima()); /* Imprime tira de caracteres */\nstrp_pop();\n",'"','%','"');
		break;
	default:
		puts("TIPO DESCONOCIDO EN IMPRIME");
		exit(2);
	}
	};


	
I :  TSI E IM1 LI TFINSI { fprintf(fc,"} /* fin del if */\n\n");}
   | TSI E IM1 LI TSINO { fprintf(fc,"} else {\n");};
	      LI TFINSI { fprintf(fc,"} /* fin del IF con ELSE */\n\n"); };
	
I : TID '=' E
	{
		{
		int aux=leetipo($1);
		switch (aux)
		{
		case entero:
			if ($3==entero)
				{
				fprintf(fc,"%s=intp_cimapop(); /*asignacin entero-entero*/\n",$1);
				break;
				}
			 printf("ASIGNACIN INCOMPATIBLE A UN ENTERO\n");
			 return(1);
		case cadena:
			if ($3=entero)
				{
				fprintf(fc,"strcpy(%s,intp_itoa());\nintp_pop();\n",$1);
				break;
				}
			else
			 if ($3=cadena)
			 	{
			 	fprintf(fc,"strcpy(%s,strp_cima());\nstrp_pop();\n",$1);
			 	break;
			 	}
			 printf("ASIGNACIN INCOMPATIBLE A UNA CADENA\n");
			 return (1);
		default:
			puts("JORRRRR en ID = E");
			exit(2);
			
		}
		}
	};
				
	
IM1 :   {
	if ($<tipo>0!=entero)
		{
		printf("la condicin de un IF debe ser un valor entero\n");
		return 1;
		}
	fprintf(fc,"if (intp_cimapop()) {\n");
	}

E : E TY R
	{
	$$=entero;
	if ($1!=entero || $3!=entero)
		{
		printf("ERROR: La operacin lgica debe ser con enteros\n");
		return 1;
		}
	fprintf (fc,"intp_and();\n");
	}
   | E TO R
	{
	$$=entero;
	if ($1!=entero || $3!=entero)
		{
		printf("ERROR: La operacin lgica debe ser con enteros\n");
		return 1;
		}
	fprintf (fc,"intp_or();\n");
	}
    | R ;

R : R '+' T {
	   $$=gestipos($1,$3,'+');
	   switch ($$)
	   	{
	   	case entero:
	   		fprintf (fc,"intp_suma(); /* suma los valores en la cima de la pila de enteros*/ \n");
	   		break;
	   	case cadena:
	   		fprintf (fc,"strp_suma(); /* concatena las cadenas en la cima de la pila de cadenas */\n");
	   		break;
	   	default:
	   		puts("TIPO DESCONOCIDO");
	   		exit(2);
		}
	   };
R : R '-' T {
	   $$=gestipos($1,$3,'-');
	   switch ($$)
	   	{
	   	case entero:
	   		fprintf (fc,"intp_resta(); /* suma los valores en la cima de la pila de enteros*/ \n");
	   		break;
	   	default:
	   		puts("TIPO DESCONOCIDO");
	   		exit(2);
		}
	   };

    | R '=' T
    	{
	    	{
	    	int aux=gestipos($1,$3,'='); /*tipo usado para comparar */
	    	$$=entero; /* en Nmesis los valores lgicos son tipos enteros */
	    	switch (aux)
	    		{
	    		case entero:
	    			fprintf(fc,"intp_push(intp_igual());\n");
	    			break;
	    		case cadena:
	    			fprintf(fc,"intp_push(strp_igual());\n");
	    			break;
	    		default:
	    			puts("ERROR GORDO EN E=T");
	    			exit(2);
	    		}
	    	}
	    };

    | R '<' '>' T
    	{
	    	{
	    	int aux=gestipos($1,$4,'='); /*tipo usado para comparar */
	    	$$=entero; /* en Nmesis los valores lgicos son tipos enteros */
	    	switch (aux)
	    		{
	    		case entero:
	    			fprintf(fc,"intp_push(intp_igual());\nintp_not();\n");
	    			break;
	    		case cadena:
	    			fprintf(fc,"intp_push(strp_igual());\nintp_not();\n");
	    			break;
	    		default:
	    			puts("ERROR GORDO EN E=T");
	    			exit(2);
	    		}
	    	}
	    };
	    			


    | R '<' T
    	{
	    	{
	    	int aux=gestipos($1,$3,'='); /*tipo usado para comparar */
	    	$$=entero; /* en Nmesis los valores lgicos son tipos enteros */
	    	switch (aux)
	    		{
	    		case entero:
	    			fprintf(fc,"intp_push(intp_menor());\n");
	    			break;
	    		case cadena:
	    			fprintf(fc,"intp_push(strp_menor());\n");
	    			break;
	    		default:
	    			puts("ERROR GORDO EN E=T");
	    			exit(2);
	    		}
	    	}
	    };
    | R '>' T
    	{
	    	{
	    	int aux=gestipos($1,$3,'='); /*tipo usado para comparar */
	    	$$=entero; /* en Nmesis los valores lgicos son tipos enteros */
	    	switch (aux)
	    		{
	    		case entero:
	    			fprintf(fc,"intp_push(intp_mayor());\n");
	    			break;
	    		case cadena:
	    			fprintf(fc,"intp_push(strp_mayor());\n");
	    			break;
	    		default:
	    			puts("ERROR GORDO EN E=T");
	    			exit(2);
	    		}
	    	}
	    };

	
    | T { $$=$1;};	
	   		
T : F '*' T {
	   $$=gestipos($1,$3,'*');
	   switch ($$)
	   	{
	   	case entero:
	   		fprintf (fc,"intp_mult(); /* multiplica los valores en la cima de la pila de enteros*/ \n");
	   		break;
	   	default:
	   		puts("F*T TIPO DESCONOCIDO");
	   		exit(2);
		}
	   }
	
T : F '/' T {
	   $$=gestipos($1,$3,'/');
	   switch ($$)
	   	{
	   	case entero:
	   		fprintf (fc,"intp_div(); /* multiplica los valores en la cima de la pila de enteros*/ \n");
	   		break;
	   	default:
	   		puts("F*T TIPO DESCONOCIDO");
	   		exit(2);
		}
	   }

     | F {$$=$1;};

F : TENTERO {$$=entero;
	     fprintf(fc,"intp_push(%d); /* apila valor inmediato en la pila de enteros */\n",$1);
	    };
F : TCADENA {$$=cadena;
 		fprintf(fc,"strp_push(%c%s%c); /* apila cadena de caracteres */\n",'"',$1,'"');
 		};
F : TID { if (!esta($1))
		{
		printf("%s es un identificador desconocido\n",$1);
		exit(1);
		}
	  switch (leetipo($1))
	  {
	  	case entero:
	  		fprintf(fc,"intp_push(%s); /* apilar valor de variable */\n",$1);
		  	$$=entero;
		  	break;
		case cadena:
			fprintf(fc,"strp_push(%s); /* apilar valor de variable */\n",$1);
			$$=cadena;
			break;
		default:
			puts("Tipo desconocido, F");
			exit(2);
	   }
	   };
	
F : TCIERTO {$$=entero; fprintf(fc,"intp_push(1);  /* cierto */\n"); };
F : TFALSO  {$$=entero; fprintf(fc,"intp_push(0);  /* falso */\n"); };
F : TLEEENTERO '(' ')'
	{
	$$=entero;
	fprintf(fc,"nemgets(auxc);\n");
	fprintf(fc,"sscanf(auxc,%c%cd%c,&auxi); /* lee_entero */\n",'"','%','"');
	fprintf(fc,"intp_push(auxi);");
	};
	
F : TLEECADENA '(' ')'{
	$$=cadena;
	fprintf(fc,"nemgets(auxc); /* lee_cadena */\nstrp_push(auxc);\n");
	};
	
F : TLEESAL "(" TID "," E ")" {
	$$=entero;
	if ($5!=entero)
		{
		puts("El valor de localidad de lee_salida() debe ser entero.");
		return 1;
		}
	fprintf(fc,"auxlp=ptrloc(intp_cimapop());\n",$5);
	fprintf(fc,"intp_push(auxlp->%s); /* lee_salida */\n",$3);
	};
	
F : TLEEDESC "(" E ")" {
	if ($3!=entero)
		{
		puts("El valor de lee_desc debe ser entero.");
		return 1;
		}
	fprintf(fc,"strp_push(ptrloc(intp_cimapop())->descrip); /* lee_desc */\n");
	$$=cadena;
	};
	
F : TOBJDESC "(" E ")" {
	if ($3!=entero)
		{
		puts("El valor de obj_desc debe ser entero.");
		return 1;
		}
	fprintf(fc,"strp_push(ptrobj(intp_cimapop())->descrip); /* obj_desc */\n");
	$$=cadena;
	};
	
F : TOBJNUM "(" E ")"
	{
	if ($3!=cadena)
		{
		puts("!: obj_num() espera recibir una cadena de caracteres.");
		return 1;
		}
	fprintf(fc,"intp_push(objnum(strp_cima()));\nstrp_pop(); /* obj_num() */\n");
	$$=entero;
	};
F : TOBJTIENE "(" E ")"
	{
	if ($3!=entero)
		{
		puts("!: obj_tiene() espera un nmero de objeto entero.");
		return 1;
		}
	fprintf(fc,"intp_push(ptrobj(intp_cimapop())->estado==jugador); /* obj_tiene() */\n");
	$$=entero;
	};
	
F : TOBJCOGIBLE "(" E ")"
	{
	if ($3!=entero)
		{
		puts("!: obj_cogible() espera un nmero de objeto entero.");
		return 1;
		}
	fprintf(fc,"intp_push(ptrobj(intp_cimapop())->cogible); /* obj_cogible() */\n");
	$$=entero;
	};

F : TOBJESTA "(" E "," E ")"
	{
	if ($3!=entero || $5!=entero)
		{
		puts("!: obj_esta() espera un nmero de objeto y un nmero de localidad.");
		return 1;
		}
	fprintf(fc,"{int nloc=intp_cimapop();\nint nobj=intp_cimapop();\nintp_push((ptrobj(nobj)->estado==localidad) && (ptrobj(nobj)->loc==nloc));\n}/* obj_esta() */\n");
	$$=entero;
	};

F : TLEEOBJFLAG "(" E "," E ")"
	{
	if ($3!=entero || $5!=entero)
		{
		puts("!: obj_flag() espera un nmero de objeto y un nmero de localidad.");
		return 1;
		}
	fprintf(fc,"{int nflag=intp_cimapop();\nint nobj=intp_cimapop();\nintp_push(ptrobj(nobj)->flag[nflag]);\n}/* obj_esta() */\n");
	$$=entero;
	};
	

F : TOBJLIMBO "(" E ")"
	{
	if ($3!=entero)
		{
		puts("!: obj_limbo() espera un nmero de objeto entero.");
		return 1;
		}
	fprintf(fc,"intp_push(ptrobj(intp_cimapop())->estado==limbo); /* obj_limbo() */\n");
	$$=entero;
	};
	
F : TCADENACONTENIDA "(" E "," E ")"
	{
	if ($3!=cadena || $5!=cadena)
		{
		puts("!: cadena_contenida espera cadenas de caracteres");
		return 1;
		}
	fprintf(fc,"\nintp_push(strp_cadenacont()); /* cadena_contenida */\n");
	$$=entero;
	}

	
F : TLLENO "(" ")"
	{
	$$=entero;
	fprintf(fc,"intp_push(objinvlleno()); /* lleno() */\n");
	}
	
	
F : '(' E ')' { $$=$2; };
F : TNO E
	{
	if ($2!=entero)
		{
		printf("!-> Slo pueden negarse valores numricos.");
		return 1;
		}
	fprintf(fc,"intp_not();\n");
	$$=entero;
	}
	
F : AKA {$$=entero; fprintf(fc,"intp_push(%s);\n",$1); }
		
	  	

%%

#include "lex.yy.c"

main(int argc,char **argv)
{
int v;
puts("Nmesis 1.00 Beta\nUn autntico sistema de desarrollo de aventuras multiplataforma\n Por Javier Basilio Prez Ramas - ");
puts("(C) 2000 Definitive Software");
puts("erjaba@teleline.es");
defecto=0;
fc=fopen("verbos.c","w");
fh=fopen("verbos.h","w");
fp=fopen("accion.c","w");
fgc=fopen("usrgl.c","w");
fgh=fopen("usrgl.h","w");
fsave=fopen("savvars.c","w");
fload=fopen("lodvars.c","w");
if (fc==NULL || fh==NULL || fp==NULL || fgc==NULL || fgh==NULL || fsave==NULL || fload==NULL)
	{
	puts("Nmesis no puede crear alguno de los ficheros de salida.");
	return 1;
	}
v=yyparse();
fclose(fc);
fclose(fh);
fclose(fp);
fclose(fgc);
fclose(fgh);
fclose(fsave);
fclose(fload);
puts ("NMESIS - Saliendo ...");
if (v>0)
	{
	printf("Detenido con error en lnea %d\n",numlinea);	
	printf("SALIDA CON ERROR ltimo token reconocido = %s\n",yytext);
	}
	
return v;
}

yyerror(char *s)
{
printf("Error -> %s\n",s);
}

/* Comprueba tipos y da el resultado de operaciones; genera error si es operacin de
tipos incompatibles */

enum ttipo gestipos(t1,t2,op)
enum ttipo t1,t2;
char op;

{
/*printf("COMPARANDO %d %d %c\n",t1,t2,op);
  */

switch (op)
	{
	
	
	case '+':
	case '=':
		if ((t1==t2) &&(t2==entero)) return entero;
		if ((t1==t2) &&(t2==cadena)) return cadena;
		if (t1==entero && t2==cadena)
			{
			fprintf(fc,"strp_push(intp_itoa());\n");
			fprintf(fc,"strp_xchg(); /* intercambia cima con el valor por debajo */\n");
			return cadena;
			}
		if (t1==cadena && t2==entero)
			{
			fprintf(fc,"strp_push(intp_itoa()); intp_pop(); /* Conversin entero->cadena */\n");
			return cadena;
			}
		printf("Suma de tipos no compatibles\n");
		exit(1);
	case '*':
	case '-':
	case '/':
		if (t1==entero && t2==entero) return entero;
		printf("Operacin slo vlida entre enteros linea %d\n",numlinea);
		exit(1);
	default:
		printf("Error interno -> REVISAR GESTIPOS()\n");
		exit(2);
	}
}

/* Incorpora una funcin de movimiento estndar */

movfun(char *s)

{

fprintf(fh,"int %s(char *nombre); /* funcin de movimiento estndar */\n",s);
fprintf(fc,"int %s(char *nombre)  /* funcin de movimiento estndar */\n",s);
fprintf(fc,"{\nstruct local *p=ptrloc(gloc);\n");
fprintf(fc,"if (p->%s==0) {puts(%cNo hay salida en esa direccin.%c);return;}\n",s,'"','"');
fprintf(fc,"gloc=p->%s;\n}\n",s);
fprintf(fp,"if (strcmp(verbo,%c%s%c)==0) { %s(nombre); return; }\n",'"',s,'"',s);

}


	