/*
 * Decompiled with CFR 0.152.
 */
package mechanique;

import java.util.Calendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class interpreter {
    private String outputText = "";
    private String userInput = "";
    private boolean fireQuestion;
    private String targetLine;
    private boolean targetLineFlag = false;
    private boolean incrementPointer = false;
    private String[] actions = new String[100];
    private String codeLine = "";
    private String currentCodeLine = "";
    private String currentLabel = "";
    private String[] currentLocks = new String[40];
    private String currentAction = "";
    private String[] MQkeys = new String[800];
    private String[] callers = new String[100];
    private int counter = 0;
    private int historyKey = 0;
    private int rotateKey = 0;
    private int pathKey = 0;
    private int twistKey = 0;
    private int diceKey = 0;
    private String occKey = "";
    private Calendar occasion = Calendar.getInstance();
    private boolean pathKeyDirection = true;
    private boolean instructionFound = false;
    private String error = "";
    private boolean debugMode = false;

    public interpreter() {
        int n;
        for (n = 0; n < 800; ++n) {
            this.MQkeys[n] = "-no key-";
        }
        for (n = 0; n < 100; ++n) {
            this.callers[n] = "-no caller-";
        }
        this.twistKey = Math.round((int)(Math.random() * 3.0));
        if (this.twistKey > 0) {
            this.addKey("TWIST" + this.twistKey);
        }
        this.occKey = "" + this.occasion.get(2) + this.occasion.get(5);
        this.addKey("OCC" + this.occKey);
    }

    public String getErrors() {
        if (this.error.equals("")) {
            return "";
        }
        return this.error;
    }

    public void setDebugMode(boolean bl) {
        this.debugMode = bl;
    }

    private void makeSystemKeys() {
        this.diceKey = Math.round((int)(Math.random() * 6.0) + 1);
        this.dropKey("DICE1");
        this.dropKey("DICE2");
        this.dropKey("DICE3");
        this.dropKey("DICE4");
        this.dropKey("DICE5");
        this.dropKey("DICE6");
        this.addKey("DICE" + this.diceKey);
        this.dropKey("TIME" + this.historyKey);
        ++this.historyKey;
        this.addKey("TIME" + this.historyKey);
        ++this.rotateKey;
        if (this.rotateKey == 7) {
            this.rotateKey = 1;
        }
        this.dropKey("ROT1");
        this.dropKey("ROT2");
        this.dropKey("ROT3");
        this.dropKey("ROT4");
        this.dropKey("ROT5");
        this.dropKey("ROT6");
        this.addKey("ROT" + this.rotateKey);
        this.pathKey = this.pathKeyDirection ? ++this.pathKey : --this.pathKey;
        if (this.pathKey == 1) {
            this.pathKeyDirection = true;
        }
        if (this.pathKey == 6) {
            this.pathKeyDirection = false;
        }
        this.dropKey("PATHA");
        this.dropKey("PATHB");
        this.dropKey("PATHC");
        this.dropKey("PATHD");
        this.dropKey("PATHE");
        this.dropKey("PATHF");
        switch (this.pathKey) {
            case 1: {
                this.addKey("PATHA");
                break;
            }
            case 2: {
                this.addKey("PATHB");
                break;
            }
            case 3: {
                this.addKey("PATHC");
                break;
            }
            case 4: {
                this.addKey("PATHD");
                break;
            }
            case 5: {
                this.addKey("PATHE");
                break;
            }
            case 6: {
                this.addKey("PATHF");
            }
        }
    }

    public void concierge_showKeys() {
        String string = "KEYS:";
        for (int i = 0; i < this.MQkeys.length; ++i) {
            if (this.MQkeys[i] == "-no key-") continue;
            string = string + "|" + this.MQkeys[i];
        }
        System.out.println(string);
    }

    public void questionAsked() {
        this.fireQuestion = false;
    }

    public void setAnswer(String string) {
        this.dropInteractionKeys();
        this.addKey("_" + string);
    }

    public String getOutputText() {
        return this.outputText;
    }

    public boolean getIncrementPointer() {
        return this.incrementPointer;
    }

    public boolean isQuestion() {
        return this.fireQuestion;
    }

    public void cleanOutput() {
        this.outputText = "";
    }

    private int findKey(String string) {
        int n = 0;
        for (int i = 0; i < this.MQkeys.length; ++i) {
            if (!this.MQkeys[i].equals(string)) continue;
            n = i;
        }
        return n;
    }

    private void addKey(String string) {
        this.MQkeys[this.findKey((String)"-no key-")] = string;
    }

    private void dropKey(String string) {
        this.MQkeys[this.findKey((String)string)] = "-no key-";
    }

    private void dropInteractionKeys() {
        for (int i = 0; i < this.MQkeys.length; ++i) {
            if (!this.MQkeys[i].startsWith("_")) continue;
            this.MQkeys[i] = "-no key-";
        }
    }

    public static int loadTarget(String string, String[] stringArray) {
        int n = -1;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf("[" + string + "]") == -1) continue;
            n = i;
        }
        return n;
    }

    private boolean getMQLabel() {
        Pattern pattern = Pattern.compile("\\[([\\w\\d]+)\\]");
        Matcher matcher = pattern.matcher(this.currentCodeLine);
        boolean bl = false;
        bl = matcher.find();
        if (bl) {
            if (this.debugMode) {
                System.out.println("DEBUGGER - I found a label on this line: " + matcher.group(1));
            }
            this.currentLabel = matcher.group(1);
            return true;
        }
        return false;
    }

    private void getLocks() {
        int n;
        Pattern pattern = Pattern.compile("\\{([!_\\w\\d]+)\\}");
        Matcher matcher = pattern.matcher(this.currentCodeLine);
        for (n = 0; n < 40; ++n) {
            this.currentLocks[n] = new String("-no lock-");
        }
        n = 0;
        int n2 = 0;
        while (true) {
            boolean bl = matcher.find();
            n = bl ? 1 : 0;
            if (!bl) break;
            this.currentLocks[n2] = matcher.group(1);
            ++n2;
        }
    }

    private boolean openLocks() {
        String string = "";
        boolean bl = false;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        Integer n = new Integer("0");
        String string2 = "";
        boolean bl6 = false;
        for (int i = 0; i < this.currentLocks.length; ++i) {
            bl = false;
            bl3 = false;
            if (this.debugMode) {
                System.out.println("DEBUGGER - Trying to open lock :" + this.currentLocks[i]);
            }
            if ((string = this.currentLocks[i]).startsWith("!")) {
                string = string.substring(1);
                bl3 = true;
            }
            Pattern pattern = Pattern.compile("^TIME(\\d+)");
            Matcher matcher = pattern.matcher(string);
            boolean bl7 = false;
            bl7 = matcher.find();
            if (bl7 && this.historyKey < (n = new Integer(matcher.group(1)))) {
                this.dropKey("TIME" + this.historyKey);
                this.addKey("TIME" + n.toString());
                bl6 = true;
            }
            if (string.equals("-no lock-")) {
                bl = true;
            } else {
                for (int j = 1; j < this.MQkeys.length; ++j) {
                    if (!this.MQkeys[j].equals(string)) continue;
                    if (this.debugMode) {
                        System.out.println("DEBUGGER - OPENED LOCK " + string + " with key: " + this.MQkeys[j]);
                    }
                    bl = true;
                }
                if (!bl && bl3) {
                    bl = true;
                    if (this.debugMode) {
                        System.out.println("DEBUGGER - Unlocked " + string + " by negative key");
                    }
                } else if (bl && bl3) {
                    bl = false;
                    if (this.debugMode) {
                        System.out.println("DEBUGGER - you had key " + string + " but needed negative key");
                    }
                }
            }
            if (bl) {
                bl4 = true;
            }
            if (!bl) {
                bl2 = false;
            }
            if (string.equals("or") && bl4) {
                bl2 = true;
            }
            if (!bl6) continue;
            this.dropKey("TIME" + n.toString());
        }
        if (bl2) {
            if (this.debugMode) {
                System.out.println("DEBUGGER - >>UNLOCKED<< - Access to action.");
            }
        } else if (this.debugMode) {
            System.out.println("DEBUGGER - NO ACCESS, could not open all locks in this line.");
        }
        return bl2;
    }

    private void performAction() {
        String string;
        this.instructionFound = false;
        Pattern pattern = Pattern.compile("\\^:(.*)");
        Matcher matcher = pattern.matcher(this.currentCodeLine);
        boolean bl = false;
        bl = matcher.find();
        if (bl && !this.instructionFound) {
            this.outputText = this.outputText + "\n";
            this.outputText = this.outputText.concat(matcher.group(1));
            this.instructionFound = true;
        }
        pattern = Pattern.compile("\\^#(.*)");
        matcher = pattern.matcher(this.currentCodeLine);
        bl = false;
        bl = matcher.find();
        if (bl && !this.instructionFound) {
            this.instructionFound = true;
        }
        pattern = Pattern.compile("\\^\\?(.*)");
        matcher = pattern.matcher(this.currentCodeLine);
        bl = false;
        bl = matcher.find();
        if (bl && !this.instructionFound) {
            this.makeSystemKeys();
            this.fireQuestion = true;
            this.instructionFound = true;
        }
        pattern = Pattern.compile("\\^\\+(.*)");
        matcher = pattern.matcher(this.currentCodeLine);
        bl = false;
        bl = matcher.find();
        if (bl && !this.instructionFound) {
            string = matcher.group(1);
            string = string.trim();
            if (this.debugMode) {
                System.out.println("add key " + string);
            }
            this.addKey(string);
            this.instructionFound = true;
        }
        pattern = Pattern.compile("\\^->(.*)");
        matcher = pattern.matcher(this.currentCodeLine);
        bl = false;
        bl = matcher.find();
        if (bl && !this.instructionFound) {
            if (this.getMQLabel()) {
                ++this.counter;
                this.callers[this.counter] = this.currentLabel;
            }
            string = matcher.group(1);
            this.targetLine = string = string.trim();
            this.targetLineFlag = true;
            this.instructionFound = true;
        }
        pattern = Pattern.compile("\\^\\-(.*)");
        matcher = pattern.matcher(this.currentCodeLine);
        bl = false;
        bl = matcher.find();
        if (bl && !this.instructionFound) {
            string = matcher.group(1);
            string = string.trim();
            this.dropKey(string);
            this.instructionFound = true;
        }
        pattern = Pattern.compile("\\^<-(.*)");
        matcher = pattern.matcher(this.currentCodeLine);
        bl = false;
        bl = matcher.find();
        if (bl && !this.instructionFound) {
            string = this.callers[this.counter];
            --this.counter;
            this.targetLine = string;
            if (this.debugMode) {
                System.out.println("jump to :" + string);
            }
            this.targetLineFlag = true;
            this.incrementPointer = true;
            this.instructionFound = true;
        }
        if (!this.instructionFound) {
            this.error = "illegal instruction";
        }
    }

    public String getTarget() {
        if (this.targetLineFlag) {
            return this.targetLine;
        }
        return "-no target-";
    }

    public void performActions() {
        this.actions = this.codeLine.split("\\|");
        if (this.actions.length > 0) {
            for (int i = 0; i < this.actions.length; ++i) {
                this.currentCodeLine = this.actions[i];
                this.performAction();
            }
        } else {
            this.performAction();
        }
    }

    public void executeLine(String string) {
        if (this.debugMode) {
            System.out.println("DEBUGGER - executing :" + string);
        }
        this.currentCodeLine = string;
        this.targetLineFlag = false;
        this.incrementPointer = false;
        this.getMQLabel();
        this.getLocks();
        this.codeLine = this.currentCodeLine;
        if (this.openLocks()) {
            this.performActions();
        }
    }
}

