var game = {
	title: 'Фантазия',
	author: 'Алексей Галкин &lt;johnbrown&gt;',
	year: 2018,
	license: 'MIT',
	version: '8.0',
	info: 'Небольшая демонстрационная игра на движке protoparser.js.',
	notSavedMsg: 'Ошибка сохранения. Игра не сохранена.',
	tests: false,
	maxScore: 5
}

var player = {
	nam: ['вы', 'себя', 'себе', 'себя', 'собой', 'себе'],
	desc: 'Вы - обычный турист, неизвестно как попавший сюда.',
	hidden: true,
	loc: 'hall'
}

var globalVerbs = {
    sleep: function() {
        p('Едва ли вам теперь удастся заснуть.')
        return true
    }
}

var events = {
	init: function() {
		p('Вы стоите в длинном широком коридоре какого-то старого особняка или даже замка, не имея ни малейшего понятия как здесь очутились, и, что еще важнее, как отсюда выбраться.')
		gameCommands.take[1].push('схватить', 'завладеть')
		gameCommands.sneeze = ['sneeze', ['чихать', 'чихнуть'], 0]
	},
	beforeAll: function(com, obj, optional) {
		if ((com == 'take' || com == 'wear') && obj == hat && !hat.moved) {
			p('Едва вы успели коснутся шляпы, внезапный порыв ветра подхватил ее, и понес в сторону озера. С удивлением вы обнаруживаете яблоко на том месте, где только что лежала шляпа.')
			move(hat, 'lake')
			apple.loc = 'tower'
			return true
		}
		if (player.loc == 'tower' && optional == 'n' && tower.n == 'tree') {
			p('Вы осторожно перебираетесь на верхушку дерева.')
			walk(undefined, 'n')
			return true
		}
		if ((player.loc == 'glade' && optional == 'n' && coin.loc == 'oldman') || (player.loc == 'lake' && optional == 's')) p('Вы усиленно нажимаете на весла, и в несколько мощных гребков преодолеваете половину озера.')
	},
	afterAll: function(com, obj, optional) {
		watch.worn ? game.prompt = new Date().toLocaleTimeString() + ' > ' : game.prompt = '> '
		if (com == 'show' && player.loc == 'glade') {
			if (obj == coin) {
				p('Глаза старика радостно загораются. «Вот спасибо-то! Будет старику прибавка к пенсии. Забирай лодку, коль не передумал.»')
				move(coin, 'oldman')
			} else p('Старик с видом знатока кивает: «' + capitalize(obj.nam[0]) + ' что надо!»')
		}
		if (com == 'say' && optional == 'домой' && hat.worn) {
			p('Едва вы произнесли это слово, как, внезапно, обнаружили, что сидите уставившись в экран. Ха-ха! Это была всего лишь игра. Спасибо, что уделили ей время. Приходите еще!')
 			end(1)
		}
		if (player.loc == 'hall' || player.loc == 'round') {
			document.body.style.color = 'white'
			document.body.style.backgroundColor = 'black'
            document.getElementById('input').style.color = 'white'
		} else {
			document.body.style.color = 'black'
			document.body.style.backgroundColor = 'white'
            document.getElementById('input').style.color = 'black'
		}
		player.loc == 'glade' && oldman.activity()
		if (oldman.loc == player.loc && com == 'say') oldman.response(optional)
	}
}

var ticket = {
	nam: ['билет', 'билета', 'билету', 'билет', 'билетом', 'билете', 'прямоугольник', 'текст'],
	spec: 'thing',
	desc: 'Картонный прямоугольник голубого цвета, на котором изящными золотистыми буквами напечатан какой-то текст.',
	text: '<div style="color:yellow; background-color: blue;"><p style="text-align: center;font-weight: bold;">«Уважаемый посетитель # 3677!</p><p style="font-style:italic;">Мы рады приветствовать вас в Фантазии. Пожалуйста, ни чему не удивляйтесь и чувствуйте себя как дома. Но, если вам и впрямь надо вернуться домой используйте шляпу».</p></div>',
	loc: 'round',
	takeable: true,
	drop: function() {
		p('Билет еще пригодится.')
		return true
	}
}

var apple = {
	spec: 'thing',
	nam: ['яблоко', 'яблока', 'яблоку', 'яблоко', 'яблоком', 'яблоке', 'фрукт', 'плод'],
	desc: 'Ярко-красный плод так и манит его съесть.',
	takeable: true, edible: true,
	loc: '',
	eat: function() {
		remove(this);
		move(seed, 'player')
		p('Яблоко было таким вкусным, что вы даже не заметили, как оно исчезло у вас во рту, а вместо него в руках оказалась косточка.')
		return true
	} 
}

var seed = {
	spec: 'thing',
	nam: ['косточка', 'косточки', 'косточке', 'косточку', 'косточкой', 'косточке', 'кость', 'семя', 'семечко', 'зернышко', 'зерно'],
	desc: 'Крохотное золотистое зернышко чуть подрагивает словно живое. Кажется, ей не очень здесь нравится. Наверное, она хочет туда, где ей будет хорошо.',
    sceneDesc: 'Золотистое зернышко крутится и подпрыгивает на каменном полу.',
	drop: function() {
		if (player.loc == 'tower') {
			p('Едва косточка коснулась земли, как стены башни и пол затряслись, послышался громкий треск сучьев, словно какой-то великан прокладывал себе дорогу через чащу леса. В действительности же, дорогу себе прокладывало огромное дерево, непонятно как за какие-нибудь пять минут достигшее своей верхушкой вершины башни.')
			remove(this)
			tower.desc = 'Открытая площадка башни позволяет видеть округу на много километров. Озеро на севере заграждают кроны огромного дерева, вплотную примкнувшие к башне. Вниз ведет лестница.'
			tower.n = 'tree'
			objTree.loc = ['tower', 'tree', 'glade']
			return true
		}
	},
	loc: '',
	takeable: true
}

var hall = {
	spec: 'room',
	head: 'Длинный коридор',
	desc: 'Серые каменные стены коридора, кажется, покрыты пылью многих веков. На севере расположена невысокая дверь. Каменная спиральная лестница поднимается высоко вверх. Возле стены, стоит полный рыцарский доспех с опущенным забралом. Вас не покидает чувство, что за вами наблюдают.',
	n: 'round',
	u: 'tower',
	say: function(obj, word) {
		say(undefined, word);
		p('Эхо коридора чужим голосом повторило «' + capitalize(word) + ', ' + word + ', ' + word + '...».')
		return true
	},
	walk: function(obj, dir) {
		if (dir == 'u' && !tower.visits) p('После полумрака коридора яркий дневной свет на несколько секунд ослепляет вас. Открывшаяся вашему взору картина завораживает.')
	}
}

var stairs = {
	spec: 'thing',
	nam: ['лестница', 'лестницы', 'лестнице', 'лестницу', 'лестницой', 'лестнице', 'ступеньку', 'ступень'],
	desc: 'Узкая винтовая лестница, на которой с трудом разминутся даже два человека, соединяет башню и коридор.',
	hidden: true,
	loc: ['hall', 'tower']
}

var wall = {
	spec: 'thing',
	nam: ['стена','стены','стене','стену','стеной','стене', 'пыль', 'грязь', 'камень', 'камни'],
	desc: 'Стена сложена из огромных серых камней, первоначальный цвет которых не представляется возможным определить из-за толстого слоя многовековой пыли и грязи, которыми они покрыты.',
	hidden: true,
	loc: ['hall', 'round']
}

var armour = {
	spec: 'thing',
	nam: ['доспех', 'доспеха', 'доспеху', 'доспех', 'доспехом','доспехе', 'доспехи', 'рыцаря', 'забрало', 'шлем'],
	desc: 'Потемневший от времени доспех даже сейчас производит угрожающее впечатление. Доспех несомненно пуст, и все-же вам не хотелось бы оставаться с ним наедине.',
	hidden: true,
	loc: 'hall',
	closed: true,
	take: function() {
		p('Доспех слишком тяжел для вас.')
		return true
	},
	wear: function() {
		p('Глупо таскать такую кучу металла на себе.')
		return true
	},
	attack: function() {
		if (key.loc == 'armour') p('Внутри доспеха что-то звякнуло.')
		else p('Доспех отозвался глухим звуком удара.')
		return true
	},
	open: function() {
		if (key.loc == 'armour') {
			p('Едва вы подняли  забрало, что-то блестящее выскочило из шлема и со звоном упало на каменный пол.')
			move(key, 'hall')	
		} else if (armour.closed) 
			p('Вы поднимите забрало и заглядываете внутрь, но там только паутина.')
		else p('Забрало уже поднято.')
		armour.closed = false
		hall.desc = hall.desc.replace('опущенным', 'поднятым')
		return true
	},
	close: function() {
		if (armour.closed) p('Забрало уже опущено.')
		else p('Вы опускаете забрало.')
		hall.desc = hall.desc.replace('поднятым', 'опущенным')
		armour.closed = true
		return true
	}
}

var round = {
	spec: 'room',
	head: 'Круглая комната',
	desc: 'Большая круглая комната выглядит пустой и необжитой. Кажется, хозяин (или, быть может, архитектор) поленился придать ей индивидуальность. Единственное украшение комнаты, не считая вас, - деревянная дверь на юге.',
	s: 'hall'
}

var heavy_door = {
	spec: 'thing',
	nam: ['дверь', 'двери', 'двери', 'дверь', 'дверью', 'двери'],
	desc: 'Тяжелая дубовая дверь, кажется, помнит еще те времена, когда слово «рыцарь» было не просто красивым эпитетом.',
	hidden: true,
	loc: ['round','hall'],
	closed: true,
	locked: true,
	door: true,
	unlock: function() {
		if (heavy_door.locked && heavy_door.closed) {
			if (key.loc == 'player') p('Вы вставляете ключ в замочную скважину и с большим трудом проворачиваете его.')
			else {
				p('Без ключа дверь не открыть.')
				return true
			}
		}
	},
	lock: function() {
		if (!heavy_door.locked && heavy_door.closed) {
			if (key.loc == 'player') p('Вы вставляете ключ в замочную скважину и с большим трудом проворачиваете его, придавливая рукой тяжелую дверь.')
			else {
				p('Без ключа дверь не запереть.')
				return true
			}
		}
	}
}

var key = {
	spec: 'thing',
	nam: ['ключ', 'ключа', 'ключу', 'ключ', 'ключом', 'ключе'],
	desc: 'Тяжелый бронзовый ключ.',
	loc: 'armour',
	takeable: true,
	drop: function() {
		if (player.loc == 'lake') {
			remove(this)
			p('Бульк!<br>Ключ быстро исчезает в мутной воде.')
			return true
		}
	}
}

var glade = {
	spec: 'room',
	head: 'Поляна',
	desc: 'Небольшая поляна залита солнечным светом. В центре поляны высится огромное дерево. На севере поблескивает на солнце небольшое озеро, прохладный ветерок с которого вас приятно освежает. На берегу, рядом с водоемом, ссутулившись, сидит, глядя на воду старик. В метре от него к берегу причалена старая лодка. Вдалеке, на северо-востоке виднеется выход из парка.',
	u: 'tree',
	ne: 'entrance',
	n: 'lake',
	walk: function(obj, dir) {
		if (dir == 'n' && coin.loc != 'oldman') {
			p('«А ну отойди от лодки! Ишь, ты, хулиган!». Резкий окрик старика удержал вас от попытки воспользоваться лодкой.')
			return true
		}
	}
}

var lake = {
	spec: 'room',
	head: 'Озеро',
	desc: 'В круглом голубом озере отражается небо. Поляна расстилается далеко на юге.',
	s: 'glade',
	walk: function(obj, dir) {
		if (dir != 's' && dir != 'u') {
			if (dir == 'd') p('У вас нет акваланга.')
			else p('Сейчас не время кататься по озеру.')
			return true
		}
	}
}

var entrance = {
	spec: 'room',
	head: 'Вход в парк',
	desc: 'Широкие решетчатые ворота на севере отделяют «Фантазию» от внешнего мира. У входа в парк стоит автомат по продаже билетов. На юго-западе раскинулась широкая поляна.',
	sw: 'glade',
	n: ''
}

var gate = {
	spec: 'thing',
	nam: ['ворота', 'ворот', 'воротам', 'ворота', 'воротами', 'воротах', 'фигуры', 'фигуру', 'животных', 'животное', 'створки', 'створка', 'дверь', 'двери'],
	gend: 'p',
	desc: 'Чугунные прутья ворот украшены цветным фигурами сказочных животных.',
	hidden: true,
	loc: 'entrance',
	door: true,
	locked: true,
	closed: true,
	unlock: function() {
		p('Вы внимательно осматриваете ворота, но ни замка, ни задвижки, ни другого запирающего устройства не находите. Потратив еще несколько минут изучая створки и пытаясь найти хоть какие-нибудь лазейки, вы пришли к выводу, что ворота явно волшебные, и просто так не откроются.')
		return true
	}
}

var redBox = {
	spec: 'thing',
	nam: ['автомат', 'автомата', 'автомату', 'автомат', 'автоматом', 'автомате', 'ящик', 'щель', 'лоток', 'отверстие'],
	desc: 'Высокий с человеческий рост красный ящик чем-то неуловимо напоминает первые модели игровых автоматов. Рядом с щелью для купюр имеется отверстие откуда выходят билеты, а ниже под ним - лоток для сдачи.',
	hidden: true,
	loc: 'entrance',
	attack: function(obj, optional, verb) {
		if ((verb == 'ударить' || verb == 'пнуть' || verb == 'стукнуть') && !redBox.beaten) {
			p('Вы со всей силой ударяете по автомату, который тут же, в отместку, выплевывает в вас серебряную монету.')
			move(coin, 'entrance')
			redBox.beaten = true
			reward(5)
			return true
		}
	},
	beaten: false
}

var coin = {
	spec: 'thing',
	nam: ['монета', ' монеты', 'монете', 'монету', ' монетой', 'монете', 'деньги'],
	desc: 'Маленькая серебряная монетка с надписью «Жетон Банка Фантазии».',
	loc: '',
	takeable: true
}

var boat = {
	spec: 'thing',
	nam: ['лодка', 'лодки', 'лодке', 'лодку', 'лодкой', 'лодке', 'краску'],
	desc: 'Старое корыто, коим, по-сути, и была лодка неизвестно каким чудом держалась на воде. Краска на ее бортах давно потрескалась и отлетела. Внутри места хватало ровно на одного человека, да еще на бутылку в которую можно положить послание «Я был так глуп, что решил отправиться в плавание на этой скорлупе. Не повторяйте моей ошибки».',
	hidden: true,
	loc: ['glade', 'lake']
}

var tower = {
	spec: 'room',
	head: 'Башня',
	desc: 'Открытая площадка башни позволяет видеть округу на много километров. В отдалении на севере блестит небольшое озеро и виднеется выход из парка. Вниз ведет лестница.',
	d: 'hall',
	walk: function(obj, dir) {
		if (dir != 'u' && dir != 'd') { p('Слишком высоко. Надо найти какой-то другой способ спуститься вниз.')
		return true
		}
	},
	jump: function() {
		p('С такой высоты? Ну, уж нет!')
		return true
	}
}		

var hat = {
	spec: 'thing',
	nam: ['шляпа', 'шляпы', 'шляпе', 'шляпу', 'шляпой', 'шляпе', 'надпись', 'ленту'],
	desc: 'Серая широкополая шляпа выглядит весьма помятой. Сбоку к шляпе приколота какая-то лента с надписью.',
	read: function() {
		if (hat.loc == 'player' && !hat.worn) p('Надпись на ленте гласила: «Надень меня, скажи «Домой!», и дом увидишь свой родной».')
		else p('Вам придется взять в руки шляпу, чтобы прочитать текст на ленте.')
		return true
	},
	loc: 'tower',
	takeable: true, worn: false
}

var tree = {
	spec: 'room',
	head: 'Вершина дерева',
	desc: 'Широкие кроны дерева позволяют вам свободно, и, даже, с некоторым удобством разместиться на верхушке. Прямо под вами далеко внизу раскинулась залитая солнцем поляна, а в нескольких метрах с южной стороны высится еще одна громада - старая башня.',
	s: 'tower',
	d: 'glade'
}

var objTree = {
	spec: 'thing',
	nam: ['дерево', 'дерева', 'дереву', 'дерево', 'деревом', ' дереве', 'крону', 'лист', 'листья'],
	desc: 'Эта громада производит впечатление спящего великана, тяжело покачиваясь и шумя листьями при сильных порывах ветра. Ее широкие кроны опираются на башню, доставая до самой ее вершины.',
	hidden: true,
	loc: ''
}

var oldman = {
	spec: 'thing',
	nam: ['старик', ' старика', 'старику', 'старика', 'стариком', 'старике', 'лодочника', 'шорты', 'телогрейку', 'старичка', 'деда'],
	desc: 'Невысокий лысенький старичок в поношенной телогрейке и в цветастых молодежных шортах, неизвестно как на нем очутившихся, поглощен разглядыванием озера. Кажется, ничто на свете его не трогает.',
	hidden: true,
	loc: 'glade',
	activity: function() {
		var activityNumber = Math.round(Math.random() * 9)
		if (activityNumber < 5) {
			var activityText = [
				'Старик украдкой поглядывает на вас.',
				'Старик что-то бормочет себе под нос.',
				'Старый лодочник в задумчивости чешет макушку.',
				'Старик бормочет что-то о вездесущих туристах.',
				'Старец громко похрапывает.'
			]
			p(activityText[activityNumber])
		}
	},
	response: function(optional) {
		switch(optional) {
			case 'здравствуйте':
			case 'здравствуй':
			case 'привет': var response = 'И тебе не хворать.'
			break
			case 'фантазия':
			case 'парк':
			case 'замок':
			case 'башня': var response = 'Парк-то здешний вроде заповедника волшебного - разными чудесами полнится. Видал дерево? А с утра не было. Небось твоя работа? Меня-то, люди добрые Михеем кличут, я здесь, вроде как, сторож, приглядываю за всем, порядок блюду, в смысле, блюжу, охраняю, короче.'
			break
			case 'михей': var response = 'Шо?'
			break
			case 'озеро': var response = 'Давно тут сижу. Озеро широкое, озеро глыбокое - вплавь не переплыть, с ахвалангом не перейтить. Вот только лодчонка моя могеть озеро тутошнее того... одолеть.'
			break
			case 'шляпа':
			case 'шляпу':
			var response = 'Шляпу-то? Видал-видал. Пролетела тут, давеча, как фанера над Парижем, да и в воду бултыхнулась.'
			break
			case 'монета':
			case 'монету':
			case 'деньги':
			case 'лодка':
			case 'лодку': if (coin.loc == 'oldman') var response = 'Ступай милый, ступай!'
				else if (coin.loc == 'player') {
				var response = 'Вот спасибо-то! Будет старику прибавка к пенсии. Забирай лодку, коль не передумал.'
				move(coin, 'oldman')
				}
				else var response = 'Помоги дедушке материально, и катайся себе на здоровье, милок!'
				break
			default: var response = 'Чего говОришь-то?'
		}
		p('Старик отвечает: «' + response + '»')
	}
}

var watch = {
	spec: 'thing',
	nam: ['часы', 'часов', 'часам', 'часы', 'часами', 'часах', 'пластик', 'ремешок'],
	desc: 'Легендарные электронные часы «Motnana» из благородного черного пластика с элегантным гибким ремешком для удобного ношения. Вечная классика.',
	loc: 'player',
	takeable: true, worn: false,
	drop: function() {
		if (player.loc == 'lake') {
			p('Пустить на дно такие часы? Ну уж нет!')
			return true
		}
	}
}

function sneeze() {
	p('– Апч-хи!!!')
}
