package iageserver;

/**
 * Timer class - used to handle real-time NPCs
 */

public class npctimer extends Thread {
	
	/*** Set this flag to true to stop the timers running */
	public boolean StopRunning = false;
	
	public npctimer() {
		this.start();		
	}
	
	
	/*** Runs in a loop deciding when to fire off
	   * NPC code and sleeping in increments of 25ms */
	public void run() {
		
		character cc = null;
		int i = 1;
		long ourtimerat = 0;
		
		while (!StopRunning) {
		
			i = 1;
			while (i <= data.ocharacters.getCount()) {
				cc = (character) data.ocharacters.get(i);
				
				// If there is no timer interval, never run the on timer command
				if (cc.TimerInterval > 0) {
				
					// If there is no time to next run, default it in
					if (cc.TimeToNextRun == 0) {
						cc.TimeToNextRun = ourtimerat + cc.TimerInterval;
					}
					
					// Check to see if anything needs to be run and if it 
					// does, run it!
					if (ourtimerat > cc.TimeToNextRun) {
						// Run inbuilt AI before Timer Code
						cc.PerformAI();
						interpreter ti = new interpreter(null, null);
						ti.runcode(cc.OnTimer, "Character(" + Long.toString(cc.ID) + ").OnTimer");
						cc.TimeToNextRun = cc.TimeToNextRun + cc.TimerInterval;
						cc.TimerIndex++;
					}			
				}
				i++;	
			}
			
			
			// Sleep for 25 ms;
			try {
				this.sleep(25);
			}
			catch (InterruptedException e) {
				e.printStackTrace();	
			}
			
			// Yield to other running process
			this.yield();
			
			// Increment our timer
			ourtimerat += 25;
			
			// If the timer has reached it's limit, reset it to zero, and reset
			// all the character timetonextrun values.back to zero so the cycle
			// starts again.
			if (ourtimerat > 10000) {
				ourtimerat = 0;
				i = 1;
				while (i <= data.ocharacters.getCount()) {
					cc = (character) data.ocharacters.get(i);
					if (cc.TimerInterval > 0 ) {
						cc.TimeToNextRun = 0;
					}
					i++;
				}
			}
		}
		
		// Wipe out all the time to next run values before
		// exiting so when the timer process is started up
		// again, everything works as before.
		i = 1;
		while (i <= data.ocharacters.getCount()) {
			cc = (character) data.ocharacters.get(i);
			cc.TimeToNextRun = 0;
			i++;
		}
	}
	
}