package iageserver;

import java.net.*;
import java.util.*;
import java.io.*;

/**
 *  Main server class - responsible for all server operations.
 */
public class Server {
    
    public serverlisten SL = null;
    public String serverstarted = "";
    public boolean serverispublic = false;
    public int serverport = 1111;
    public String server_regip = "";
    public boolean serverisrunning = false;
    public AdminListen theAdminThread;
    public static String spassword = "password";
    public boolean useGUI = false;
    
    public void parseArgs(String[] args) {
        
        String gamefile = "";
        
        try {
            
            // If we have no arguments, leave
            // the server password as it is
            // and assume they want a gui.
            if (args.length == 0) {
                mainframe frame = new mainframe(this);
            }
            else {
                // Perform a precheck to see if a -nogui flag
                // was set. If it wasn't, load the GUI now.
                int i = 0;
                boolean noGuiFound = false;
                while (i < args.length) {
                    if (args[i].equalsIgnoreCase("-nogui"))
                        noGuiFound = true;
                    i++;
                }
                if (!noGuiFound) {
                    mainframe frame = new mainframe(this);}

                // Parse those args.
                i = 0;
                while (i < args.length) {

                    // Is it a game file? - look
                    // for UNIX or Windows file separators ("\" or "/")
                    if ((args[i].indexOf("/") != -1) || (args[i].indexOf("\\") != -1)) {
                        gamefile = args[i];
                    }

                    // Is it a "-nogui" flag and the user wants
                    // console only mode?
                    if (args[i].equalsIgnoreCase("-nogui")) {
                        vdu.consolemode = true;
                    }

                    // Is it a "-pass" instruction? This should
                    // follow the format "-pass:<password>"
                    if (args[i].toLowerCase().startsWith("-pass:")) {
                        int colpos = args[i].indexOf(":");
                        spassword = args[i].substring(colpos + 1, args[i].length());
                    }

                    // Is it a "-port" instruction? This should
                    // follow the format "-port:<port>"
                    if (args[i].toLowerCase().startsWith("-port:")) {
                        int colpos = args[i].indexOf(":");
                        serverport = Integer.parseInt(args[i].substring(colpos + 1, args[i].length()));
                    }

                    // Is it a "--help" or "-help" instruction? If so,
                    // give the user an explanation of how to use the
                    // command interface and quit.
                    if (args[i].equalsIgnoreCase("--help") || args[i].equalsIgnoreCase("-help")) {
                        // Output version
                        vdu.consolemode = true;
                        vdu.println(data.internalversion);
                        vdu.println();
                        vdu.println();
                        vdu.println("Usage: <java> -jar iageserver.jar [OPTIONS] [IAGE game file]");
                        vdu.println();
                        vdu.println("  --help, -help     Display this help and exit.");
                        vdu.println("  -nogui            Start IAGE server in console only mode.");
                        vdu.println("  -port:<port>      Start IAGE server on the specified TCP port.");
                        vdu.println("  -pass:<password>  Set the server password for remote access.");
                        System.exit(0);
                    }

                    i++;
                }
            }
            
            // If a file was specified, load it and fire up the server
            if (!gamefile.equals("")) {
                startupclass.startup(gamefile);
                // Fire up our server
                startServer();
            }
            
            // Output version
            vdu.println(data.internalversion);
            vdu.println();
            
            // Start the remote admin server going now
            // the program is started up.
            theAdminThread = new AdminListen(this);
            
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
    
    public void startServer() {
        
        if (data.canstartenginenow == true) {
            vdu.println("Starting engine...");
            SL = new serverlisten(serverport);
            
            serverispublic = false;
            serverisrunning = true;
        }
        else {
            vdu.println("Bad data - unable to start server.");
        }
        
    }
    
    public void stopServer() {
        
        SL.stop();
        SL = null;
        
        // Kill every user off
        int i = 1;
        player p = null;
        while (i <= data.oplayers.getCount()) {
            p = (player) data.oplayers.get(i);
            // Tell player
            vdu.Transmit("The server operative stopped the server. You have been disconnected.", p);
            // Stop listening and close their connection
            p.quit(true);
            i++;
        }
        
        // Inform server user it's stopped.
        vdu.println("Server stopped at user request.");
        serverisrunning = false;
        
    }
    
    public void killAdminThread() {
        theAdminThread.killThread();   
    }
    
    public void loadGameFile(String filename) {
        startupclass.startup(new File("").getAbsolutePath() + File.separator + filename);
    }
    
}
