import java.awt.*;
import java.io.*;
import java.util.*;
import java.net.*;
import iageserver.*;


public class iageconnector {

	// Private members
	private String Version = "<b>IAGE ServPlet Version 020416</b>";
	private String CopyrightMessage = "<br>Copyright(c)2000-2002, R.Rawson-Tetley";
	private PreOutput console;
	public Label location;
	private Label score;
	private TextField inputbox;
	public player thisplayer;
	private String playername = "";
	
	public iageconnector (PreOutput ConsoleReference, 
						  Label LocationReference, 
						  Label ScoreReference,  
						  TextField InputReference,
						  String salias) {

	    console = ConsoleReference;
	    location = LocationReference;
	    score = ScoreReference;
	    inputbox = InputReference;
	    playername = salias;
	    
	    // Attach so output from server is forwarded through us.
	    vdu.consoleconnector = this;
	
		// Output our version
		console.Output(Version);
		console.Output(CopyrightMessage);
		
		// Tell the user what is going on
		console.Output("<br><br>The story is loading, please wait...");
		
	}
	
	/** Starts everything up once data is loaded */
	public void Begin() {
	
		// Initialise everything
		InitialiseServer();
	
		// Create our player
		thisplayer = new player();
		
		thisplayer.Score = 0;
        thisplayer.Turns = 0;
        thisplayer.VerboseMode = data.ogame.RepeatDescription;
	    thisplayer.SizeCarried = 0;
	    thisplayer.WeightCarried = 0;
	    thisplayer.ItemsCarried = 0;
	      
   	    // Generate a random location if we have a -1 by
	    // default, otherwise use the starting one in the game.
	    if (data.ogame.StartingLocation == -1) {
	  	    thisplayer.CurrentLocation = data.ogame.getRandomLocation();
	    }
	    else
	    {
	  	    thisplayer.CurrentLocation = data.ogame.StartingLocation;
	    }
	    
	    thisplayer.Index = 1;
	    thisplayer.Name = playername;
	      
  	    // Money and combat
        thisplayer.HitPoints = data.ogame.DefaultHitPoints;
        thisplayer.Money = data.ogame.DefaultMoney;
        thisplayer.DamageIndicator = data.ogame.DefaultDamage;
        thisplayer.ChanceOfHitting = data.ogame.DefaultChanceOfHitting;
	      
  	    // Add player into collection
	    data.oplayers.add(thisplayer);
	    
	    // Enable stuff
		inputbox.setEnabled(true);
		inputbox.setEditable(true);	
		vdu.StopOutput = false;
    
	    processor pr = new processor("setalias " + playername + ".run_on_start", thisplayer);
		
	}


	/** Intialise events */
	public void InitialiseServer() {
		
		try {
			
		  // Run the games initialise event
		  interpreter init = new interpreter(new player(), new parsestring("!,!", new player(), ","));
		  init.runcode(data.ogame.OnInitialise, "Game.OnInitialise");
	
		  // Enumerate all the items and run their initialise code
		  // if they have some
		  int i = 1;
		  item im = null;
		  while (i <= data.oitems.getCount()) {
		  	  im = (item) data.oitems.get(i);
		  	  // Run the code
		      init.runcode(im.OnAction, "Item(" + im.Name + ").OnAction", "initialise", new String[4], 0, "Internal.Initialise", 0, 0);
		  	  i++;
		  }
		  
		  // Same for locations
		  location l = null;
		  i = 1;
		  while (i <= data.olocations.getCount()) {
		  	  l = (location) data.olocations.get(i);
		  	  // Run the code
		      init.runcode(l.OnInput, "Location(" + l.Name + ").OnInput", "initialise", new String[4], 0, "Internal.Initialise", 0, 0);
		  	  i++;
		  }
		  
		  // Same for characters
		  character cc = null;
		  i = 1;
		  while (i <= data.ocharacters.getCount()) {
		  	  cc = (character) data.ocharacters.get(i);
		  	  // Run the code
		      init.runcode(cc.OnAction, "Character(" + cc.Name + ").OnAction", "initialise", new String[4], 0, "Internal.Initialise", 0, 0);
		  	  i++;
		  }
		  
		  // Start the NPC timers off when the server process is started
          // if we are using real-time NPCs.
          if (data.ogame.RealTimeNPCs)
          	data.onpctimer = new npctimer();
		  
	  }
	  catch (Exception e) {
	  	  e.printStackTrace();
	  }
		
	}

	/** Output to screen */
	public void OutputText(String s) {
		console.Output(s);
	}
  
	/** Look for special strings, process them and output them */
	public void PreProcessAndOutput(String s) {
	
		String rs = s; // Latest version of string
		int start;
		int end;
		String firstpart;
		String secondpart;
		String paramvalue;
		String curfindstring;
		boolean hastitle = false;
		String titletext = "";
		final int seplen = 1; // Length of special command separator - at present |<br>
		
	
		// SETSCREEN
		curfindstring = "SETSCREEN: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Manipulate screen
                        
			
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
		
		// TITLE
		curfindstring = "TITLE: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Set the title
			location.setText(paramvalue);
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length());
			rs = firstpart + secondpart;
			
			hastitle = true;
			titletext = secondpart;
		}
				
		// IMAGE
		curfindstring = "IMAGE: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length());
			rs = firstpart + secondpart;
			
		}
		
		
		// MIDI
		curfindstring = "MIDI: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Play MIDI
			try {

				URL img = new URL(paramvalue);

				// Play the tune
                //AudioClip mc = Applet.getAudioClip(img);
                //mc.play();

			}
			catch(MalformedURLException e) {
				OutputText("Bad URL: " + e.getMessage());
			}
            catch(IOException e) {
                    OutputText("Could not use MIDI: " + paramvalue);
            }


			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;

		}

		// MOVIE
		curfindstring = "MOVIE: ";
		if (rs.indexOf(curfindstring) > 0) {

			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);

			// Play Movie


			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
		
		
		// SOUND
		curfindstring = "SOUND: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Play sound
			try {

				URL img = new URL(paramvalue);

				// Play the tune
                //AudioClip so = Applet.getAudioClip(img);
                //so.play();

			}
			catch(MalformedURLException e) {
				OutputText("Bad URL: " + e.getMessage());
			}
            catch(IOException e) {
                OutputText("Could not use sound: " + paramvalue);
            }

			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
		
		// URL
		curfindstring = "URL: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Open browser with URL
			
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
		
		// SCORE
		curfindstring = "SCORE: ";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Set the score
			score.setText(paramvalue);
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
		
		// QUIT THE CLIENT
		curfindstring = "QUIT: DIE";
		if (rs.indexOf(curfindstring) > 0) {
			
			start = rs.indexOf(curfindstring);
			end = rs.indexOf("|", start);
			paramvalue = rs.substring(start + curfindstring.length(), end);
			
			// Kill everything
			this.Kill();
			
			// Remove from text
			firstpart = rs.substring(0, start);
			secondpart = rs.substring(end + seplen, rs.length()); 
			rs = firstpart + secondpart;
			
		}
	
		// If there's anything left, output it
		if (rs.length() > 4) {
			OutputText(rs);
		}
	}
	
	/** Stop the game. */
	public void Kill() {
		inputbox.setEnabled(false);
		inputbox.setEditable(false);	
		vdu.StopOutput = true;
		console.stopThread();	
	}

}
