package iageinteractive;

import java.io.*;

/*** This is the class that actually does all the compiling up of our talk language */
public class importint extends importer {
	
	private iagecode tf = new iagecode();
	private int ci = 1;
	private boolean errorflag = false;
	private String errormsg = "";
	private boolean islibrary = false;
	
	public importint() {
		super();
	}	
	
	public void parse(FileInputStream in) throws Exception {

		// It's much easier to work in memory, so we are going to build an IAGE
		// code collection containing all the file contents.
		
		while (!fileeof) {
			tf.add(readline(in));
		}
	
		// Jump to the start of our compile pass
		startcompile();
	}
	
	
	/*** Main compile routines follow */
	private void startcompile() throws Exception {
		
		try {
			
			if (!islibrary)
				vdu.println("Building " + openfilename + "...");
			
			// FIRST PASS - EMOTIONAL STATES
			ci = 1;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "EmotionalStates ") || checkstart(s, "EmotionalStates\t")) {
					storeemotionalstates(s);
					break;
				}
				ci++;
			}
			
			// SECOND PASS - THREADS
			ci = 1;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "Thread ") || checkstart(s, "Thread\t")) {
					storethread(s);
				}
				ci++;
			}
			
			// THIRD PASS - ROUTERS
			ci = 1;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "TalkRouter ") || checkstart(s, "TalkRouter\t")) {
					storerouter(s);
				}
				ci++;
			}
			
			// FOURTH PASS - CONTEXTS
			ci = 1;
			while (ci <= tf.getCount()) {
				String s = tf.get(ci);
				s = s.trim();
				if (checkstart(s, "Context ") || checkstart(s, "Context\t")) {
					storecontext(s);
				}
				ci++;
			}
			
			// FIFTH PASS - NAME RESOLUTION
			
			int i = 1;
			thread thr = null;
			thread ithr = null;
			context ctx = null;
			talkrouter tr = null;
			
			// 1 - Threads referring to other threads and contexts
			while (i <= data.threads.getCount()) {
				thr = (thread) data.threads.get(i);
				
				// Enumerate thread conditions
				int x = 1;
				threadconditions thc = null;
				while (x <= thr.conditions.getCount()) {
					thc = (threadconditions) thr.conditions.get(x);
					
					// Find the thread with the name referred to and
					// set the ID correctly (if name is not empty)
					if (!thc.followonthreadname.equals("")) {
						int z = 1;
						while (z <= data.threads.getCount()) {
							ithr = (thread) data.threads.get(z);
							if (ithr.Name.equalsIgnoreCase(thc.followonthreadname)) {
								thc.followonthreadid = ithr.ID;
								break;
							}
							z++;
						}	
					}
					
					// Find the context with the name referred to and
					// set the ID correctly (if name is not empty)
					if (!thc.followoncontextname.equals("")) {
						int z = 1;
						while (z <= data.contexts.getCount()) {
							ctx = (context) data.contexts.get(z);
							if (ctx.Name.equalsIgnoreCase(thc.followoncontextname)) {
								thc.followoncontextid = ctx.ID;
								break;
							}
							z++;
						}
					}
					
					
					x++;	
				}
				i++;	
			}
			
			// 2 - Talkrouters referring to threads
			i = 1;
			while (i <= data.talkrouters.getCount()) {
				tr = (talkrouter) data.talkrouters.get(i);
				// Find the thread with the name referred to and
				// set the ID correctly (if name is not empty)
				if (!tr.callsthread.equals("")) {
					int z = 1;
					while (z <= data.threads.getCount()) {
						ithr = (thread) data.threads.get(z);
						if (ithr.Name.equalsIgnoreCase(tr.callsthread)) {
							tr.callsthreadID = ithr.ID;
							break;
						}
						z++;
					}	
				}
				i++;	
			}
			
			// 3 - Context Talkrouters referring to threads
			int y = 1;
			context ct = null;
			while (y <= data.contexts.getCount()) {
				ct = (context) data.contexts.get(y);
				i = 1;
				while (i <= ct.talkrouters.getCount()) {
					tr = (talkrouter) ct.talkrouters.get(i);
					// Find the thread with the name referred to and
					// set the ID correctly (if name is not empty)
					if (!tr.callsthread.equals("")) {
						int z = 1;
						while (z <= data.threads.getCount()) {
							ithr = (thread) data.threads.get(z);
							if (ithr.Name.equalsIgnoreCase(tr.callsthread)) {
								tr.callsthreadID = ithr.ID;
								break;
							}
							z++;
						}	
					}
					i++;	
				}
				y++;
			}
			
			vdu.println(Integer.toString(data.emotionalstates.getCount()) + " emotional states compiled.");
			vdu.println(Integer.toString(data.threads.getCount()) + " threads compiled.");
			vdu.println(Integer.toString(data.talkrouters.getCount()) + " talk routers compiled.");
			vdu.println(Integer.toString(data.contexts.getCount()) + " contexts compiled.");
			
			vdu.println("Process completed.");
		
		}
		catch (Exception e) {
			vdu.println(e.getMessage());
			e.printStackTrace();
			throw new Exception("Errors occurred.");
		}
	}
	
	private void storeemotionalstates(String s) throws Exception {
		
		int esID = 0;
		
		// Move to next (hopefully meaningful) record
		ci++;
		String curline = tf.get(ci);
		
		while (!curline.trim().equals("}")) {
		
			if (!curline.trim().equals("")) {
				// Create an emotional state
				esID++;
				emotionalstate es = new emotionalstate();
				es.ID = esID;
				es.Name = getfirstword(curline);
				
				data.emotionalstates.add(es);
			}
			
			ci++;
			curline = tf.get(ci);
		}
		
	}
	
	private void storethread(String s) throws Exception {
		
		String cl = ""; // Current line
		cl = s.trim();
		
		// Read the thread's name and create our new thread object.
		thread thr = new thread();
		thr.Name = getwithproperty(cl);

		// Assign an ID
		data.nextthread++;
		thr.ID = data.nextthread;
		
		ci++;
		cl = tf.get(ci);
		cl = cl.trim();
		
		while (!cl.startsWith("}")) {
			
			// If there is a [ in it, it is the start of
			// a thread action, which will contain emotional state conditions
			if (cl.indexOf("[") != -1) {
			
				// Create a new thread condition
				threadconditions thc = new threadconditions();
			
				// Read our list of accepted emotional states to fulfil it
				iagecode condlist = splitstring(cl.trim(), " ");
				int i = 1;
				while (i <= condlist.getCount()) {
					// For each one of these, add the ID of that emotional
					// state to the condition.
					String emsname = condlist.get(i);
					// If the string is a [ - break out, we have run out of words
					if (emsname.equals("[")) break;
					
					long emsID = 0;
					// Find the ID of this state
					int z = 1;
					emotionalstate ems = null;
					while (z <= data.emotionalstates.getCount()) {
						ems = (emotionalstate) data.emotionalstates.get(z);
						if (ems.Name.equalsIgnoreCase(emsname)) {
							emsID = ems.ID;
							break;
						}
						z++;
					}
					// Add the emotional state ID on this threadcondition
					thc.emotionalstates.add(new Long(emsID));
					i++;	
				}
				// We must have broken out now because we either ran out of
				// words, or found a [ - we should now look to see if there is
				// another (numeric) word, after this one and if there is, this
				// is the number of times this thread will be valid before the
				// NPC stops saying it.
				i++;
				if (i <= condlist.getCount()) {
					String iterno = condlist.get(i);
					long iter = 0;
					try {
						iter = Long.parseLong(iterno);
					}
					catch(NumberFormatException e) {
						vdu.println("Warning: Invalid thread iterations figure specified (" + iterno + ") at line " + Integer.toString(ci) + " - converted to infinite.");
					}
					thc.iterations = iter;					
				}
				
				// Loop around until we find a ] close symbol - set
				// other thread condition commands accordingly.
				
				while (!cl.startsWith("]")) {

					if (checkstart(cl, "speech")) thc.speech = getwithtextproperty(cl);
					if (checkstart(cl, "action")) thc.action = getwithtextproperty(cl);
					if (checkstart(cl, "setthread")) thc.followonthreadname = getwithproperty(cl);
					if (checkstart(cl, "setcontext")) thc.followoncontextname = getwithproperty(cl);
					if (checkstart(cl, "setemotion")) {
						
									// Find the emotion being set and store it
									String emsname = getwithproperty(cl);
									// Find the ID of this state
									int z = 1;
									emotionalstate ems = null;
									while (z <= data.emotionalstates.getCount()) {
										ems = (emotionalstate) data.emotionalstates.get(z);
										if (ems.Name.equalsIgnoreCase(emsname)) {
											// Set the thread condition to change emotional
											// state.
											thc.emotionchangeid = ems.ID;
											break;
										}
										z++;
									}
								}
					
					ci++;
					cl = tf.get(ci);
					cl = cl.trim();	
				}
				// Attach the condition to the thread
				thr.conditions.add(thc);
			}

			ci++;
			cl = tf.get(ci);
			cl = cl.trim();	
		}
		// Store the thread
		data.threads.add(thr);
		
	}
	
	private void storerouter(String s) throws Exception {
						
		String cl = ""; // Current line
		cl = s.trim();
		
		// Create our new router object.
		talkrouter tr = new talkrouter();
		
		ci++;
		cl = tf.get(ci);
		cl = cl.trim();
		
		while (!cl.startsWith("}")) {
			
			// If we have a words or OR command, it is the start of 
			// a set of ANDed condition words.
			// and a thread to forward to.
			if (checkstart(cl, "Words ") || checkstart(cl, "Or ") 
				|| checkstart(cl, "Words\t") || checkstart(cl, "Or\t")) {
				tr.wordconditions.add(breakintowordcondition(cl));
			}
			
			// If we have a SetThread instruction, mark the thread this
			// router forwards to.
			if (checkstart(cl, "SetThread ") || checkstart(cl, "SetThread\t")) {
				tr.callsthread = getwithproperty(cl);
			}
			
			ci++;
			cl = tf.get(ci);
			cl = cl.trim();
		}
		// Store the router
		data.talkrouters.add(tr);
	}
	
	private void storecontext(String s) throws Exception {
		
		String cl = ""; // Current line
		cl = s.trim();
		
		// Read the context's name and create our new context object.
		context ctx = new context();
		ctx.Name = getwithproperty(cl);
		
		// Assign an ID
		data.nextcontext++;
		ctx.ID = data.nextcontext;
		
		ci++;
		cl = tf.get(ci);
		cl = cl.trim();
		
		while (!cl.startsWith("}")) {
			
			// If there is a [ in it, it is the start of
			// an inline talkrouter
			if (cl.indexOf("[") != -1) {
				
				talkrouter tr = new talkrouter();
				
				// Create a talk router and append it to the context.
				while (!cl.startsWith("]")) {
					
					if (checkstart(cl, "Words ") || checkstart(cl, "Or ") 
						|| checkstart(cl, "Words\t") || checkstart(cl, "Or\t")) {
						tr.wordconditions.add(breakintowordcondition(cl));
					}
					
					// If we have a SetThread instruction, mark the thread this
					// router forwards to.
					if (checkstart(cl, "SetThread ") || checkstart(cl, "SetThread\t")) {
						tr.callsthread = getwithproperty(cl);
					}
					
					ci++;
					cl = tf.get(ci);
					cl = cl.trim();
				}
				
				// Append it into our context's talkrouters
				ctx.talkrouters.add(tr);
				
			}
			ci++;
			cl = tf.get(ci);
			cl = cl.trim();
		}	
		// Store the context
		data.contexts.add(ctx);
	}
	
	/** Accepts a string of speech mark seperated strings, which must be
	    broken down into an iagecollection and return */
	public iagecollection breakintowordcondition(String s) throws Exception {
		
		int curpos = 1;
		int fpos = 0;
		int spos = 0;
		String bustst = "";
		iagecollection retlist = new iagecollection();
		
		fpos = s.indexOf("\"", curpos);
		
		while (fpos != -1) {
		
			// Mark us at the first speech mark
			curpos = fpos;
		
			// Get second speech mark from first pos
			spos = s.indexOf("\"", curpos + 1);	
			
			// Grab the string and stick it in our list
			bustst = s.substring(fpos + 1, spos);
			retlist.add(bustst);
			
			// Set our current position after the last speech mark (if 
			// there is room - if not, quit out)
			if (spos == s.length()) break;
			fpos = spos + 1;
			curpos = fpos;
			
			// Find the next speech mark and carry on
			fpos = s.indexOf("\"", curpos);
		}
		
		// Return our list of words.
		return retlist;
	}
	
	/*** Splits a string and returns an iagecode collection */
	private iagecode splitstring(String tosplit, String delimiter) {
	
		// Break by spaces and fill vwords
		int i = 0;
		int spos = 0;
		iagecode vwords = new iagecode();
		
		i = tosplit.indexOf(delimiter);
		while (i != -1) {
			
			// Add the word
			vwords.add(tosplit.substring(spos, i));
			spos = i + 1;
			i = tosplit.indexOf(delimiter, spos);
			
		}
		
		// Add the final word
		vwords.add(tosplit.substring(spos, tosplit.length()));
		
		// Return them
		return vwords;
		
	}
	
	/*** Returns true if a string starts with the specified one ignoring case*/
	private boolean checkstart(String findin, String find) {
		return findin.toLowerCase().trim().startsWith(find.toLowerCase());
	}
	
	/*** Returns first word of a line */
	private String getfirstword(String findin) throws Exception {
		iagecode broken = splitstring(findin.trim(), " ");
		return broken.get(1);
	}
	
	/*** Returns second argument of a line for numeric with properties */
	private String getwithproperty(String findin) throws Exception {
		
		String s = findin.trim();

		// loop through	the chars of this string, looking for
		// the first space or tab
		int i = 0;
		while (i <= s.length() - 1) {
			if (s.substring(i, i + 1).equals(" ") || s.substring(i, i + 1).equals("\t"))
				break;
			i++;
		}
		
		// We got it - did we run out of string?
		if (i == s.length() -1) {
			throw new Exception("Bad WITH statement at line: " + Integer.toString(ci));
		}
		
		// Strip down to our new position and throw away whitespace
		String trimmed = s.substring(i, s.length());
		trimmed = trimmed.trim();
		
		// Now loop again and find the first space, tab or the end of the string
		i = 0;
		while (i <= trimmed.length() - 1) {
			if (trimmed.substring(i, i + 1).equals(" ") || trimmed.substring(i, i + 1).equals("\t")) {
				break;
			}
			i++;
		}
		// We should now have a valid end marker in I now
		if (i == trimmed.length() - 1) {
			i = trimmed.length();
		}
		return trimmed.substring(0, i);
	}
	
	/*** Returns text with properties in the form Description "desc" */
	private String getwithtextproperty(String findin) throws Exception {
		
		int del1 = findin.indexOf("\"");
		int del2 = findin.indexOf("\"", del1 + 1);
		
		String buff = "";
		
		// if we don't have a second string delimter, then
		// take the string from this line into a buffer
		// and keep on doing it until we have the lot
		
		if (del1 != -1 && del2 == -1) {
			
			buff = findin.substring(del1 + 1, findin.length());
			
			// Throw away space from ends
			buff = buff.trim();
						
			ci++;
			findin = tf.get(ci);
			del1 = findin.indexOf("\"");
			while (del1 == -1) {
			
				// Add to our buffer, adding a space
				// first and removing all whitespace
				buff = buff + " " + findin.trim();
				
				ci++;
				findin = tf.get(ci);
				del1 = findin.indexOf("\"");
				
			}
			
			// Add the end line
			buff = buff + " " + findin.trim();
			
			// Throw away the speech mark from the end
			if (buff.endsWith("\"")) {
				buff = buff.substring(0, buff.length() - 1);
			}
			
			// Replace tildes with speech marks and return
			return vdu.replace(buff, "~", "\"");
		}		
		
		if ((del1 > del2) || del1 == -1 || del2 == -1) {
			throw new Exception("Bad WITH text property at line: " + Integer.toString(ci));
		}
		
		// Build return
		String outputst = findin.substring(del1 + 1, del2);
		
		// Replace tildes with speech marks
		return vdu.replace(outputst, "~", "\"");
	}
}