/**
 * IAGE Client Applet
 * R.Rawson-Tetley, 13/10/2001
 */

import java.awt.*;
import java.awt.event.*;
import java.applet.*;


public class IAGEClientApplet extends Applet {
	
	private iageconnector ic;
	private boolean sentscore = false;
	
	private BorderLayout bl = new BorderLayout();
	private BorderLayout pl = new BorderLayout();
	private BorderLayout pl2 = new BorderLayout();
	private Label title = new Label("Connecting...");
	private Label score = new Label("IAGE Client Applet, Written by R.Rawson-Tetley.");
	private Label status = new Label();
	private Panel header = new Panel();
	private Panel footer = new Panel();
	private Displayer outwindow = new Displayer();
	private TextField inp = new TextField();
	private PreOutput pre = null;
	
	public void init() {
		
		inp.addKeyListener(new java.awt.event.KeyAdapter() {
			public void keyPressed(KeyEvent e) {
    			inp_keyPressed(e);
  			}
		});
		
		//inp.addKeyListener(new ikl(this));
		
		header.setLayout(pl);
		header.add(title, BorderLayout.CENTER);
		header.add(score, BorderLayout.EAST);
		
		footer.setLayout(pl2);
		footer.add(inp, BorderLayout.CENTER);
		footer.add(status, BorderLayout.SOUTH);
		
		this.setLayout(bl);
		this.add(header, BorderLayout.NORTH);
		this.add(outwindow, BorderLayout.CENTER);
		this.add(footer, BorderLayout.SOUTH);

		// Get the host to connect to and default player names
		String codebase = this.getParameter("ServerHost");
		String pname = this.getParameter("DefaultPlayerName");

		// Create preoutputter
		pre = new PreOutput(outwindow, status);
		pre.start();
		
		ic = new iageconnector(pre, title, score, codebase, pname);

	}
	
	public void inp_keyPressed(KeyEvent e) {
		
		  // Tell the displayer so any More prompt can be cleared
  		outwindow.setIsBusy(false);
		
		// If it's enter, transmit the text or connect
		if (e.getKeyCode() == KeyEvent.VK_ENTER) {
			
			// Reset the render count after enter is pressed
	  		outwindow.resetRenderCount();
			
			String s = inp.getText();
			if (s.equals("")) s = " "; // Send a space if no text - makes no odds to parser
			ic.Send(s, false);
			/* Clear user input contents */
			inp.setText("");
			// Allow another score request to be sent
			sentscore = false;
		}
		else
		{
		  // request a score if we haven't done it once since we cycled round
		  //if (!sentscore) {ic.Send("getscore", true); sentscore = true;}
		}
	}
	
	public void killme() {
		ic.Kill();	
	}
	
	public void stop() {
		killme();
	}
	
	public void destroy() {
		killme();
	}

}

/*
class ikl extends java.awt.event.KeyAdapter {
  IAGEClientApplet adaptee;
  ikl(IAGEClientApplet adaptee) {
    this.adaptee = adaptee;
  }
  public void keyPressed(KeyEvent e) {
    adaptee.inp_keyPressed(e);
  }
}*/
