/*
	support.c
	
	Various reimplementations of C library stuff for Palm OS
	
	(NOTE:  Don't use this when compiling with the Palm Simulator, since
	it seems to cause havoc.  Also, you don't need it, since the sim links
	to the standard C libraries.)
*/

#include "palm_ctype.h"
#include "palm_string.h"

int atoi(const char *a)
{
	return StrAToI(a);
}

int printf(char *a, ...)
{
	return 0;
}

int strcspn(char *src, char *sub)
{
	char *index = src+StrLen(src);
	char *test;
	int i;
	
	for (i=0; i<StrLen(sub); i++)
	{
		test = StrChr(src, sub[i]);
		if (test < index) index = test;
	}
	
	return (index - src);	
}

char *strrchr(char *src, char c)
{
	char *search = src;
	char *found = NULL;
	
	if (!src || !c) return NULL;
	
	while ((search = StrChr(search, c)))
	{
		found = search;
		search = found + 1;
	}
	
	return found;
}

char *getenv(char *var)
{
	return "";
}
