# iotest.exe makefile
# for Allegro

TARGET=iotest.exe

# PORT_NAME is for file-naming:
PORT_NAME=alleg
COMPILE=gcc
LINK=gcc

SOURCE_DIR=c:/hugo/source
NONPORTABLE_DIR=c:/hugo/source/gcc

OBJ_EXT=o
NONPORTABLE_OBJS=he$(PORT_NAME).$(OBJ_EXT) hejpeg.$(OBJ_EXT)

WFLAGS=-Wall
OFLAGS=-O3
CFLAGS=-I$(SOURCE_DIR) $(WFLAGS) $(OFLAGS) $(DEFINES) -c

OBJS=iotest.$(OBJ_EXT) stringfn.$(OBJ_EXT) \
$(NONPORTABLE_OBJS)

$(TARGET): $(OBJS)
	$(LINK) -o $(TARGET) $(OBJS)


# Portable sources:

iotest.$(OBJ_EXT): $(SOURCE_DIR)/iotest.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/iotest.c

stringfn.$(OBJ_EXT): $(SOURCE_DIR)/stringfn.c
	$(COMPILE) $(CFLAGS) $(SOURCE_DIR)/stringfn.c


# Non-portable sources:

he$(PORT_NAME).$(OBJ_EXT): $(NONPORTABLE_DIR)/he$(PORT_NAME).c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/he$(PORT_NAME).c

hejpeg.$(OBJ_EXT): $(NONPORTABLE_DIR)/he$(PORT_NAME).c
	$(COMPILE) $(CFLAGS) $(NONPORTABLE_DIR)/hejpeg.c