/*
    DosGlk  --  A Glk implementation for MS-DOS
    Copyright (C) 1998  Matt Kimball

    Permission is hereby granted, free of charge, to any person
    obtaining a copy of this software and associated documentation
    files (the "Software"), to deal in the Software without
    restriction, including without limitation the rights to use, copy,
    modify, merge, publish, distribute, sublicense, and/or sell copies
    of the Software, and to permit persons to whom the Software is
    furnished to do so, subject to the following condition:
 
    THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
    EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
    MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
    NONINFRINGEMENT.  IN NO EVENT SHALL MATT KIMBALL BE LIABLE FOR ANY
    CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF
    CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
    WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/stat.h>

#include "glk.h"
#include "list.h"
#include "file.h"  
#include "event.h"
#include "main.h"

static list *filelist = NULL;
#define getfile(id) (lglk_list_index(filelist, (unsigned)(id) - 1))

fileref *lglk_get_file(frefid_t id) {
	return getfile(id);
}

frefid_t glk_fileref_create_temp(glui32 usage, glui32 rock) {
	int num;
	char name[13];
	struct stat statinfo;
	frefid_t ret;    								  
	fileref *f;
	FILE *tmp;
	             
	do {
		num = rand() & 0xffff;
		sprintf(name, "GLK%d.TMP", num);
	} while(!stat(name, &statinfo));
	if(lglk_add_tmp(num))
		return 0;
	
	tmp = fopen(name, "wb");
	fclose(tmp);
	
	if(filelist == NULL) 
		filelist = lglk_list_create(sizeof(fileref));
	if(filelist == NULL)
		return 0;
		
	ret = (frefid_t)lglk_list_add(filelist);
	if(ret == LGLK_NULL_INDEX)
		return 0;
	ret++;
	f = getfile(ret);
	
	f->rock = rock;
	f->mode = (int)(usage & fileusage_TextMode);
	strcpy(f->name, name);
	
	return ret;	
}

frefid_t glk_fileref_create_by_name(glui32 usage, char *name,
									glui32 rock) {
	frefid_t ret;
	fileref *f;
	
	if(filelist == NULL)
		filelist = lglk_list_create(sizeof(fileref));
	if(filelist == NULL)
		return 0;
		
	ret = (frefid_t)lglk_list_add(filelist);
	if(ret == LGLK_NULL_INDEX)
		return 0;
	ret++;
	f = getfile(ret);
	
	f->rock = rock;
	f->mode = (int)(usage & fileusage_TextMode);
	strncpy(f->name, name, 127);
	
	return ret;
}								

frefid_t glk_fileref_create_by_prompt(glui32 usage, glui32 fmode,
    								  glui32 rock) {
	frefid_t ret;    								  
	fileref *f;
    								  
	if(filelist == NULL) 
		filelist = lglk_list_create(sizeof(fileref));
	if(filelist == NULL)
		return 0;
		
	ret = (frefid_t)lglk_list_add(filelist);
	if(ret == LGLK_NULL_INDEX)
		return 0;
	ret++;
	f = getfile(ret);
	
	f->rock = rock;
	f->mode = (int)(usage & fileusage_TextMode);
	strcpy(f->name, "");
			
	lglk_event_getline("Enter filename: ", f->name, 127);
	
	return ret;
}
    								 
void glk_fileref_destroy(frefid_t fref) {
	fileref *f;
	
	f = getfile(fref);
	if(f == NULL)
		return;
		
	lglk_list_remove(filelist, (unsigned)fref - 1);
}

frefid_t glk_fileref_iterate(frefid_t id, glui32 *rockptr) {
	fileref *f;

	while((unsigned)id <= lglk_list_size(filelist)) {
		f = getfile(++id);
		if(f) {
			if(rockptr)
				*rockptr = f->rock;
			return id;
		}
	}
	return 0;
}

glui32 glk_fileref_get_rock(frefid_t fref) {
	fileref *f;
	
	f = getfile(fref);
	if(f == NULL)
		return 0;
		
	return f->rock;
}

void glk_fileref_delete_file(frefid_t fref) {
	fileref *f;
	
	f = getfile(fref);
	if(f == NULL)
		return;

	unlink(f->name);
}

glui32 glk_fileref_does_file_exist(frefid_t fref) {			
	struct stat statbuf;
	fileref *f;
	
	f = getfile(fref);
	if(f == NULL)
		return 0;
	
	if(stat(f->name, &statbuf))
		return 0;
	else 
		return 1;
}
