------------------------ HUGO.SPC ------------------------
# HUGO LANGUAGE SPECIFICATION FILE FOR CRIMSON EDITOR

$CASESENSITIVE=NO
$DELIMITERS=~`!@$%&*()-+=|\{}[]:;"',.<>/?#
$KEYWORDPREFIX=# $
#$VARIABLEPREFIX=$ #
#$SPECIALVARIABLECHARS=*#'`!$@%
# $HEXADECIMALMARK=# - this disables line comment2 delimeter
# $ESCAPECHAR= - not used (breaks multi-line comments)
$QUOTATIONMARK1="
$QUOTATIONMARK2='
$QUOTATIONMARKRANGE=!RANGE1
$LINECOMMENT=!
#$LINECOMMENT2=
# $LINECOMMENTONFIRSTPOSITION= - not used
#$LINECOMMENTRANGE=RANGE1
$BLOCKCOMMENTON=!\
$BLOCKCOMMENTOFF=\!
# $BLOCKCOMMENT2ON= - not used
# $BLOCKCOMMENT2OFF= - not used
$BLOCKCOMMENTRANGE=!RANGE1
$RANGE1BEG=\"
$RANGE1END=\"
#$RANGE2BEG=<
#$RANGE2END=>
# COMMENT THESE NEXT LINES OUT IF YOU DO NOT WANT AUTO-INDENT
$INDENTATIONON={
$INDENTATIONOFF=}
$PAIRS1=()
$PAIRS2={}
#$PAIRS3={}
$MULTILINESTRINGCONSTANT=YES
---------------------------------------------------------


COMMENT: As you have noticed already, any line begins with '#' is regarded as
comment (actually any line that does not begin with '$' will be ignored).

CASESENSITIVE: Flag indicating if this programming language distinguishs
between upper case characters and lower case characters. This information will
be used to determine if a word is a reserved word or not.

DELIMITERS: Delimiters used in this programming language. Any set of characters
not belong to delimiters can be a reserved word or a variable. White spaces 
(' ', '\t', '\r', '\n') do not need to be declared as delimiters explicitly. 
White spaces are regarded as delimiters by default. This information is quite 
important to analyze the syntax of a document, Crimson Editor could behave in 
strange way if this information is not set properly. 

KEYWORDPREFIX: In some programming languages, there are delimiters that have
special meaning. For example, '#include' in C language is a preprocessor 
command and should be regarded as reserved word. However, '#' is a delimiter in 
C language, we cannot highlight '#include' as reserved word in normal way.
So comes the need for KEYWORDPREFIX. Delimiters in KEYWORDPREFIX can be front 
part of reserved word. In this example, '&' is indicated as KEYWORDPREFIX 
because there are special codes in HTML like ' ', '>' and '<'.

VARIABLEPREFIX: In some programming languages, variable name should begin with
special delimiter. For example, variables in Perl should be prefixed with '$'.
This means that any identifier prefixed with '$' is a variable.

SPECIALVARIABLECHARS: In Perl, '$#', '$!' and '$$var' are also variables. The 
difference between normal variable name and special variable name is that 
special variable name can consist of delimiters. Delimiters in 
SPECIALVARIABLECHARS can be used to consist variable name and will be 
highlighted in Crimson Editor properly. SPECIALVARIABLECHARS is used only when 
VARIABLEPREFIX is set.

HEXADECIMALMARK: Hexa decimal numbers consist of numbers and characters between 
'A' and 'F'. Usually, programming languages use special marks to distinguish 
hexa decimal numbers from decimal numbers or from identifiers. For example, 
'0x0F3E' is a hexa decimal number in C language, while '#3E4F6A' is a hexa 
decimal number in HTML.

ESCAPECHAR: Escape character in strings. For example, a chracter string like 
"She said \"Hello world\".\n" will not be highlighted properly if we do not set 
'\' as an escape character. Backslash ('\') is used as an escape character in 
most programming languages.

QUOTATIONMARK1, QUOTATIONMARK2: Quotation mark character. These characters must 
be one of DELIMITERS. A character string enclosed with quotation marks is 
considered as constant string in Crimson Editor.

QUOTATIONMARKRANGE: Effective range of quotation mark character. Possible range 
should be one of the predefined range constant.
GLOBAL, RANGE1, RANGE2, !RNGE1, !RNGE2, !R1&R2, R1||R2

LINECOMMENT, LINECOMMENT2, LINECOMMENTONFIRSTPOSITION: Marks indicating 
beginning of line comment to the end of a line. LINECOMMENTONFIRSTPOSITION has
effect only if the line comment delimiter is positioned at column number 1.

BLOCKCOMMENTON, BLOCKCOMMENTOFF, BLOCKCOMMENT2ON, BLOCKCOMMENT2OFF: Marks 
indicating beginning and end of block comment.

LINECOMMENTRANGE, BLOCKCOMMENTRANGE: Effective range of comment delimiters. 
Possible range should be one of the predefined range constant.
GLOBAL, RANGE1, RANGE2, !RNGE1, !RNGE2, !R1&R2, R1||R2

SHADOWON, SHADOWOFF: Marks indicating beginning and end of shadowed text. 
(Shadowed text was designed for HTML comment in ASP, JSP, and PHP documents.)

HIGHLIGHTON, HIGHLIGHTOFF: Marks indicating beginning and end of highlighted 
text. (Highlighted text was designed for XML document to highlight all the
string between brackets)

RANGE1BEG, RANGE1END, RANGE2BEG, RANGE2END: Marks indicating beginning and 
end of ranges. Ranges are used to limit keyword effective range. In this PHP 
example, '<?' and '?>' indicate beginning and end of PHP code block. And, '<' 
and '>' indicate beginning and end of HTML tags. RANGE1 delimiters are always 
checked prior to RANGE2 delimiters.

$INDENTATIONON, $INDENTATIONOFF: Auto indentation character. '{' and '}' works 
in almost programming languages. These characters should be declared as
DELIMITERS.

$PAIRS1, $PAIRS2, $PAIRS3: Pairs to be examined for pairs highlighting feature. 
The order of pairs is important. First character should be a openning bracket, 
and the second one should be a closing bracket. These characters should be 
declared as DELIMITERS.

