{ ------------------------------------------------------------------------- }
{ ------------------- UNIDAD DE PCX -> Para cargarlos --------------------- }
{ ----------------------- Alberto Salazar Palomo -------------------------- }
{ ----------------------- (C) Navigator Soft 1997 ------------------------- }
{ ------------------------------------------------------------------------- }

unit pcx;


INTERFACE

Var PcxScr : Pointer;

Procedure SetPcx256;
Procedure SetPcx16;
Procedure LoadPcx256(Pfilename: String;Black,Fade:Boolean; Pseg:Pointer);
Function  LoadPcx256FromFile(Var PcxFile:File; Pseg:Pointer):LongInt;
Procedure LoadPcx16(Pfilename:String;Black,Fade:Boolean);

Implementation

uses Paletas,crt;

Const   BuffSize = 10240;   { Buffer Maximo de Carga Pcx }
Var     scratch: pointer;
        repeatcount: byte;
        datalength: word;
        video_index: word;
        file_error: boolean;
        Page_Addr:Word;

var     entry, gun, pcxcode: byte;
        palbuf: array[0..66] of byte;
        pcxfile: file;
        bytes_per_line: word;
        columncount, plane:Word;


procedure SetPcx256;
          Begin
               Asm

                  Mov Ah,0
                  Mov Al,13h
                  Int 10h
                  Cld
               End;

               DirectVideo:=False;
          End;

procedure SetPcx16;
          Begin
               Asm
                  Mov Ah,0
                  Mov Al,12h
                  Int 10h
                  Cld
               End;

               DirectVideo:=False;

               Asm
                  Mov Ax,1013h
                  Mov Bx,0100h
                  Int 10h

                  Mov Cx,15
               @L:                  {Define la correspondencia}
                  Mov Ax,1000h      {entre los colores de la  }
                  Mov Bh,Cl         {paleta}
                  Mov Bl,Cl
                  Int 10h
               Loop @L
               End;
          End;


Procedure DECODE_PCX256; assembler;

          (* Registers used:

          AL   data byte to be written to video
          BX   end of input buffer
          CL   number of times data byte is to be written
          ES   output segment
          DI   index into output buffer
          DS   segment of input buffer
          SI   index into input buffer
          *)

          asm
             mov     es, page_addr       { video segment }
             mov     di, video_index     { index into video }
             xor     cx, cx              { clean up loop counter }
             mov     cl, repeatcount     { count in CL }
             mov     bx, datalength      { end of input buffer }
             push    ds                  { save DS }
             lds     si, scratch         { pointer to input in DS:SI }
             add     bx, si              { adjust datalength - SI may not be 0 }
             cld                         { clear DF }
             cmp     cl, 0               { was last byte a count? }
             jne     @multi_data         { yes, so next is data }

             { --------------------- Loop through input buffer ----------------------- }

          @getbyte:                   { last byte was not a count }
             cmp     si, bx              { end of input buffer? }
             je      @exit               { yes, quit }
             lodsb                       { get byte into AL, increment SI }
             cmp     al, 192             { test high bits }
             jb      @one_data           { not set, not a count }
             { It's a count byte }
             xor     al, 192             { get count from 6 low bits }
             mov     cl, al              { store repeat count }
             cmp     si, bx              { end of input buffer? }
             je      @exit               { yes, quit }
          @multi_data:
             lodsb                       { get byte into AL, increment SI }
             rep     stosb               { write byte CX times }
             jmp     @getbyte
          @one_data:
             stosb                       { byte into video }
             jmp     @getbyte

             { ------------------------- Finished with buffer ------------------------ }

          @exit:
             pop     ds                  { restore Turbo's data segment }
             mov     video_index, di     { save status for next run thru buffer }
             mov     repeatcount, cl

          end;

procedure LoadPCX256;

var     x:Byte;
        pcxfile: file;
        palette_start, total_read: longint;
        palette_flag: byte;
        version: word;

procedure CLEANUP;
          begin
               close(pcxfile);
               freemem(scratch, buffsize);
          end;

Begin    { READ_PCX256 }

     Page_Addr:=Seg(PSeg^);

     If Black Then BlackPal;

     assign(pcxfile, pfilename);
     {$I-} reset(pcxfile, 1);  {$I+}
     file_error:= (IOresult <> 0);
     if file_error then exit;
     getmem(scratch, buffsize);                  { Allocate scratchpad }
     blockread(pcxfile, version, 2);             { Read first two bytes }
     file_error:= (hi(version) < 5);             { No palette info. }
     if file_error then
     begin
          cleanup; exit;
     end;
     palette_start:= filesize(pcxfile) - 769;

     seek(pcxfile, 128);                        { Scrap file header }
     total_read:= 128;

     repeatcount:= 0;                  { Initialize assembler vars. }
     video_index:= Ofs(Pseg^);

     repeat
           blockread(pcxfile, scratch^, buffsize, datalength);
           inc(total_read, datalength);
           if (total_read > palette_start) then
              dec(datalength, total_read - palette_start);
           decode_pcx256;
     until (eof(pcxfile)) or (total_read>= palette_start);

(* The last 769 btes of the file are palette information, starting with a
   one-byte flag. Each group of three bytes represents the RGB values of
   one of the color registers. The values have to be divided by 4 to be
   brought within the range 0-63 expected by the registers. *)

   seek(pcxfile, palette_start);
   blockread(pcxfile, palette_flag, 1);
   file_error:= (palette_flag <> 12);
   if file_error then
   begin
        cleanup;
        exit;
   end;

   blockread(pcxfile, RGB256, 768);         { Get palette info. }
   for x:= 0 to 255 do
   with RGB256[x] do
   begin
        red:= red shr 2;
        green:= green shr 2;
        blue:= blue shr 2;
   end;
   cleanup;
   If Fade Then ArrayPal(RGB256);

end;  { READ_PCX256 }

Function  LoadPCX256FromFile;
          {Se ha incluido en la cabecera del fichero PCX, la longitud de este}
var     x:Byte;
        palette_start, total_read,Inicial: longint;
        Longitud:Longint;
        palette_flag: byte;
        version: word;

Begin    { READ_PCX256 FROM FILE }

     Page_Addr:=Seg(PSeg^);
     BlockRead(PcxFile,Longitud,4);             {Lee la longitud del Pcx}
     Inicial:=FilePos(PcxFile);

     getmem(scratch, buffsize);                  { Allocate scratchpad }
     blockread(pcxfile, version, 2);             { Read first two bytes }
     file_error:= (hi(version) < 5);             { No palette info. }
if not file_error then
Begin
        palette_start:= Inicial+Longitud - 769;

     seek(pcxfile, Inicial+128);                 { Scrap file header }
     total_read:= Inicial+128;

     repeatcount:= 0;                  { Initialize assembler vars. }
     video_index:= Ofs(Pseg^);

     repeat
           blockread(pcxfile, scratch^, buffsize, datalength);
           inc(total_read, datalength);
           if (total_read > palette_start) then
              dec(datalength, total_read - palette_start);
           decode_pcx256;
     until (total_read>= palette_start);

(* The last 769 btes of the file are palette information, starting with a
   one-byte flag. Each group of three bytes represents the RGB values of
   one of the color registers. The values have to be divided by 4 to be
   brought within the range 0-63 expected by the registers. *)

   seek(pcxfile, palette_start);
   blockread(pcxfile, palette_flag, 1);
   file_error:= (palette_flag <> 12);
   if not file_error then
   Begin
    blockread(pcxfile, RGB256, 768);         { Get palette info. }
    for x:= 0 to 255 do
    with RGB256[x] do
    begin
        red:= red shr 2;
        green:= green shr 2;
        blue:= blue shr 2;
    end;
   end;
End;
   freemem(scratch, buffsize);
   LoadPcx256FromFile:=FilePos(PcxFile);

end;  { READ_PCX256 FROM FILE}

{ ---------------------------------------- PCX 16 Colores ----------- }

Procedure LoadPcx16(Pfilename:String;Black,Fade:Boolean);


procedure DECODE_16; assembler;

asm

(* Registers used:

   AL   data byte to be written to video
   AH   data bytes per scan line
   BX   end of input buffer
   CL   number of times data byte is to be written
   DL   current column in scan line
   ES   output segment
   DI   index into output buffer
   DS   segment of input buffer
   SI   index into input buffer
   BP   current color plane
*)

push    bp

{ ----------------- Assembler procedure for 16-color files -------------- }

{ The first section is initialization done on each run through the
  input buffer. }

@startproc:
mov     bp, plane           { plane in BP }
mov     es, page_addr       { video display segment }
mov     di, video_index     { index into video segment }
mov     ah, byte ptr bytes_per_line  { line length in AH }
mov     dx, columncount     { column counter }
mov     bx, datalength      { no. of bytes to read }
xor     cx, cx              { clean up CX for loop counter }
mov     cl, repeatcount     { count in CX }
push    ds                  { save DS }
lds     si, scratch         { input buffer pointer in DS:SI }
 { We have to adjust datalength for comparison with SI. TP 6.0 pointers are
   normalized, but the offset can still be 0 or 8. }
add     bx, si
cld                         { clear DF for stosb }
cmp     cl, 0               { was last byte a count? }
jne     @multi_data         { yes, so next is data }
jmp     @getbyte            { no, so find out what next is }

{ -------------- Procedure to write EGA/VGA image to video -------------- }

@writebyte:
stosb                       { AL into ES:DI, inc DI }
inc     dl                  { increment column }
cmp     dl, ah              { reached end of scanline? }
je      @doneline           { yes }
loop    @writebyte          { no, do another }
jmp     @getbyte            {   or get more data }
@doneline:
shl     bp, 1               { shift to next plane }
cmp     bp, 8               { done 4 planes? }
jle     @setindex           { no }
mov     bp, 1               { yes, reset plane to 1 but don't reset index }
jmp     @setplane
@setindex:
sub     di, dx              { reset to start of line }
@setplane:
push    ax                  { save AX }
cli                         { no interrupts }
mov     ax, bp              { plane is 1, 2, 4, or 8 }
mov     dx, 3C5h            { sequencer data register }
out     dx, al              { mask out 3 planes }
sti                         { enable interrupts }
pop     ax                  { restore AX }
xor     dx, dx              { reset column count }
loop    @writebyte          { do it again, or fetch more data }

{ -------------------- Loop through input buffer ------------------------ }

{ Here's how the data compression system works. Each byte is either image
  data or a count byte that tells how often the next byte is to be
  repeated. The byte is image data if it follows a count byte, or if
  either of the top 2 bits is clear. Otherwise it is a count byte, with
  the count derived from the lower 6 bits. }

@getbyte:                   { last byte was not a count }
cmp     si, bx              { end of input buffer? }
je      @exit               { yes, quit }
lodsb                       { get a byte from DS:SI into AL, increment SI }
cmp     al, 192             { test high bits }
jb      @one_data           { not set, it's data to be written once }
 { It's a count byte: }
xor     al, 192             { get count from 6 low bits }
mov     cl, al              { store repeat count }
cmp     si, bx              { end of input buffer? }
je      @exit               { yes, quit }
@multi_data:
lodsb                       { get data byte }
jmp     @writebyte          { write it CL times }
@one_data:
mov     cl, 1               { write byte once }
jmp     @writebyte

{ ---------------------- Finished with buffer --------------------------- }

@exit:
pop     ds                  { restore Turbo's data segment }
mov     plane, bp           { save status for next run thru buffer }
mov     repeatcount, cl
mov     columncount, dx
mov     video_index, di
pop     bp
end;  { asm }

begin   { READ_PCX_FILE }

If Black then BlackPal;

Page_Addr:=Seg(PcxScr^);
assign(pcxfile, pfilename);
 reset(pcxfile, 1);
file_error:= (IOresult <> 0);
if file_error then exit;

getmem(scratch, buffsize);                 { Allocate scratchpad }
blockread(pcxfile, scratch^, 128);         { Get header into scratchpad }

move(scratch^, palbuf, 67);
bytes_per_line:= palbuf[66];
{----------------------- Setup for EGA/VGA ------------------------------}

  video_index:= Ofs(PcxScr^);
  port[$3C4]:= 2;           { Index to map mask register }
  plane:= 1;                { Initialize plane }
  port[$3C5]:= plane;       { Set sequencer to mask out other planes }


  for entry:= 0 to 15 do
  begin
       for gun:= 0 to 2 do
       begin
        pcxcode:= palbuf[16 + entry * 3 + gun];   { Get primary color value }
        case gun of
          0: RGB256[Entry].red:= pcxcode Shr 2;
          1: RGB256[Entry].green:= pcxcode Shr 2;
          2: RGB256[Entry].blue:= pcxcode Shr 2;
        end;
       end;
  end;  { gun }


{ ---------------- Read and decode the image data ----------------------- }

repeatcount:= 0;                        { Initialize assembler vars. }
columncount:= 0;
repeat
  blockread(pcxfile, scratch^, buffsize, datalength);
  decode_16;   { Call assembler routine }
until eof(pcxfile);
close(pcxfile);
Port[$3C5]:= $F;                        { Reset mask map }
freemem(scratch,buffsize);              { Discard scratchpad }

If Fade Then ArrayPal(RGB256);

end;  { READ_PCX_FILE }


Begin
     PcxScr:=Ptr($a000,0000);
End.