/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import mdh.aiee.Adventure;
import mdh.aiee.Command;
import mdh.aiee.Item;
import mdh.aiee.Player;
import mdh.aiee.Thing;

public abstract class Stuff
implements Serializable {
    private static HashMap CLASSNAMES_ = new HashMap();
    private String id_;
    private String name_;
    private ArrayList contents_;
    private int points_;
    private boolean light_;
    private Command look_;
    private Command turn_;

    public Stuff(String id, String name) {
        this.id_ = id;
        this.name_ = name;
    }

    public void addContents(Thing th) {
        Thing it;
        int i;
        if (this.contents_ == null) {
            this.contents_ = new ArrayList(1);
        }
        String name = th.getName();
        int len = this.contents_.size();
        for (i = 0; i < len && name.compareTo((it = this.findContents(i)).getName()) >= 0; ++i) {
        }
        this.contents_.add(i, th.id());
        th.setLoc(this.id_);
    }

    public void broadcast(String s) {
        int len = this.contents_.size();
        for (int i = 0; i < len; ++i) {
            Thing it = this.findContents(i);
            if (!(it instanceof Player)) continue;
            Adventure.getAdv().println(s);
        }
    }

    public Thing containsThing(String findid) {
        Adventure adv = Adventure.getAdv();
        int len = this.countContents();
        for (int i = 0; i < len; ++i) {
            Thing th = this.findContents(i);
            if (th.id().equals(findid)) {
                return th;
            }
            if (this.isClosed() || (th = th.containsThing(findid)) == null) continue;
            return th;
        }
        return null;
    }

    public boolean containsLight() {
        if (Adventure.getAdv().getDebug()) {
            System.err.println(this.id() + "[light=" + this.light_ + "].containsLight():");
        }
        if (this.light_) {
            if (Adventure.getAdv().getDebug()) {
                System.err.println("    true");
            }
            return true;
        }
        if (!this.isClosed()) {
            int len = this.countContents();
            for (int i = 0; i < len; ++i) {
                Thing th = this.findContents(i);
                if (!th.containsLight()) continue;
                if (Adventure.getAdv().getDebug()) {
                    System.err.println("    true: " + th);
                }
                return true;
            }
        }
        if (Adventure.getAdv().getDebug()) {
            System.err.println("    false");
        }
        return false;
    }

    public int countContents() {
        return this.contents_ == null ? 0 : this.contents_.size();
    }

    public boolean equalsName(String s) {
        if (s == null) {
            return false;
        }
        return this.name_.equalsIgnoreCase(s);
    }

    public Thing findContents(int i) {
        String thid = this.getContents(i);
        return (Thing)Adventure.getAdv().getStuff(thid);
    }

    public String getContents(int i) {
        return (String)this.contents_.get(i);
    }

    public boolean getLight() {
        return this.light_;
    }

    public Command getLook() {
        return this.look_;
    }

    public String getName() {
        return this.name_;
    }

    public int getPoints() {
        return this.points_;
    }

    public Command getTurn() {
        return this.turn_;
    }

    public String id() {
        return this.id_;
    }

    public boolean isClosed() {
        return false;
    }

    public String listContents(String prefix) {
        return this.listContents(prefix, false);
    }

    public String listContents(String prefix, boolean showInvisible) {
        StringBuffer sb = null;
        int len = this.countContents();
        ArrayList<Thing> contents = new ArrayList<Thing>(len);
        for (int i = 0; i < len; ++i) {
            Thing th = this.findContents(i);
            if (!showInvisible && !th.getVisible()) continue;
            contents.add(th);
        }
        int count = contents.size();
        int n = 0;
        for (int i = 0; i < count; ++i) {
            String s;
            Thing th = (Thing)contents.get(i);
            if (th == null) continue;
            if (++n == 1) {
                sb = new StringBuffer(80);
                sb.append(prefix);
            } else if (count == 2) {
                sb.append(" and ");
            } else if (n < count) {
                sb.append(", ");
            } else {
                sb.append(", and ");
            }
            sb.append(th.aName());
            if (th.getLight()) {
                sb.append(" (lit)");
            }
            if (!(th instanceof Item)) continue;
            Item it = (Item)th;
            if (it.getIsReady()) {
                sb.append(" (ready)");
            }
            if (it.getCloseable()) {
                if (it.getClosed()) {
                    sb.append(" (closed)");
                } else {
                    sb.append(" (open)");
                }
            }
            if (it.countContents() <= 0 || it.getCloseable() && it.getClosed() || (s = it.listContents(" (containing: ", showInvisible)) == null) continue;
            sb.append(s).append(')');
        }
        if (n > 0) {
            sb.append('.');
            return sb.substring(0);
        }
        return null;
    }

    public boolean matchesName(String s) {
        if (s == null) {
            return false;
        }
        int slen = s.length();
        if (slen == 0) {
            return false;
        }
        return this.name_.regionMatches(true, 0, s, 0, slen);
    }

    public boolean removeContents(Thing th) {
        if (this.contents_ == null) {
            return false;
        }
        boolean rc = this.contents_.remove(th.id());
        if (rc) {
            th.setLoc(null);
        }
        return rc;
    }

    public void setLight(boolean li) {
        this.light_ = li;
    }

    public void setLook(Command look) {
        this.look_ = look;
    }

    public void setPoints(int p) {
        this.points_ = p;
    }

    public void setTurn(Command t) {
        this.turn_ = t;
        Adventure.getAdv().addDaemon(this);
    }

    public int weighContents() {
        int weight = 0;
        int len = this.countContents();
        for (int i = 0; i < len; ++i) {
            Thing th = this.findContents(i);
            weight += th.weighTotal();
        }
        return weight;
    }

    public int weighTotal() {
        return this.weighContents();
    }

    public final String toString() {
        Class<?> cl = this.getClass();
        String classname = (String)CLASSNAMES_.get(cl);
        if (classname == null) {
            classname = cl.getName();
            int lastdot = classname.lastIndexOf(46);
            if (lastdot >= 0) {
                classname = classname.substring(lastdot + 1);
            }
            CLASSNAMES_.put(cl, classname);
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append('[').append(classname);
        sb.append(" id=").append(this.id_);
        sb.append(" name=\"").append(this.name_).append('\"');
        if (!this.light_) {
            sb.append(" dark");
        }
        if (this.contents_ != null) {
            sb.append("\n contents=").append(this.contents_);
        }
        this.toString2(sb);
        if (this.look_ != null) {
            sb.append('\n').append(this.look_);
        }
        if (this.turn_ != null) {
            sb.append('\n').append(this.turn_);
        }
        sb.append(']');
        return sb.substring(0);
    }

    protected abstract void toString2(StringBuffer var1);
}

