/*
 * Decompiled with CFR 0.152.
 */
package mdh.aiee;

import mdh.aiee.Adventure;
import mdh.aiee.Command;
import mdh.aiee.Item;
import mdh.aiee.Thing;

public abstract class Entity
extends Thing {
    private int hits_ = 10;
    private int maxHits_ = 10;
    private Command die_;

    public Entity(String id, String name) {
        super(id, name);
    }

    public int computeArmor(char attackElement) {
        int armor = 0;
        int len = this.countContents();
        for (int i = 0; i < len; ++i) {
            Item it;
            Thing th = this.findContents(i);
            if (!(th instanceof Item) || !(it = (Item)th).getIsReady()) continue;
            String aelems = it.getElements();
            int arm = it.getArmor();
            if (aelems.indexOf(attackElement) >= 0) {
                armor += arm;
                continue;
            }
            armor += arm / 4;
        }
        return armor;
    }

    public void die() {
        int rc;
        if (this.die_ != null && (rc = this.die_.doEval(Adventure.getAdv(), this)) == 2) {
            return;
        }
        this.dieDefault();
    }

    public abstract void dieDefault();

    public Item findEquipped(String type) {
        int len = this.countContents();
        for (int i = 0; i < len; ++i) {
            Item it;
            Thing th = this.findContents(i);
            if (!(th instanceof Item) || !(it = (Item)th).getIsReady() || !type.equals(it.getReadyType())) continue;
            return it;
        }
        return null;
    }

    public void hurt() {
    }

    public int doReady(Item what) {
        if (what.getReady() == null) {
            return 3;
        }
        Item it = this.findEquipped(what.getReadyType());
        if (it != null) {
            return 3;
        }
        int rc = what.getReady().doEval(Adventure.getAdv(), what);
        if (rc == 2) {
            return rc;
        }
        what.setIsReady(true);
        return 1;
    }

    public Command getDie() {
        return this.die_;
    }

    public int getHits() {
        return this.hits_;
    }

    public int getMaxHits() {
        return this.maxHits_;
    }

    public boolean removeContents(Thing th) {
        boolean rc = super.removeContents(th);
        if (rc && th instanceof Item) {
            Item it = (Item)th;
            it.setIsReady(false);
        }
        return rc;
    }

    public void setDie(Command d) {
        this.die_ = d;
    }

    public void setHits(int d) {
        this.hits_ = d;
    }

    public void setMaxHits(int m) {
        this.maxHits_ = m;
    }

    public abstract void announceDamage(int var1);

    public boolean takeDamage(int d, char element) {
        if (d > 0 && (d -= this.computeArmor(element)) < 0) {
            d = 0;
        }
        this.hits_ -= d;
        this.announceDamage(d);
        if (this.hits_ <= 0) {
            this.die();
            return true;
        }
        if (this.hits_ > this.maxHits_) {
            this.hits_ = this.maxHits_;
        }
        if (d > 0) {
            this.hurt();
        }
        return false;
    }

    protected void toString2(StringBuffer sb) {
        sb.append(" hits=\"").append(this.maxHits_).append('\"');
        super.toString2(sb);
        if (this.die_ != null) {
            sb.append('\n').append(this.die_);
        }
    }
}

