! move_npc2.inc : Moves npcs from room to room depending on the time
!
! Version 2.0
! 
! This file is in the public domain.
!
! To use this file, place "#include move_npc2.inc" near the beginning
!   of your game, but after #include stdlib.inc"
!
!
! To conserve memory (and time) you may wish to eliminate some of the 
! time props.
!
! Basically, every creature has 48 different properties which are set to
! the location she or he is at at a given time. [000] is Midnight, [230]
! is 2:30 am, [1200] is noon, [1930] is 7:30 pm and so on. 
!
! When the time arrives, the creature will be move to that location.
!
! Works best when the time step is set to 2 minutes or so
!
! Creatures that are group members aren't moved, nor are they moved if
! you turn on the object flag [DontTimeMove]
! 
!
! This verson improves the time move a bit (not much), and adds two more
! forms of movement, the second related to the 1st. 
!
! The improvement is in how the creature leaves or enters the room. By add 2 creature
! properties which hold dummy nouns which describe the creature leaving and entering,
! you can now describe how (and who) enters or leaves a room
!
!
!    [EnterDescr] - Should contain a dummy noun describing how the creature enters
!    [LeaveDescr] - Should contain a dummy noun describing how the creature leaves
! 
!  For instance, you creat a noun, and in the description, you say something like
!  "Fred walks away" or "Fred walks towards you".
! 
! It's sort of a pain, but you can't point a Noun property to a message or string. 
!
! The First Added movement type is 'Route Move', you assign a route to a creature,
! and he  or she will move along it back and forth
!
! The second is 'Random Route Move', it's like the first, only a creature
! will wander randomly along the route
!
! Routes are assigned by a number of properties, [Route0] to [Route9]
!
! Staring from [Route0], assign each value to the room you want the creature
! to move through.  [Route0] FirstRoom, [Route1] Second Room, etc
!
! Which move method used depends on which flag is set, either [RouteMove]
! or [RandomRouteMove]
! 
! All of these can be set either when describing the creature originally,
! or changed during runtime.

subroutines
[npc time move]
[Update Route]
[Npc Route Move]
[Random Route]
end_subroutines

Variable [RouteTemp]



OBJFLAG CREATURE
[DontTimeMove]
[TimeMove]
[RouteMove]
[MoveBack]
[RandomRouteMove]
END_OBJFLAG



PROP CREATURE
[000]
[030] 
[100]  
[130]
[200]
[230]
[300]
[330] 
[400]  
[430]
[500]
[530]
[600]
[630] 
[700]  
[730]
[800]
[830]
[900]
[930] 
[1000]  
[1030]
[1100]
[1130]
[1200]
[1230]
[1300]
[1330] 
[1400]  
[1430]
[1500]
[1530]
[1600]
[1630] 
[1700]  
[1730]
[1800]
[1830]
[1900]
[1930] 
[2000]
[2030]
[2100]
[2130]
[2200]
[2230]
[2300]
[2330]
[EnterDescr]
[LeaveDescr]
[Route]
[OldRoute]
[MoveTo]
[Route1]
[Route2]
[Route3]
[Route4]
[Route5]
[Route6]
[Route7]
[Route8]
[Route9]
[Route0]
END_PROP

! There's probably a shorter way of doing this, but...

COMMAND ANY
1 TimeGT 0
  TimeLT 3
  Set [arg2] [000]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 30
  TimeLT 33
  Set [arg2] [030]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 100
  TimeLT 103
  Set [arg2] [100]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 130
  TimeLT 133
  Set [arg2] [130]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 200
  TimeLT 203
  Set [arg2] [200]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 230
  TimeLT 233
  Set [arg2] [230]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 300
  TimeLT 303
  Set [arg2] [300]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 330
  TimeLT 333
  Set [arg2] [330]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 400
  TimeLT 403
  Set [arg2] [400]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 430
  TimeLT 433
  Set [arg2] [430]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 500
  TimeLT 503
  Set [arg2] [500]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 530
  TimeLT 533
  Set [arg2] [530]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 600
  TimeLT 603
  Set [arg2] [600]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 630
  TimeLT 633
  Set [arg2] [630]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 700
  TimeLT 703
  Set [arg2] [700]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 730
  TimeLT 733
  Set [arg2] [730]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 800
  TimeLT 803
  Set [arg2] [800]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 830
  TimeLT 833
  Set [arg2] [830]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 900
  TimeLT 903
  Set [arg2] [900]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 930
  TimeLT 933
  Set [arg2] [930]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1000
  TimeLT 1003
  Set [arg2] [1000]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1030
  TimeLT 1033
  Set [arg2] [1030]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1100
  TimeLT 1103
  Set [arg2] [1100]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1130
  TimeLT 1133
  Set [arg2] [1130]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 1200
  TimeLT 1203
  Set [arg2] [1200]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1230
  TimeLT 1233
  Set [arg2] [1230]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1300
  TimeLT 1303
  Set [arg2] [1300]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1330
  TimeLT 1333
  Set [arg2] [1330]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 1400
  TimeLT 1403
  Set [arg2] [1400]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1430
  TimeLT 1433
  Set [arg2] [1430]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1500
  TimeLT 1503
  Set [arg2] [1500]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1530
  TimeLT 1533
  Set [arg2] [1530]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 1600
  TimeLT 1603
  Set [arg2] [1600]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1630
  TimeLT 1633
  Set [arg2] [1630]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1700
  TimeLT 1703
  Set [arg2] [1700]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1730
  TimeLT 1733
  Set [arg2] [1730]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 1800
  TimeLT 1803
  Set [arg2] [1800]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1830
  TimeLT 1833
  Set [arg2] [1830]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 1900
  TimeLT 1903
  Set [arg2] [1900]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 1930
  TimeLT 1933
  Set [arg2] [1930]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 2000
  TimeLT 2003
  Set [arg2] [2000]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 2030
  TimeLT 2033
  Set [arg2] [2030]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 2100
  TimeLT 2103
  Set [arg2] [2100]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 2130
  TimeLT 2133
  Set [arg2] [2130]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


1 TimeGT 2200
  TimeLT 2203
  Set [arg2] [2200]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]
  
1 TimeGT 2230
  TimeLT 2233
  Set [arg2] [2230]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 2300
  TimeLT 2303
  Set [arg2] [2300]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]

1 TimeGT 2330
  TimeLT 2333
  Set [arg2] [2330]
  Set [loop routine] [npc time move]
  DoSubroutine [creature loop]


END_COMMAND

! NPC Route Move

COMMAND ANY
Set [loop routine] [Update Route]
DoSubroutine [creature loop]
Set [loop routine] [Random Route]
DoSubroutine [creature loop]
Set [loop routine] [NPC Route Move]
DoSubroutine [creature loop]
END_COMMAND



COMMAND SUBROUTINE[npc time move]
1 Equal [arg].[arg2] 0
Return

1 Present [arg] ' Is the critter here and leaving?
                ! Check if critter has leaving room description or not
  2 Equal [arg].[LeaveDescr] 0 
    Printmessage "You catch a glance of someone leaving." 
  
  2 NOT Equal [arg].[LeaveDescr] 0 
    DescribeThing [arg].[LeaveDescr]  

1 NOT IsGroupmember [arg]
NOT Equal [arg].[arg2] 0
ObjFlagOff [arg].[DontTimeMove]
SendToRoom [arg] [arg].[arg2]

1 Present [arg] ' Did the critter just enter room
                ! Check if has descr for entering room  
 2 Equal [arg].[EnterDescr] 0 
   PrintMessage "Someone enters the room."

 2 NOT Equal [arg].[EnterDescr] 0
   DescribeThing [arg].[EnterDescr]

1 Return
END_COMMAND

COMMAND SUBROUTINE[Update Route]
1 ObjFlagOn [arg].[RouteMove]
Set [arg].[oldroute] [arg].[route]
NOT IsGroupMember [arg]

  2 Equal [arg].[route] 0
    Set [routetemp] 0
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route1] 0   
      Return                    ! No, so return
      
    3 NOT Equal [arg].[Route1] 0 ! Yes, so update route info
      TurnObjFlagOff [arg].[MoveBack]
      Set [arg].[moveto] [arg].[Route1]
      Set [arg].[route] [routetemp]     
      Return

   
  2 Equal [arg].[route] 1
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route2] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route0]
      TurnObjFlagOn [arg].[MoveBack]   
      Return  
                        
    3 NOT Equal [arg].[route2] 0 ! Yes, so update route info
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route2]
      Return

  2 Equal [arg].[route] 2
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route3] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route1]
      TurnObjFlagOn [arg].[MoveBack]   
      Return  
                        
    3 NOT Equal [arg].[route3] 0 ! Yes, so update route info
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route3]
      Return

  2 Equal [arg].[route] 3
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route4] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route2]
      TurnObjFlagOn [arg].[MoveBack]   
      Return  
                        
    3 NOT Equal [arg].[route4] 0 ! Yes, so update route info
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route4]
      Return

  2 Equal [arg].[route] 4
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route5] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route3]
      TurnObjFlagOn [arg].[MoveBack]   
      Return  
                        
    3 NOT Equal [arg].[route5] 0 ! Yes, so update route info
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route5]
      Return

  2 Equal [arg].[route] 5
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route6] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route4]
      TurnObjFlagOn [arg].[MoveBack]    
      Return  
                        
    3 NOT Equal [arg].[route6] 0 ! Yes, so update route info
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route6]
      Return

  2 Equal [arg].[route] 6
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route7] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route5]
      TurnObjFlagOn [arg].[MoveBack]    
      Return  
                        
    3 NOT Equal [arg].[route7] 0 ! Yes, so update route info
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route7]
      Return

2 Equal [arg].[route] 7
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route8] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route6]
      TurnObjFlagOn [arg].[MoveBack]    
      Return  
                        
    3 NOT Equal [arg].[route8] 0 ! Yes, so update route info
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route8]
      Return

2 Equal [arg].[route] 8
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route9] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route7]
      TurnObjFlagOn [arg].[MoveBack]    
      Return  
                        
    3 NOT Equal [arg].[route9] 0 ! Yes, so update route info
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route9]
      Return


! Last
 2 Equal [arg].[route] 9
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
     !  No, so move critter back
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route8]
      TurnObjFlagOn [arg].[MoveBack]   
      Return  
                        
   
1 Return
END_COMMAND


!  Random Route Wandering
!

COMMAND SUBROUTINE[Random Route]
1 ObjFlagOn [arg].[RandomRouteMove]
Set [arg].[oldroute] [arg].[route]
NOT IsGroupMember [arg]

  2 Equal [arg].[route] 0
    Set [routetemp] 0
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route1] 0   
      Return                    ! No, so return
      
    3 NOT Equal [arg].[Route1] 0 ! Yes, so update route info
      TurnObjFlagOff [arg].[MoveBack]
      Set [arg].[moveto] [arg].[Route1]
      Set [arg].[route] [routetemp]     
      Return

   
  2 Equal [arg].[route] 1
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route2] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route0]
      TurnObjFlagOn [arg].[MoveBack]   
      Return  
                        
    3 NOT Equal [arg].[route2] 0 ! Yes, so update route info
      4 Chance 35  ' See if stays where is
      Return

      4 Chance 35  ' see if wanders off
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route0]
      Return
   
      4 Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route2]
      Return

  2 Equal [arg].[route] 2
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route3] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route1]
      TurnObjFlagOn [arg].[MoveBack]   
      Return  
                        
    3 NOT Equal [arg].[route3] 0 ! Yes, so update route info
      
      4 Chance 35  ' See if stays where is
      Return

      4 Chance 35  ' see if wanders off
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route1]
      Return
         
      4 
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route3]
      Return

  2 Equal [arg].[route] 3
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route4] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route2]
      TurnObjFlagOn [arg].[MoveBack]   
      Return  
                        
    3 NOT Equal [arg].[route4] 0 ! Yes, so update route info
      
      4 Chance 35  ' See if stays where is
      Return

      4 Chance 35  ' see if wanders off
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route2]
      Return
         
      4 
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route4]
      Return

  2 Equal [arg].[route] 4
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route5] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route3]
      TurnObjFlagOn [arg].[MoveBack]   
      Return  
                        
    3 NOT Equal [arg].[route5] 0 ! Yes, so update route info

      4 Chance 35  ' See if stays where is
      Return
      
      4 Chance 35  ' see if wanders off
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route3]
      Return
         
      4 
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route5]
      Return

  2 Equal [arg].[route] 5
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route6] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route4]
      TurnObjFlagOn [arg].[MoveBack]    
      Return  
                        
    3 NOT Equal [arg].[route6] 0 ! Yes, so update route info

      4 Chance 35  ' See if stays where is
      Return

      4 Chance 35  ' see if wanders off
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route4]
      Return
         
      4 
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route6]
      Return

2 Equal [arg].[route] 6
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route7] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route5]
      TurnObjFlagOn [arg].[MoveBack]    
      Return  
                        
    3 NOT Equal [arg].[route7] 0 ! Yes, so update route info

      4 Chance 35  ' See if stays where is
      Return

      4 Chance 35  ' see if wanders off
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route5]
      Return
         
      4 
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route7]
      Return

2 Equal [arg].[route] 7
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route8] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route6]
      TurnObjFlagOn [arg].[MoveBack]    
      Return  
                        
    3 NOT Equal [arg].[route8] 0 ! Yes, so update route info

      4 Chance 35  ' See if stays where is
      Return

      4 Chance 35  ' see if wanders off
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route6]
      Return
         
      4 
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route8]
      Return

2 Equal [arg].[route] 8
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
    3 Equal [arg].[route9] 0      ! No, so move critter back
      OR
      ObjFlagOn [arg].[MoveBack]
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route7]
      TurnObjFlagOn [arg].[MoveBack]    
      Return  
                        
    3 NOT Equal [arg].[route9] 0 ! Yes, so update route info

      4 Chance 35  ' See if stays where is
      Return

      4 Chance 35  ' see if wanders off
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route7]
      Return
         
      4 
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route9]
      Return


! Last
 2 Equal [arg].[route] 9
    Set [routetemp] [arg].[route]
    Add [routetemp] 1
    ! Now check to see if next spot on route exists
     !  No, so move critter back
      4 Chance 45  ' See if stays where is
      Return

      4
      Subtract [routetemp] 2
      Set [arg].[route] [routetemp]
      Set [arg].[moveto] [arg].[route8]
      TurnObjFlagOn [arg].[MoveBack]   
      Return  
                        
   
1 Return
END_COMMAND



COMMAND SUBROUTINE[Npc Route Move]
1 ObjFlagOn [arg].[RouteMove]
OR
ObjFlagOn [arg].[RandomRouteMove]

2 Equal [arg].[MoveTo] [arg].[OldRoute]
Return

2 NOT Equal [arg].[MoveTo] [arg].[OldRoute]

   4 Present [arg] ' Is the critter here and leaving?
                ! Check if critter has leaving room description or not
     5 Equal [arg].[LeaveDescr] 0 
     Printmessage "You catch a glance of someone leaving." 
  
     5  NOT Equal [arg].[LeaveDescr] 0 
     DescribeThing [arg].[LeaveDescr]  

   4 NOT IsGroupmember [arg]
     NOT Equal [arg].[MoveTo] 0  
     SendToRoom [arg] [arg].[MoveTo]

  4 Present [arg] ' Did the critter just enter room
                ! Check if has descr for entering room  
   5 Equal [arg].[EnterDescr] 0 
   PrintMessage "Someone enters the room."

   5 NOT Equal [arg].[EnterDescr] 0
   DescribeThing [arg].[EnterDescr]

1 Return
END_COMMAND


