/*
 * Decompiled with CFR 0.152.
 */
package jAsea;

import jAsea.jAseaGameState;
import jAsea.jAseaObject;
import java.io.IOException;
import java.io.Serializable;

class jAseaObjectState
implements Cloneable,
Serializable {
    static final int HIDDEN = -1;
    static final int HELD_PLAYER = 0;
    static final int HELD_NPC = -200;
    static final int WORN_PLAYER = -100;
    static final int WORN_NPC = -300;
    static final int PART_PLAYER = -30;
    static final int PART_NPC = -30;
    static final int ON_OBJ = -20;
    static final int IN_OBJ = -10;
    jAseaGameState jags;
    private boolean unmoved;
    private int position;
    private int parent;
    private int openness;
    private int state;
    private boolean seen;
    private int ownsize;
    private int ownweight;
    private int capsize;
    private int capweight;

    public void setSeen(boolean bl) {
        this.seen = bl;
    }

    public void setState(int n) {
        this.state = n;
    }

    public void setOpenness(int n) {
        this.openness = n;
    }

    public void setUnmoved(boolean bl) {
        this.unmoved = bl;
    }

    public void moveOnto(int n) {
        this.position = -20;
        this.parent = n;
    }

    public void moveInto(int n) {
        this.position = -10;
        this.parent = n;
    }

    public void makeHidden() {
        this.position = -1;
        this.parent = -1;
    }

    public void playerGet() {
        this.position = 0;
        this.parent = -1;
    }

    public void npcGet(int n) {
        this.position = -200;
        this.parent = n;
    }

    public void playerWear() {
        this.position = -100;
        this.parent = 0;
    }

    public void npcWear(int n) {
        this.position = -300;
        this.parent = n;
    }

    public void toRoom(int n) {
        this.position = n + 1;
        this.parent = -1;
    }

    public int getOpenness() {
        return this.openness;
    }

    public int getState() {
        return this.state;
    }

    public boolean getUnmoved() {
        return this.unmoved;
    }

    public boolean getSeen() {
        return this.seen;
    }

    public int getPosition() {
        return this.position;
    }

    public int getParent() {
        return this.parent;
    }

    static jAseaObjectState[] read(jAseaGameState jAseaGameState2, Object[] objectArray) {
        jAseaObjectState[] jAseaObjectStateArray = new jAseaObjectState[objectArray.length];
        int n = 0;
        while (n < jAseaObjectStateArray.length) {
            jAseaObjectStateArray[n] = new jAseaObjectState(jAseaGameState2, (jAseaObject)objectArray[n]);
            ++n;
        }
        return jAseaObjectStateArray;
    }

    static int pow3(int n) {
        int n2 = 1;
        while (n > 0) {
            n2 *= 3;
            --n;
        }
        return n2;
    }

    void save(jAseaGameState jAseaGameState2, int n) {
        jAseaObject jAseaObject2 = jAseaGameState2.jar.objects[n];
        jAseaGameState2.save(this.position);
        jAseaGameState2.save(this.seen);
        jAseaGameState2.save(this.parent);
        if (this.openness != 0) {
            jAseaGameState2.save(this.openness);
        }
        if (this.state != 0) {
            jAseaGameState2.save(this.state);
        }
        jAseaGameState2.save(this.unmoved);
    }

    void read(jAseaGameState jAseaGameState2, int n) throws IOException {
        jAseaObject jAseaObject2 = jAseaGameState2.jar.objects[n];
        this.position = jAseaGameState2.readI();
        this.seen = jAseaGameState2.readB();
        this.parent = jAseaGameState2.readI();
        int n2 = 0;
        if (jAseaObject2.getI("Openable") != 0) {
            n2 = jAseaGameState2.readI();
        }
        this.openness = n2;
        int n3 = 0;
        if (jAseaObject2.getI("CurrentState") != 0) {
            n3 = jAseaGameState2.readI();
        }
        this.state = n3;
        this.unmoved = jAseaGameState2.readB();
    }

    jAseaObjectState(jAseaGameState jAseaGameState2, jAseaObject jAseaObject2) {
        int n;
        this.jags = jAseaGameState2;
        if (jAseaObject2.getB("Static")) {
            if (jAseaObject2.getO("Where").getB("NPCPart")) {
                this.position = -30;
                this.parent = jAseaObject2.getI("Parent");
            } else {
                this.parent = -1;
                this.position = -1;
            }
        } else {
            n = jAseaObject2.getI("Parent");
            int n2 = jAseaObject2.getI("InitialPosition");
            switch (n2) {
                case 0: {
                    this.position = -1;
                    this.parent = -1;
                    break;
                }
                case 1: {
                    if (n == 0) {
                        this.position = 0;
                        this.parent = 0;
                        break;
                    }
                    this.position = -200;
                    this.parent = n - 1;
                    break;
                }
                case 2: {
                    this.position = -10;
                    this.parent = this.jags.jar.ContainerObject(n);
                    break;
                }
                case 3: {
                    this.position = -20;
                    this.parent = this.jags.jar.SurfaceObject(n);
                    break;
                }
                default: {
                    if (n2 >= 4 && n2 < 4 + this.jags.jar.rooms.length) {
                        this.position = n2 - 3;
                        this.parent = -1;
                        break;
                    }
                    if (n2 == 4 + this.jags.jar.rooms.length) {
                        this.position = -100;
                        this.parent = 0;
                        break;
                    }
                    this.position = -1;
                    this.parent = -1;
                }
            }
        }
        this.state = jAseaObject2.getI("CurrentState");
        this.openness = jAseaObject2.getI("Openable");
        this.seen = false;
        this.unmoved = jAseaObject2.getS("InRoomDesc").length() != 0 && jAseaObject2.getI("OnlyWhenNotMoved") == 1;
        if (!jAseaObject2.getB("Static")) {
            n = jAseaObject2.getI("SizeWeight");
            this.ownweight = jAseaObjectState.pow3(n / 10);
            this.ownsize = jAseaObjectState.pow3(n % 10);
        } else {
            this.ownsize = 0;
            this.ownweight = 0;
        }
        this.capweight = 0;
        this.capsize = 0;
    }
}

