


/*
 * GtkScare is a runner for Adrift text adventure games.
 * This program is released under GNU GPL. See the file COPYING.TXT for
 * details.
 * Copyright (c) 2004 Pallav Nawani
 *
 */


/*! 
*
* \file gtkscare.h
* 	Data Structures for gtkscare.
* 	
* 	
* \author Pallav Nawani
* Copyright Pallav Nawani
* 
*/

#ifndef _IC_GTKSCARE_H_
#define _IC_GTKSCARE_H_

#include "gtk/gtk.h"
#include <stdio.h>
#include "../scare.h"

/*
 * data maintained internally by gtkscare.
 */


#define NSIZE 2048
#define CMDBUF 128
#define DEFAULT_FONT_SIZE 12

enum Dialog_response {
   DNORESPONSE = -1,
   DNO,
   DYES
};

// These are the game related commands we may be working on
enum Scare_commands {
   OPEN_GAME,
   SAVE_GAME,
   LOAD_SAVEFILE,
   RESTART_GAME,
   SET_BGCOLOR,
   SET_NORMALCOLOR,
   SET_INPUTCOLOR,
   SET_FONT,
   WAIT_FOR_KEY,
   WAIT_FOR_INPUT
};

/* These are tags used to format the output of gtkscare */
enum Output_tags {
   ITALIC,
   BOLD,
   UNDERLINE,
   CENTER,
   RIGHT_JUSTIFY,
   NORMAL,
   USERINPUT,
   IMPORTANTINFO,
   DEBUGINFO,
   LASTTAG
};

typedef struct _Gtk_sdata {

   char gname[NSIZE];	   ///< Name of the current game
   char userin[NSIZE];	   ///< User input
   char name[NSIZE];	   ///< Space for name
   char cmds[CMDBUF][256]; ///< Command buffer

   int num_cmds;	///< Number of commands in the buffer
   int ipoint;		///< Insertion point of commands
   int spoint;		///< Search point
   
   FILE *savefile;	///< FILE pointer to  save file
   FILE *log;		///< input log
   FILE *debuglog;	///< debug input log
   
   GdkColor normal;	///< Text out color
   GdkColor out_fore;	///< Text out color
   GdkColor in_fore;	///< Input text color
  
   char tags[CMDBUF][64]; ///< Stack of tags that can be applied to output
   int  tsize;		///< Number of tags in stack

   short fstack[CMDBUF];///< Font size stack
   short ftop;		///< top of the font stack
   GtkTextTag *ftag;	///< Current font tag
   
   char got_input;	///< Got input?
   char got_key;	///< Got keypress?
   char got_yesno;	///< Got confirmation
   char command;	///< The command we're working on
   char yesno;		///< confirmation value
   char verbose;	///< verbose mode on?

   char menu;		///< Was the save/load done from the menu?

   GtkWidget *textw;	///< The text widget
   GtkWidget *sbar;	///< The status bar
   GtkWidget *mwin;	///< The main window
   GtkWidget *entry;	///< The entry widget
   GtkWidget *curw;	///< Current widget
   GtkWidget *mverb;	///< The menu widget that sets/unsets verbose
   GtkWidget *debugger;	///< The debugger console

   GdkPixbuf *gp;	///< Used in the about box

   sc_game sgame;	///< The game being played
   sc_game_hint shint[CMDBUF]; ///< Hints for the game

} Gtk_sdata;


// Initialize interface data
void sdata_init(Gtk_sdata *sdata);

/* make tags which are used in formatting user input */
void make_tags(Gtk_sdata *sdata, GtkTextBuffer *buffer);

#endif




/*  End of file gtkscare.h  */

