/*################################################################################
 #
 #  winace - Adventure Creation Environment
 #
 #
 #  Copyright:
 #    1997 - 2010 Andy Clark
 #
 #  License:
 #    LGPL: http://www.gnu.org/licenses/lgpl.html
 #    See the COPYING.LESSER file in the project's top-level directory for details.
 #
 #  Authors:
 #    * Andy Clark
 #
 ################################################################################*/

// WinAceDoc.cpp : implementation of the CWinAceDoc class
//

#include "stdafx.h"

#include "WinAce.h"

#include "WinAceDoc.h"

#include "WinAceView.h"

#include "CAdv_Main.HPP"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWinAceDoc

IMPLEMENT_DYNCREATE(CWinAceDoc, CDocument)

BEGIN_MESSAGE_MAP(CWinAceDoc, CDocument)
	//{{AFX_MSG_MAP(CWinAceDoc)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CWinAceDoc construction/destruction

CWinAceDoc::CWinAceDoc()
{
		AceCore = new CAdvMain();

}

CWinAceDoc::~CWinAceDoc()
{
		if ( AceCore )
		delete AceCore;
}

BOOL CWinAceDoc::OnNewDocument()
{
	if (!CDocument::OnNewDocument())
		return FALSE;

	// TODO: add reinitialization code here
	// (SDI documents will reuse this document)

	return TRUE;
}



/////////////////////////////////////////////////////////////////////////////
// CWinAceDoc serialization

void CWinAceDoc::Serialize(CArchive& ar)
{
	if (ar.IsStoring())
	{
		// TODO: add storing code here
	}
	else
	{
		// TODO: add loading code here
	}
}

/////////////////////////////////////////////////////////////////////////////
// CWinAceDoc diagnostics

#ifdef _DEBUG
void CWinAceDoc::AssertValid() const
{
	CDocument::AssertValid();
}

void CWinAceDoc::Dump(CDumpContext& dc) const
{
	CDocument::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CWinAceDoc commands

void CWinAceDoc::LoadGame(CString fileName)
{
   Filename = fileName;
   int finalSlash = fileName.ReverseFind('\\');
	   Filename = fileName.Left(finalSlash+1);
 //  ::AfxMessageBox(Filename);
 //  ::AfxMessageBox(fileName);
   
	   AceCore->Load( fileName.GetBuffer() );
   OutputStream.addStart();
   AceCore->DescribeRoom();
   PreInput();
   OutputStream.AddFinish();
   UpdateAllViews( NULL );
}

void CWinAceDoc::PreInput()
{
	int process1result = AceCore -> PreInput();
	while ( process1result == PROC_DESC )
	{
		AceCore -> DescribeRoom();
		process1result = AceCore -> PreInput();
	}

	if ( process1result == PROC_QUIT ) 
	{
		   p_mainView->PostMessage( WM_QUIT );
	}

	if ( process1result == PROC_LOAD )
	{
		//LOAD
	}

	if ( process1result == PROC_RESTART )
	{
	  AceCore->Restart();
	  AceCore->DescribeRoom();
	}
}

void CWinAceDoc::NewCommand(CString command)
{
 OutputStream.WriteLine( _T("<br/><B>")+command+_T("</B><br/>") );

 OutputStream.addStart();

 int process0result = AceCore -> ProcessInput ( command );

 	if ( process0result == PROC_QUIT ) 
	{
	   p_mainView->PostMessage( WM_QUIT );
	
	}

	if ( process0result == PROC_LOAD )
	{
		AceCore -> DescribeRoom();
	}

	if ( process0result == PROC_RESTART )
	{
	   
		AceCore->Restart();
	  AceCore->DescribeRoom();
	}


	if ( process0result == PROC_DESC )
	{
		AceCore -> DescribeRoom();
	}
	PreInput();
	OutputStream.AddFinish();
	this->UpdateAllViews( NULL );
}

void CWinAceDoc::restart()
{
AceCore->Restart();
AceCore->DescribeRoom();
PreInput();
OutputStream.AddFinish();
//UpdateAllViews( NULL );

}


bool CWinAceDoc::isDebugable()
{
	if ( AceCore == NULL )
	{
		return false;
	}
	
	
	return AceCore->Debugable;

}

CFlagTable *CWinAceDoc::getFlags()
{
	if ( AceCore != NULL )
	{
		return ( &AceCore->Flags );
	}
	return NULL;
}

CObjectList * CWinAceDoc::getObjects()
{
	if ( AceCore != NULL )
	{
		return ( AceCore->Objects );
	}
	return NULL;
}

int CWinAceDoc::getLocationCount()
{
	if ( AceCore != NULL )
	{
		return (AceCore->GameMap.MaxLocation );
	}
	return -1;
}
