#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#include "structs.h"

#define VERSION	"0.1b"
#define PATH_SEP 	0x5C		// unix==0x2F

unsigned short retShort(unsigned short);
unsigned long retLong(unsigned long);
void	ischar(char *deststring, char *instring, char ch, char *addstring);
void	vocabulary(char *s);

void	sendchar(char);

unsigned long read_l(char *ptr);
unsigned short read_w(char *ptr);
void write_string(short);
void char_out(unsigned char c);


char	*decode_table;
char	*string1;
char	*string2;

HEAD	h;

unsigned char	cflag=0;
unsigned char	lastchar=0;
unsigned char	width=80;
unsigned char	cwidth=0;
unsigned char	wind=0;
unsigned char	buff[128];

void main(short argc, char *argv[])
{
	fprintf(stderr, "Magnetic String Decoder v" VERSION "; Dark Fiber <entropy@mpx.com.au>\n"
    				"String Decompress routine by Niclas Karlsson.\n"
    				);
	if(argc>1)
	{
		vocabulary(argv[1]);
	}
	else
	{
		fprintf(stderr, "Syntax -:- gamefile{.mag}\n");
	}
}

void ischar(char *deststring, char *instring, char ch, char *addstring)
{
    char *point, k;

    strcpy(deststring, instring);
    point=strchr(deststring, 0x0);
    do
    {
    	point--;
        k=*point;
    }while((point!=deststring)&&(k!=PATH_SEP));
    if((strchr(point, ch))==NULL)
    	strcat(deststring, addstring);
}

unsigned long retLong(unsigned long i)
{
	unsigned long l;

	l =(i&0x000000FF)<<24;
	l+=(i&0x0000FF00)<<8;
	l+=(i&0x00FF0000)>>8;
	l+=(i&0xFF000000)>>24;
	return(l);
}

unsigned short retShort(unsigned short i)
{
	unsigned short l;

	l=(i&0xFF)<<8;
	l+=(i&0xFF00)>>8;
	return(l);
}


void vocabulary(char *s)
{
	char	fn1[256];
	FILE	*fp;
	unsigned long i, z;
	char	*p;
	char	k, q;
	short	bank=0;

	ischar(fn1, s, '.', ".mag");
	if((fp=fopen(fn1, "rb"))!=NULL)
	{
		fread(&h, 1, sizeof(HEAD), fp);
		if(strncmp(h.magic, "MaSc", 4)==NULL)
		{
			fseek(fp, sizeof(HEAD), SEEK_SET);
			fseek(fp, retLong(h.main_memory_size), SEEK_CUR);

			string1=(char *)calloc(1, 15+retLong(h.string1_size));
			fread(string1, 1, retLong(h.string1_size), fp);
			string2=(char *)calloc(1, 15+retLong(h.string2_size));
			fread(string2, 1, retLong(h.string2_size), fp);

			if(retLong(h.decoding_offset)>=retLong(h.string1_size))
				decode_table=(string2+retLong(h.decoding_offset))-retLong(h.string1_size);
			else
				decode_table=string1+retLong(h.decoding_offset);

			// for every entry in string offset table,
			// bust each string.
			z=1;
			for(i=0; z!=0; i++)
			{
				write_string(i);
				if(lastchar!='.' && lastchar!=0x20)
					sendchar('.');
				if(lastchar!=0x0a)
					sendchar('\n');
				sendchar('\n');

				if(i>0)
				{
					z=read_w(&decode_table[0x100+(2*i)]);
				}
			}

		}
		else
			fprintf(stderr, "Error : Not a valid MAGNETIC game file.\n");

		fclose(fp);
	}
	else
		fprintf(stderr, "Error : Cannot open \"%s\"\n", fn1);
}



void write_string(short i)
{
	static	unsigned long	offset_bak;
	static	unsigned char	mask_bak;
	unsigned char	c, b, mask;
	unsigned short	ptr=0;
	unsigned long	offset=0;

	if (!cflag)			/* new string */
	{
		ptr=i;
		lastchar=0;

		//ptr=read_reg(0,1);
		if (!ptr)
		    offset=0;
		else
		{
			offset=read_w(&decode_table[0x100+2*ptr]);
			if (read_w(&decode_table[0x100]))
			{
				if (ptr>=read_w(&decode_table[0x100]))
				    offset+=retLong(h.string1_size);
			}
		}
		mask=1;
	}
	else
	{
		offset=offset_bak;
		mask=mask_bak;
	}

	do
	{
		c=0;
		while (c<(signed)0x80)
		{
			if (offset>=retLong(h.string1_size))
			    b=string2[offset-retLong(h.string1_size)];
			else
			    b=string1[offset];
			if (b & mask)
			    c=decode_table[0x80+c];
			else
			    c=decode_table[c];
			mask<<=1;
			if (!mask)
			{
				mask=1;
				offset++;
			}
		}
		c&=0x7f;
		if (c && ((c!=0x40) || (lastchar!=0x20)))
		    char_out(c);
	} while (c && ((c!=0x40) || (lastchar!=0x20)));

	cflag=c!=0 ? 0xff : 0;
	if (c)
	{
		offset_bak=offset;
		mask_bak=mask;
	}
}

unsigned short read_w(char *ptr)
{
	return (unsigned short )(ptr[0]<<8 | ptr[1]);
}

unsigned long read_l(char *ptr)
{
	return (unsigned long)ptr[0]<<24|(long)ptr[1]<<16|(long)ptr[2]<<8|(long)ptr[3];
}

void char_out(unsigned char c)
{
	static unsigned char big=0, period=0, pipe=0;

	if (c==0xff)
	{
		big=1;
		return;
	}

	c&=0x7f;

	if (c=='^')
	    c=0x0a;

	if ((retShort(h.version)&0xFF)<3 && c=='~')
	{
		lastchar=0x7e;
		c=0x0a;
	}

	if (((c>'@') && (c<'[')) || ((c>'`') && (c<'{')))
	{
		if (big)
		{
			c&=0xdf;
			big=0;
		}
		if (period)
		{
			if(lastchar!=0x0a)
				char_out(0x20);
			period=0;
		}
	}
	period=0;
	if ((c=='.') || (c=='?') || (c=='!') || (c==0x0a))
	    big=1;
	if (((c==' ') || (c==0x0a)) && (c==lastchar))
	    return;
	if ((retShort(h.version)&0xFF)<3)
	{
		if (pipe)
		{
			pipe=0;
			return;
		}
		if (c=='|')
		{
			pipe=1;
			return;
		}
	}
	else
	{
		if (c=='~')
		{
			c=0x0a;
			if (lastchar!=0x0a)
				char_out(0x0a);
		}
	}

	//if(c!=0x0a)
		lastchar=c;

	if (c=='_')
	    c=' ';
	if ((c=='.')||(c==',')||(c==';')||(c==':')||(c=='!')||(c=='?'))
	{
		period=1;
	}
	sendchar(c);
}

void sendchar(char c)
{

	buff[wind]=c;
	wind++;
	buff[wind]=0;
	cwidth++;

	switch(c)
	{
		case 0x0a:
			buff[wind-1]=0x0;
			if(cwidth>=width-1)
				printf("\n");
			printf("%s\n", buff);
			cwidth=wind;
			wind=0;
			break;

		case 0x20:
			if(cwidth>=width-1)
			{
				cwidth=wind;
				printf("\n");
			}
			printf("%s", buff);
			wind=0;
			break;

		default:
			break;
	}
}