// tab size = 4

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "structs.h"

#define VERSION	"0.1a"
#define PATH_SEP	0x5c		// unix == 0x2f

unsigned short retShort(unsigned short);
unsigned long retLong(unsigned long);
void	ischar(char *deststring, char *instring, char ch, char *addstring);
void	break_magnetic(FILE *fp);
void 	readwrite(FILE *ifp, FILE *ofp, unsigned long len);

char	fn1[256];

void main(short argc, char *argv[])
{
	FILE *fp;
	HEAD	h;
	int	i;

	fprintf(stderr, "Magnetic Bust v" VERSION "; by Dark Fiber <entropy@mpx.com.au>\n");
	if(argc>=2)
	{
		for(i=1; i<argc; i++)
		{
    		ischar(fn1, argv[i], '.', ".mag");
    		if((fp=fopen(fn1, "rb"))!=NULL)
    		{
    			fread(&h, 1, sizeof(HEAD), fp);
    			if(strncmp(h.magic, "MaSc", 4)==NULL)
    			{
    				fprintf(stderr, "\nBreaking %s\n", fn1);
    				break_magnetic(fp);
    				fclose(fp);
    			}
    			else
    				fprintf(stderr, "ERROR : Not a valid Magnetic game file.\n");
    		}
    		else
    			fprintf(stderr, "ERROR : Cannot open file \"%s\"\n", fn1);
    	}
	}
	else
		fprintf(stderr, "Syntax -:- MagBust gamefile{.mag}\n");
}

unsigned long retLong(unsigned long i)
{
	unsigned long l;

	l =(i&0x000000FF)<<24;
	l+=(i&0x0000FF00)<<8;
	l+=(i&0x00FF0000)>>8;
	l+=(i&0xFF000000)>>24;
	return(l);
}

unsigned short retShort(unsigned short i)
{
	unsigned short l;

	l=(i&0xFF)<<8;
	l+=(i&0xFF00)>>8;
	return(l);
}

void ischar(char *deststring, char *instring, char ch, char *addstring)
{
    char *point, k;

    strcpy(deststring, instring);
    point=strchr(deststring, 0x0);
    do
    {
    	point--;
        k=*point;
    }while((point!=deststring)&&(k!=PATH_SEP));
    if((strchr(point, ch))==NULL)
    	strcat(deststring, addstring);
}

void break_magnetic(FILE *fp)
{
	FILE	*ofp;
	HEAD	h;
	unsigned long	msize, p;
	char	fn2[256];
	long	i;
	char	*x;

	fseek(fp, 0x0L, SEEK_SET);
	fread(&h, 1, sizeof(HEAD), fp);

	strcpy(fn2, fn1);
	x=strchr(fn2, 0x0);
	while(x!=fn2 && *x!=0x2e)
		x--;
	if(*x==0x2e)
		*x=0x0;

	if(retLong(h.header_size)==sizeof(HEAD))
	{
		ischar(fn1, fn2, '.', ".cod");
		if((ofp=fopen(fn1, "wb"))!=NULL)
		{
			fprintf(stderr, "Creating Code file\n");
			readwrite(fp, ofp, retLong(h.main_memory_size));
    		fclose(ofp);
    	}

		ischar(fn1, fn2, '.', ".s1");
		if((ofp=fopen(fn1, "wb"))!=NULL)
		{
			fprintf(stderr, "Creating String file 1\n");
			readwrite(fp, ofp, retLong(h.string1_size));
    		fclose(ofp);
    	}

		ischar(fn1, fn2, '.', ".s2");
		if((ofp=fopen(fn1, "wb"))!=NULL)
		{
			fprintf(stderr, "Creating String file 2\n");
			readwrite(fp, ofp, retLong(h.string2_size));
    		fclose(ofp);
    	}

		if((retShort(h.version)&0xFF)>1)
		{
    		ischar(fn1, fn2, '.', ".dic");
    		if((ofp=fopen(fn1, "wb"))!=NULL)
    		{
				fprintf(stderr, "Creating Dictionary file\n");
				readwrite(fp, ofp, retLong(h.dictionary_size));
        		fclose(ofp);
        	}
		}
	}
	else
		fprintf(stderr, "Error : Header size doesnt match header.\n");
}

void readwrite(FILE *ifp, FILE *ofp, unsigned long len)
{
	unsigned long i, p;
	char	buff[8192];

	p=len;
	i=1;
	while(i>0)
	{
		i=p;
		if(i>8192)
			i=8192;
		i=fread(&buff, 1, i, ifp);
		p-=i;
		fwrite(&buff, 1, i, ofp);
	}
}