/*
 * @(#)JPanel.java  1.0  19 March 2005
 *
 * Copyright (c) 2004 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * The copyright of this software is owned by Werner Randelshofer. 
 * You may not use, copy or modify this software, except in  
 * accordance with the license agreement you entered into with  
 * Werner Randelshofer. For details see accompanying license terms. 
 */

package test;

import ch.randelshofer.quaqua.*;
import ch.randelshofer.quaqua.util.*;
import javax.swing.*;
import javax.swing.border.*;
/**
 * JPanel.
 *
 * @author  Werner Randelshofer
 * @version 1.0  19 March 2005  Created.
 */
public class TextControlsTest extends javax.swing.JPanel {
    
    /** Creates new form. */
    public TextControlsTest() {
        initComponents();
        
        tabbedPane.add(new LazyPanel("test.EditorPaneTest"), "EditorPane");
            tabbedPane.add(new LazyPanel("test.FormattedTextFieldTest14"), "FormattedTextField");
        tabbedPane.add(new LazyPanel("test.PasswordFieldTest"), "PasswordField");
        tabbedPane.add(new LazyPanel("test.TextAreaTest"), "TextArea");
       tabbedPane.add(new LazyPanel("test.TextFieldTest"), "TextField");
        tabbedPane.add(new LazyPanel("test.TextPaneTest"), "TextPane");
        
        Methods.invokeIfExists(tabbedPane, "setTabLayoutPolicy", 0);
    }
    

    
    public static void main(String args[]) {
        SwingUtilities.invokeLater(new Runnable() {
            public void run() {
        
        try {
            UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
        } catch (Exception e) {
            e.printStackTrace();
        }
        JFrame f = new JFrame("Quaqua Text Controls Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.getContentPane().add(new TextControlsTest());
        ((JComponent) f.getContentPane()).setBorder(new EmptyBorder(9,17,17,17));
        f.pack();
        f.setVisible(true);
        }
            });
    }    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        tabbedPane = new javax.swing.JTabbedPane();

        setLayout(new java.awt.BorderLayout());

        add(tabbedPane, java.awt.BorderLayout.CENTER);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTabbedPane tabbedPane;
    // End of variables declaration//GEN-END:variables
    
}
