/*
 * @(#)RadioButtonTest.java  1.0  13 February 2005
 *
 * Copyright (c) 2004 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * The copyright of this software is owned by Werner Randelshofer. 
 * You may not use, copy or modify this software, except in  
 * accordance with the license agreement you entered into with  
 * Werner Randelshofer. For details see accompanying license terms. 
 */

package test;

import ch.randelshofer.quaqua.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
/**
 * RadioButtonTest.
 *
 * @author  Werner Randelshofer
 * @version 1.0  13 February 2005  Created.
 */
public class RadioButtonTest extends javax.swing.JPanel {
    
    /** Creates new form. */
    public RadioButtonTest() {
        initComponents();

        // Leopard properties
        if (QuaquaManager.getDesign() == QuaquaManager.LEOPARD) {
            radioButton3.putClientProperty("JComponent.sizeVariant","small");
            radioButton4.putClientProperty("JComponent.sizeVariant","small");
        }
    }
    
    public static void main(String args[]) {
        try {
            UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
        } catch (Exception e) {
            e.printStackTrace();
        }
        JFrame f = new JFrame("Quaqua RadioButton Test");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.getContentPane().add(new RadioButtonTest());
        ((JComponent) f.getContentPane()).setBorder(new EmptyBorder(9,17,17,17));
        f.pack();
        f.setVisible(true);
    }
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc=" Generated Code ">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        buttonGroup1 = new javax.swing.ButtonGroup();
        radioButton1 = new javax.swing.JRadioButton();
        enabledLabel = new javax.swing.JLabel();
        radioButton2 = new javax.swing.JRadioButton();
        disabledLabel = new javax.swing.JLabel();
        separator = new javax.swing.JSeparator();
        radioButton3 = new javax.swing.JRadioButton();
        smallLabel = new javax.swing.JLabel();
        radioButton4 = new javax.swing.JRadioButton();
        jSeparator1 = new javax.swing.JSeparator();
        jRadioButton5 = new javax.swing.JRadioButton();
        largeLabel = new javax.swing.JLabel();

        setLayout(new java.awt.GridBagLayout());

        buttonGroup1.add(radioButton1);
        radioButton1.setSelected(true);
        radioButton1.setText("\u00c5ngstr\u00f6m H");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(radioButton1, gridBagConstraints);

        enabledLabel.setText("Enabled");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        add(enabledLabel, gridBagConstraints);

        buttonGroup1.add(radioButton2);
        radioButton2.setText("\u00c5ngstr\u00f6m H");
        radioButton2.setEnabled(false);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(radioButton2, gridBagConstraints);

        disabledLabel.setText("Disabled");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        add(disabledLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 12, 0);
        add(separator, gridBagConstraints);

        buttonGroup1.add(radioButton3);
        radioButton3.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        radioButton3.setText("\u00c5ngstr\u00f6m H");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(radioButton3, gridBagConstraints);

        smallLabel.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        smallLabel.setText("Small Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        add(smallLabel, gridBagConstraints);

        buttonGroup1.add(radioButton4);
        radioButton4.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        radioButton4.setText("\u00c5ngstr\u00f6m H");
        radioButton4.setEnabled(false);
        radioButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                radioButton4ActionPerformed(evt);
            }
        });

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(radioButton4, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(12, 0, 12, 0);
        add(jSeparator1, gridBagConstraints);

        buttonGroup1.add(jRadioButton5);
        jRadioButton5.setFont(new java.awt.Font("Lucida Grande", 0, 24));
        jRadioButton5.setText("\u00c5ngstr\u00f6m H");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        add(jRadioButton5, gridBagConstraints);

        largeLabel.setText("Large Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 0);
        add(largeLabel, gridBagConstraints);

    }// </editor-fold>//GEN-END:initComponents

    private void radioButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_radioButton4ActionPerformed
// TODO add your handling code here:
    }//GEN-LAST:event_radioButton4ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JLabel disabledLabel;
    private javax.swing.JLabel enabledLabel;
    private javax.swing.JRadioButton jRadioButton5;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JLabel largeLabel;
    private javax.swing.JRadioButton radioButton1;
    private javax.swing.JRadioButton radioButton2;
    private javax.swing.JRadioButton radioButton3;
    private javax.swing.JRadioButton radioButton4;
    private javax.swing.JSeparator separator;
    private javax.swing.JLabel smallLabel;
    // End of variables declaration//GEN-END:variables
    
}
