/*
 * @(#)GroupingTest.java  1.0  September 30, 2005
 *
 * Copyright (c) 2005 Werner Randelshofer
 * Staldenmattweg 2, Immensee, CH-6405, Switzerland.
 * All rights reserved.
 *
 * The copyright of this software is owned by Werner Randelshofer. 
 * You may not use, copy or modify this software, except in  
 * accordance with the license agreement you entered into with  
 * Werner Randelshofer. For details see accompanying license terms. 
 */

package test;

import ch.randelshofer.quaqua.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.border.*;
/**
 * GroupingTest.
 *
 * @author  Werner Randelshofer
 * @version 1.0 September 30, 2005 Created.
 */
public class GroupingTest extends javax.swing.JPanel {
    
    /**
     * Creates a new instance.
     */
    public GroupingTest() {
        initComponents();
        
        helpButton.putClientProperty("Quaqua.Button.style", "help");
        windowBgButton.putClientProperty("Quaqua.Button.style", "colorWell");
        drawerBgButton.putClientProperty("Quaqua.Button.style", "colorWell");
        Dimension ss = sizeSlider.getPreferredSize();
        ss.width = 100;
        sizeSlider.setPreferredSize(ss);
    }
    
    public static void main(String args[]) {
        QuaquaManager.setProperty("Quaqua.design","jaguar");
        try {
            UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
        } catch (Exception e) {
            e.printStackTrace();
        }
        JFrame f = new JFrame("Preferences");
        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        f.getContentPane().add(new GroupingTest());
        ((JComponent) f.getContentPane()).setBorder(new EmptyBorder(9,17,17,17));
        f.pack();
        f.setVisible(true);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        showGroup = new javax.swing.ButtonGroup();
        jTabbedPane1 = new javax.swing.JTabbedPane();
        jPanel3 = new javax.swing.JPanel();
        thumbnailsPanel = new javax.swing.JPanel();
        imageAndNameRadio = new javax.swing.JRadioButton();
        imageOnlyRadio = new javax.swing.JRadioButton();
        nameOnlyRadio = new javax.swing.JRadioButton();
        sizePanel = new javax.swing.JPanel();
        sizeLabel = new javax.swing.JLabel();
        sizeSlider = new javax.swing.JSlider();
        jCheckBox1 = new javax.swing.JCheckBox();
        colorsPanel = new javax.swing.JPanel();
        windowBgLabel = new javax.swing.JLabel();
        windowBgButton = new javax.swing.JButton();
        drawerBgLabel = new javax.swing.JLabel();
        drawerBgButton = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jPanel1 = new javax.swing.JPanel();
        buttonPanel = new javax.swing.JPanel();
        helpButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        okayButton = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        jPanel3.setLayout(new java.awt.GridBagLayout());

        jPanel3.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(1, 1, 1, 1)));
        thumbnailsPanel.setLayout(new java.awt.GridBagLayout());

        thumbnailsPanel.setBorder(new javax.swing.border.TitledBorder("Thumbnails"));
        imageAndNameRadio.setText("Show image and name");
        showGroup.add(imageAndNameRadio);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(8, 13, 0, 0);
        thumbnailsPanel.add(imageAndNameRadio, gridBagConstraints);

        imageOnlyRadio.setText("Show image only");
        showGroup.add(imageOnlyRadio);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 13, 0, 0);
        thumbnailsPanel.add(imageOnlyRadio, gridBagConstraints);

        nameOnlyRadio.setText("Show name only");
        showGroup.add(nameOnlyRadio);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 13, 0, 0);
        thumbnailsPanel.add(nameOnlyRadio, gridBagConstraints);

        sizePanel.setLayout(new java.awt.GridBagLayout());

        sizePanel.setBorder(new javax.swing.border.TitledBorder(""));
        sizeLabel.setText("Size:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 9, 0, 9);
        sizePanel.add(sizeLabel, gridBagConstraints);

        sizeSlider.setMajorTickSpacing(1);
        sizeSlider.setMaximum(6);
        sizeSlider.setPaintTicks(true);
        sizeSlider.setValue(3);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 9, 0, 9);
        sizePanel.add(sizeSlider, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 0, 13);
        thumbnailsPanel.add(sizePanel, gridBagConstraints);

        jCheckBox1.setText("Automatically load all thumbnails");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = java.awt.GridBagConstraints.REMAINDER;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(12, 13, 11, 0);
        thumbnailsPanel.add(jCheckBox1, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel3.add(thumbnailsPanel, gridBagConstraints);

        colorsPanel.setLayout(new java.awt.GridBagLayout());

        colorsPanel.setBorder(new javax.swing.border.TitledBorder("Colors"));
        windowBgLabel.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        windowBgLabel.setText("Window background:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(8, 13, 8, 0);
        colorsPanel.add(windowBgLabel, gridBagConstraints);

        windowBgButton.setBackground(new java.awt.Color(255, 255, 255));
        windowBgButton.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        windowBgButton.setText("   ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 8, 0);
        colorsPanel.add(windowBgButton, gridBagConstraints);

        drawerBgLabel.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        drawerBgLabel.setText("Drawer background:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(8, 10, 8, 0);
        colorsPanel.add(drawerBgLabel, gridBagConstraints);

        drawerBgButton.setBackground(new java.awt.Color(255, 255, 255));
        drawerBgButton.setFont(new java.awt.Font("Lucida Grande", 0, 11));
        drawerBgButton.setText("   ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(8, 0, 8, 13);
        colorsPanel.add(drawerBgButton, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(9, 0, 0, 0);
        jPanel3.add(colorsPanel, gridBagConstraints);

        jTabbedPane1.addTab("General", jPanel3);

        jTabbedPane1.addTab("Images", jPanel2);

        jTabbedPane1.addTab("PDF", jPanel1);

        add(jTabbedPane1, java.awt.BorderLayout.CENTER);

        buttonPanel.setLayout(new java.awt.GridBagLayout());

        buttonPanel.setBorder(new javax.swing.border.EmptyBorder(new java.awt.Insets(14, 0, 0, 0)));
        helpButton.setText("Help");
        buttonPanel.add(helpButton, new java.awt.GridBagConstraints());

        cancelButton.setText("Cancel");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        buttonPanel.add(cancelButton, gridBagConstraints);

        okayButton.setText("Okay");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 0);
        buttonPanel.add(okayButton, gridBagConstraints);

        add(buttonPanel, java.awt.BorderLayout.SOUTH);

    }//GEN-END:initComponents
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JPanel colorsPanel;
    private javax.swing.JButton drawerBgButton;
    private javax.swing.JLabel drawerBgLabel;
    private javax.swing.JButton helpButton;
    private javax.swing.JRadioButton imageAndNameRadio;
    private javax.swing.JRadioButton imageOnlyRadio;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JTabbedPane jTabbedPane1;
    private javax.swing.JRadioButton nameOnlyRadio;
    private javax.swing.JButton okayButton;
    private javax.swing.ButtonGroup showGroup;
    private javax.swing.JLabel sizeLabel;
    private javax.swing.JPanel sizePanel;
    private javax.swing.JSlider sizeSlider;
    private javax.swing.JPanel thumbnailsPanel;
    private javax.swing.JButton windowBgButton;
    private javax.swing.JLabel windowBgLabel;
    // End of variables declaration//GEN-END:variables
    
}
