/**
 * @(#)AccessibleTest.java  1.0  March 17, 2008
 *
 * Copyright (c) 2008 Werner Randelshofer
 * Staldenmattweg 2, CH-6405 Immensee, Switzerland
 * All rights reserved.
 *
 * The copyright of this software is owned by Werner Randelshofer. 
 * You may not use, copy or modify this software, except in  
 * accordance with the license agreement you entered into with  
 * Werner Randelshofer. For details see accompanying license terms. 
 */
package test;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.*;

/**
 * AccessibleTest.
 *
 * @author Werner Randelshofer
 * @version 1.0 AccessibleTest Created.
 */
public class AccessibleTest extends javax.swing.JPanel {

    /** Creates new form. */
    public AccessibleTest() {
        initComponents();

        JFileChooser fc = new JFileChooser();
        System.out.println(fc.getAccessibleContext().getAccessibleChildrenCount());

        JOptionPane op = new JOptionPane();
        System.out.println(op.getAccessibleContext().getAccessibleChildrenCount());
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(
                new Runnable() {
                    public void run() {
                        try {
                            UIManager.setLookAndFeel("ch.randelshofer.quaqua.QuaquaLookAndFeel");
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                        JFrame f = new JFrame("Accessible Test");
                        f.getContentPane().add(new AccessibleTest());
                        f.pack();
                        f.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
                        f.setVisible(true);
                    }
                });
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        button1 = new java.awt.Button();

        button1.setLabel("button1");
        add(button1);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private java.awt.Button button1;
    // End of variables declaration//GEN-END:variables
}
