/*
 * Decompiled with CFR 0.152.
 */
package net.sf.wraplog;

import net.sf.wraplog.LoggingException;

public abstract class AbstractLogger {
    private int level = 0;
    private int loggedMessageCount;

    protected void checkLevel(int n, String string) {
        String string2 = string == null ? "level" : string;
        if (n < 0 || n > 3) {
            throw new IllegalArgumentException(string2 + " must be one of: Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR");
        }
    }

    public void debug(String string) {
        this.debug(string, null);
    }

    public void debug(String string, Throwable throwable) {
        this.log(0, string, throwable);
    }

    public void error(String string) {
        this.error(string, null);
    }

    public void error(String string, Throwable throwable) {
        this.log(3, string, throwable);
    }

    public int getLevel() {
        return this.level;
    }

    public int getLoggedMessageCount() {
        return this.loggedMessageCount;
    }

    public void info(String string) {
        this.info(string, null);
    }

    public void info(String string, Throwable throwable) {
        this.log(1, string, throwable);
    }

    public boolean isEnabled(int n) {
        this.checkLevel(this.level, null);
        return n >= this.level;
    }

    protected abstract void reallyLog(int var1, String var2, Throwable var3) throws Exception;

    public void log(int n, String string) {
        this.log(n, string, null);
    }

    public void log(int n, String string, Throwable throwable) {
        if (this.isEnabled(n)) {
            try {
                this.reallyLog(n, string, throwable);
                ++this.loggedMessageCount;
            }
            catch (Exception exception) {
                throw new LoggingException("cannot log message: " + string, exception);
            }
        }
    }

    public void setLevel(int n) {
        if (this.level < 0 && this.level > 3) {
            throw new IllegalArgumentException("newLevel must be one of: Level.DEBUG, Level.INFO, Level.WARN, Level.ERROR");
        }
        this.level = n;
    }

    public void warn(String string) {
        this.warn(string, null);
    }

    public boolean isDebugEnabled() {
        return this.isEnabled(0);
    }

    public boolean isInfoEnabled() {
        return this.isEnabled(1);
    }

    public boolean isWarnEnabled() {
        return this.isEnabled(2);
    }

    public boolean isErrorEnabled() {
        return this.isEnabled(3);
    }

    public void warn(String string, Throwable throwable) {
        this.log(2, string, throwable);
    }
}

