/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.misc;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.misc.StandardUnixBrowser;
import edu.stanford.ejalbert.launching.misc.UnixNetscapeBrowserLaunching;
import net.sf.wraplog.AbstractLogger;

public class SunOSBrowserLaunching
extends UnixNetscapeBrowserLaunching {
    public static final String CONFIGFILE_SUNOS = "/edu/stanford/ejalbert/launching/misc/sunOSConfig.properties";

    public SunOSBrowserLaunching(AbstractLogger abstractLogger) {
        super(abstractLogger, CONFIGFILE_SUNOS);
    }

    public void openUrl(String string) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            this.logger.info(string);
            String string2 = System.getProperty("edu.stanford.ejalbert.preferred.browser", null);
            StandardUnixBrowser standardUnixBrowser = this.getBrowser("Default");
            if (string2 != null) {
                this.logger.info("browser pref defined in system prop. Failing over to super.openUrl() method");
                super.openUrl(string);
            } else if (standardUnixBrowser == null) {
                this.logger.info("no default browser defined. Failing over to super.openUrl() method");
                super.openUrl(string);
            } else {
                this.logger.info(standardUnixBrowser.getBrowserDisplayName());
                Process process = Runtime.getRuntime().exec(standardUnixBrowser.getArgsForStartingBrowser(string));
                process.waitFor();
            }
        }
        catch (Exception exception) {
            throw new BrowserLaunchingExecutionException(exception);
        }
    }
}

