/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.macos;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.macos.MacOsBrowserLaunching;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MacOs3_1BrowserLaunching
extends MacOsBrowserLaunching {
    private Method openURL;

    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            Class<?> clazz = Class.forName("com.apple.mrj.MRJFileUtils");
            this.openURL = clazz.getDeclaredMethod("openURL", String.class);
        }
        catch (Exception exception) {
            throw new BrowserLaunchingInitializingException(exception);
        }
    }

    public void openUrl(String string) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        try {
            this.openURL.invoke(null, string);
        }
        catch (Exception exception) {
            throw new BrowserLaunchingExecutionException(exception);
        }
    }

    public List getBrowserList() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("Default");
        return arrayList;
    }
}

