/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert.launching.macos;

import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.launching.macos.MacOsBrowserLaunching;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class MacOs2_0BrowserLaunching
extends MacOsBrowserLaunching {
    private static final String GURL_EVENT = "GURL";
    private Class aeDescClass;
    private Constructor aeTargetConstructor;
    private Constructor appleEventConstructor;
    private Constructor aeDescConstructor;
    private Method makeOSType;
    private Method putParameter;
    private Method sendNoReply;
    private Integer keyDirectObject;
    private Integer kAutoGenerateReturnID;
    private Integer kAnyTransactionID;

    public void initialize() throws BrowserLaunchingInitializingException {
        try {
            Class<?> clazz = Class.forName("com.apple.MacOS.AETarget");
            Class<?> clazz2 = Class.forName("com.apple.MacOS.OSUtils");
            Class<?> clazz3 = Class.forName("com.apple.MacOS.AppleEvent");
            Class<?> clazz4 = Class.forName("com.apple.MacOS.ae");
            this.aeDescClass = Class.forName("com.apple.MacOS.AEDesc");
            this.aeTargetConstructor = clazz.getDeclaredConstructor(Integer.TYPE);
            this.appleEventConstructor = clazz3.getDeclaredConstructor(Integer.TYPE, Integer.TYPE, clazz, Integer.TYPE, Integer.TYPE);
            this.aeDescConstructor = this.aeDescClass.getDeclaredConstructor(String.class);
            this.makeOSType = clazz2.getDeclaredMethod("makeOSType", String.class);
            this.putParameter = clazz3.getDeclaredMethod("putParameter", Integer.TYPE, this.aeDescClass);
            this.sendNoReply = clazz3.getDeclaredMethod("sendNoReply", new Class[0]);
            Field field = clazz4.getDeclaredField("keyDirectObject");
            this.keyDirectObject = (Integer)field.get(null);
            Field field2 = clazz3.getDeclaredField("kAutoGenerateReturnID");
            this.kAutoGenerateReturnID = (Integer)field2.get(null);
            Field field3 = clazz3.getDeclaredField("kAnyTransactionID");
            this.kAnyTransactionID = (Integer)field3.get(null);
        }
        catch (Exception exception) {
            throw new BrowserLaunchingInitializingException(exception);
        }
    }

    private Object getBrowser() throws BrowserLaunchingInitializingException {
        try {
            Integer n = (Integer)this.makeOSType.invoke(null, "MACS");
            Object t = this.aeTargetConstructor.newInstance(n);
            Integer n2 = (Integer)this.makeOSType.invoke(null, GURL_EVENT);
            Object t2 = this.appleEventConstructor.newInstance(n2, n2, t, this.kAutoGenerateReturnID, this.kAnyTransactionID);
            return t2;
        }
        catch (Exception exception) {
            throw new BrowserLaunchingInitializingException(exception);
        }
    }

    public void openUrl(String string) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        Object object = this.getBrowser();
        Object var3_3 = null;
        try {
            var3_3 = this.aeDescConstructor.newInstance(string);
            this.putParameter.invoke(object, this.keyDirectObject, var3_3);
            this.sendNoReply.invoke(object, new Object[0]);
        }
        catch (Exception exception) {
            throw new BrowserLaunchingExecutionException(exception);
        }
        finally {
            var3_3 = null;
            object = null;
        }
    }

    public List getBrowserList() {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add("Default");
        return arrayList;
    }
}

