/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert;

import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherErrorHandler;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import java.util.List;
import net.sf.wraplog.AbstractLogger;

class BrowserLauncherRunner
implements Runnable {
    private final List targetBrowsers;
    private final String targetBrowser;
    private final String url;
    private final BrowserLauncherErrorHandler errorHandler;
    private final IBrowserLaunching launcher;
    private final AbstractLogger logger;

    BrowserLauncherRunner(IBrowserLaunching iBrowserLaunching, String string, AbstractLogger abstractLogger, BrowserLauncherErrorHandler browserLauncherErrorHandler) {
        this(iBrowserLaunching, null, null, string, abstractLogger, browserLauncherErrorHandler);
    }

    BrowserLauncherRunner(IBrowserLaunching iBrowserLaunching, String string, String string2, AbstractLogger abstractLogger, BrowserLauncherErrorHandler browserLauncherErrorHandler) {
        this(iBrowserLaunching, string, null, string2, abstractLogger, browserLauncherErrorHandler);
    }

    BrowserLauncherRunner(IBrowserLaunching iBrowserLaunching, List list, String string, AbstractLogger abstractLogger, BrowserLauncherErrorHandler browserLauncherErrorHandler) {
        this(iBrowserLaunching, null, list, string, abstractLogger, browserLauncherErrorHandler);
    }

    private BrowserLauncherRunner(IBrowserLaunching iBrowserLaunching, String string, List list, String string2, AbstractLogger abstractLogger, BrowserLauncherErrorHandler browserLauncherErrorHandler) {
        if (iBrowserLaunching == null) {
            throw new IllegalArgumentException("launcher cannot be null.");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("url cannot be null.");
        }
        if (browserLauncherErrorHandler == null) {
            throw new IllegalArgumentException("errorHandler cannot be null.");
        }
        if (abstractLogger == null) {
            throw new IllegalArgumentException("logger cannot be null");
        }
        this.targetBrowsers = list;
        this.launcher = iBrowserLaunching;
        this.url = string2;
        this.targetBrowser = string;
        this.errorHandler = browserLauncherErrorHandler;
        this.logger = abstractLogger;
    }

    public void run() {
        try {
            if (this.targetBrowser != null) {
                this.launcher.openUrl(this.targetBrowser, this.url);
            } else if (this.targetBrowsers != null) {
                this.launcher.openUrl(this.targetBrowsers, this.url);
            } else {
                this.launcher.openUrl(this.url);
            }
        }
        catch (Exception exception) {
            this.logger.error("fatal error opening url", exception);
            this.errorHandler.handleException(exception);
        }
    }
}

