/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.ejalbert;

import edu.stanford.ejalbert.BrowserLauncherRunner;
import edu.stanford.ejalbert.exception.BrowserLaunchingExecutionException;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherDefaultErrorHandler;
import edu.stanford.ejalbert.exceptionhandler.BrowserLauncherErrorHandler;
import edu.stanford.ejalbert.launching.BrowserLaunchingFactory;
import edu.stanford.ejalbert.launching.IBrowserLaunching;
import java.util.List;
import net.sf.wraplog.AbstractLogger;
import net.sf.wraplog.NoneLogger;

public class BrowserLauncher {
    public static final String BROWSER_SYSTEM_PROPERTY = "edu.stanford.ejalbert.preferred.browser";
    private final IBrowserLaunching launching;
    private AbstractLogger logger;
    private BrowserLauncherErrorHandler errorHandler;

    public BrowserLauncher() throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        this(null, null);
    }

    public BrowserLauncher(AbstractLogger abstractLogger) throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        this(abstractLogger, null);
    }

    public BrowserLauncher(AbstractLogger abstractLogger, BrowserLauncherErrorHandler browserLauncherErrorHandler) throws BrowserLaunchingInitializingException, UnsupportedOperatingSystemException {
        if (abstractLogger == null) {
            abstractLogger = new NoneLogger();
        }
        this.logger = abstractLogger;
        if (browserLauncherErrorHandler == null) {
            browserLauncherErrorHandler = new BrowserLauncherDefaultErrorHandler();
        }
        this.errorHandler = browserLauncherErrorHandler;
        this.launching = this.initBrowserLauncher();
    }

    private IBrowserLaunching initBrowserLauncher() throws UnsupportedOperatingSystemException, BrowserLaunchingInitializingException {
        if (this.logger == null) {
            throw new IllegalArgumentException("the logger cannot be null at this point.");
        }
        IBrowserLaunching iBrowserLaunching = BrowserLaunchingFactory.createSystemBrowserLaunching(this.logger);
        iBrowserLaunching.initialize();
        return iBrowserLaunching;
    }

    public static void openURL(String string) throws UnsupportedOperatingSystemException, BrowserLaunchingExecutionException, BrowserLaunchingInitializingException {
        BrowserLauncher browserLauncher = new BrowserLauncher(null);
        browserLauncher.openURLinBrowser(string);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("Usage: java -jar BrowserLauncher.jar url_value");
        } else {
            try {
                BrowserLauncher browserLauncher = new BrowserLauncher(null);
                browserLauncher.openURLinBrowser(stringArray[0]);
            }
            catch (BrowserLaunchingInitializingException browserLaunchingInitializingException) {
                browserLaunchingInitializingException.printStackTrace();
            }
            catch (UnsupportedOperatingSystemException unsupportedOperatingSystemException) {
                unsupportedOperatingSystemException.printStackTrace();
            }
        }
    }

    public AbstractLogger getLogger() {
        return this.logger;
    }

    public List getBrowserList() {
        return this.launching.getBrowserList();
    }

    public void openURLinBrowser(String string) {
        BrowserLauncherRunner browserLauncherRunner = new BrowserLauncherRunner(this.launching, string, this.logger, this.errorHandler);
        Thread thread = new Thread(browserLauncherRunner);
        thread.start();
    }

    public void openURLinBrowser(String string, String string2) {
        BrowserLauncherRunner browserLauncherRunner = new BrowserLauncherRunner(this.launching, string, string2, this.logger, this.errorHandler);
        Thread thread = new Thread(browserLauncherRunner);
        thread.start();
    }

    public void openURLinBrowser(List list, String string) {
        BrowserLauncherRunner browserLauncherRunner = new BrowserLauncherRunner(this.launching, list, string, this.logger, this.errorHandler);
        Thread thread = new Thread(browserLauncherRunner);
        thread.start();
    }

    public boolean getNewWindowPolicy() {
        return this.launching.getNewWindowPolicy();
    }

    public void setNewWindowPolicy(boolean bl) {
        this.launching.setNewWindowPolicy(bl);
    }
}

