/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import org.jconfig.utils.ResourceLocator;

public class ConfigurationUtils {
    private ConfigurationUtils() {
    }

    public static File getFileFromInputStream(String fileName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        URL url = cl.getResource(fileName);
        if (url != null) {
            try {
                String filename = URLDecoder.decode(url.getFile(), "UTF8");
                File file = new File(filename);
                return file;
            }
            catch (UnsupportedEncodingException e) {
                return null;
            }
        }
        return null;
    }

    public static File getFile(String filename) throws IOException {
        ResourceLocator locator = new ResourceLocator(filename);
        return locator.getFile();
    }

    public static String getConfigProperty(String name) {
        return ConfigurationUtils.getConfigProperty(name, null);
    }

    public static String getConfigProperty(String name, String defaultValue) {
        String val = System.getProperty(name);
        if (val == null) {
            try {
                ResourceLocator locator = new ResourceLocator("jconfig.properties");
                InputStream is = locator.getInputStream();
                if (is != null) {
                    Properties jcfProperties = new Properties();
                    jcfProperties.load(is);
                    val = jcfProperties.getProperty(name);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (val == null) {
            val = defaultValue;
        }
        return val;
    }
}

