/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.server;

import java.net.Socket;
import org.jconfig.server.ProtocolHandler;
import org.jconfig.server.ServerContext;

public class WorkerThread
extends Thread {
    private ProtocolHandler handler = null;
    private boolean active = false;
    private Socket socket = null;
    private ServerContext serverContext;

    public WorkerThread(ThreadGroup tg, String threadName) {
        super(tg, null, threadName);
    }

    public synchronized void execute(Socket socket, ProtocolHandler handler, ServerContext serverContext) {
        if (this.handler != null) {
            throw new IllegalStateException("Already running");
        }
        this.socket = socket;
        this.handler = handler;
        this.serverContext = serverContext;
        this.notifyAll();
        if (!this.active) {
            this.active = true;
            this.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.active) {
            if (this.handler != null) {
                try {
                    this.handler.execute(this.socket, this.serverContext);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.handler = null;
            this.socket = null;
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                while (this.active && this.handler == null) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }
}

