/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jconfig.server.Request;
import org.jconfig.utils.ResourceLocator;

public class Response {
    private static final int BUFFER_SIZE = 1024;
    Request request;
    OutputStream output;

    public Response(OutputStream output) {
        this.output = output;
    }

    public void setRequest(Request request) {
        this.request = request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendStaticResource(String fileName) throws IOException {
        byte[] bytes = new byte[1024];
        FileInputStream fis = null;
        try {
            File file = new File(fileName);
            if (file.exists()) {
                fis = new FileInputStream(file);
                int ch = fis.read(bytes, 0, 1024);
                while (ch != -1) {
                    this.output.write(bytes, 0, ch);
                    ch = fis.read(bytes, 0, 1024);
                }
            } else {
                System.out.println("Cannot find file:" + fileName);
                String errorMessage = "HTTP/1.1 404 File Not Found\r\nContent-Type: text/html\r\nContent-Length: 23\r\n\r\n<h1>File Not Found</h1>";
                this.output.write(errorMessage.getBytes());
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendStaticResource() throws IOException {
        byte[] bytes = new byte[1024];
        FileInputStream fis = null;
        String uri = this.request.getUri();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        uri = uri + ".xml";
        try {
            File file = new ResourceLocator(uri).getFile();
            if (file.exists()) {
                fis = new FileInputStream(file);
                int ch = fis.read(bytes, 0, 1024);
                while (ch != -1) {
                    this.output.write(bytes, 0, ch);
                    ch = fis.read(bytes, 0, 1024);
                }
            } else {
                String errorMessage = "HTTP/1.1 404 File Not Found\r\nContent-Type: text/html\r\nContent-Length: 23\r\n\r\n<h1>File Not Found</h1>";
                this.output.write(errorMessage.getBytes());
            }
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }
}

