/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.server;

import org.jconfig.server.BaseServer;
import org.jconfig.server.ConfigurationServerMBean;
import org.jconfig.server.ServerContext;

public class ConfigurationServer
implements ConfigurationServerMBean {
    private BaseServer server;
    private int port = 8234;
    private String documentRoot;
    private boolean daemon = false;
    static /* synthetic */ Class class$org$jconfig$server$ConfigProtocolHandler;

    public ConfigurationServer(int port, String documentRoot) {
        this.port = port;
        this.documentRoot = documentRoot;
        this.start();
    }

    public ConfigurationServer() {
    }

    public void shutdown() {
        if (this.server != null) {
            this.server.shutdown();
        }
    }

    public void start() {
        ServerContext serverContext = new ServerContext();
        serverContext.setDocumentRoot(this.documentRoot);
        this.server = new BaseServer(this.port, class$org$jconfig$server$ConfigProtocolHandler == null ? (class$org$jconfig$server$ConfigProtocolHandler = ConfigurationServer.class$("org.jconfig.server.ConfigProtocolHandler")) : class$org$jconfig$server$ConfigProtocolHandler, serverContext);
        this.server.setAsDaemon(this.daemon);
        this.server.start();
        System.out.println("Server started");
        System.out.println("Port:" + this.port);
        System.out.println("Documentroot:" + this.documentRoot);
    }

    public static void main(String[] args) {
        ConfigurationServer cs = new ConfigurationServer();
        cs.setDocRootFromArgs(args);
        cs.setPortFromArgs(args);
        cs.startServer();
    }

    public String getDocumentRoot() {
        return this.documentRoot;
    }

    public int getPort() {
        return this.port;
    }

    public void setDocumentRoot(String docRoot) {
        this.documentRoot = docRoot;
    }

    public void setPort(int port) {
        this.port = port;
    }

    private void setDocRootFromArgs(String[] args) {
        String dr = this.getArgument(args, "-docroot");
        this.documentRoot = dr != null ? dr : System.getProperty("java.io.tmpdir");
    }

    private void setPortFromArgs(String[] args) {
        String myPort = this.getArgument(args, "-port");
        if (myPort != null) {
            try {
                this.port = Integer.parseInt(myPort);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String getArgument(String[] args, String param) {
        String ret = null;
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].equals(param) || i + 1 > args.length) continue;
            ret = args[i + 1];
        }
        return ret;
    }

    public void startServer() {
        this.start();
    }

    public void stopServer() {
        this.shutdown();
    }

    public void setDaemon(boolean isDaemon) {
        this.daemon = isDaemon;
    }

    public void setStarted(boolean shouldStart) {
        if (shouldStart) {
            this.startServer();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

