/*
 * Decompiled with CFR 0.152.
 */
package org.jconfig.server;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.jconfig.server.ProtocolHandler;
import org.jconfig.server.Request;
import org.jconfig.server.Response;
import org.jconfig.server.ServerContext;

public class ConfigProtocolHandler
implements ProtocolHandler {
    public void execute(Socket socket) {
        try {
            InputStream input = null;
            OutputStream output = null;
            input = socket.getInputStream();
            output = socket.getOutputStream();
            Request request = new Request(input);
            request.parse(socket);
            Response response = new Response(output);
            response.setRequest(request);
            response.sendStaticResource();
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getFileName(Request request, ServerContext serverContext) {
        String uri = request.getUri();
        String ip_adr = request.getHostAddress();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        uri = uri + ".xml";
        String tmp = serverContext.getDocumentRoot() + ip_adr + "_" + uri;
        if (this.checkFile(tmp)) {
            return tmp;
        }
        ip_adr = ip_adr.substring(0, ip_adr.lastIndexOf("."));
        tmp = serverContext.getDocumentRoot() + ip_adr + "_" + uri;
        if (this.checkFile(tmp)) {
            return tmp;
        }
        ip_adr = ip_adr.substring(0, ip_adr.lastIndexOf("."));
        tmp = serverContext.getDocumentRoot() + ip_adr + "_" + uri;
        if (this.checkFile(tmp)) {
            return tmp;
        }
        ip_adr = ip_adr.substring(0, ip_adr.lastIndexOf("."));
        tmp = serverContext.getDocumentRoot() + ip_adr + "_" + uri;
        if (this.checkFile(tmp)) {
            return tmp;
        }
        tmp = serverContext.getDocumentRoot() + uri;
        if (this.checkFile(tmp)) {
            return tmp;
        }
        uri = serverContext.getDocumentRoot() + uri;
        return uri;
    }

    private boolean checkFile(String name) {
        File file = new File(name);
        return file.exists();
    }

    public void execute(Socket socket, ServerContext serverContext) {
        try {
            InputStream input = null;
            OutputStream output = null;
            input = socket.getInputStream();
            output = socket.getOutputStream();
            Request request = new Request(input);
            request.parse(socket);
            Response response = new Response(output);
            response.setRequest(request);
            String filename = this.getFileName(request, serverContext);
            response.sendStaticResource(filename);
            socket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

